<?php
/**
 * Internationalization: Countries
 *
 * @package SimplePay\Core
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.0.0
 */

namespace SimplePay\Core\i18n;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Returns a list of country codes and countries.
 *
 * @since 3.9.0
 *
 * @return array $countries A list of the available countries
 */
function get_countries() {
	$countries = array(
		'AF' => __( 'Afghanistan', 'stripe' ),
		'AX' => __( 'Åland Islands', 'stripe' ),
		'AL' => __( 'Albania', 'stripe' ),
		'DZ' => __( 'Algeria', 'stripe' ),
		'AS' => __( 'American Samoa', 'stripe' ),
		'AD' => __( 'Andorra', 'stripe' ),
		'AO' => __( 'Angola', 'stripe' ),
		'AI' => __( 'Anguilla', 'stripe' ),
		'AQ' => __( 'Antarctica', 'stripe' ),
		'AG' => __( 'Antigua and Barbuda', 'stripe' ),
		'AR' => __( 'Argentina', 'stripe' ),
		'AM' => __( 'Armenia', 'stripe' ),
		'AW' => __( 'Aruba', 'stripe' ),
		'AU' => __( 'Australia', 'stripe' ),
		'AT' => __( 'Austria', 'stripe' ),
		'AZ' => __( 'Azerbaijan', 'stripe' ),
		'BS' => __( 'Bahamas', 'stripe' ),
		'BH' => __( 'Bahrain', 'stripe' ),
		'BD' => __( 'Bangladesh', 'stripe' ),
		'BB' => __( 'Barbados', 'stripe' ),
		'BY' => __( 'Belarus', 'stripe' ),
		'BE' => __( 'Belgium', 'stripe' ),
		'PW' => __( 'Belau', 'stripe' ),
		'BZ' => __( 'Belize', 'stripe' ),
		'BJ' => __( 'Benin', 'stripe' ),
		'BM' => __( 'Bermuda', 'stripe' ),
		'BT' => __( 'Bhutan', 'stripe' ),
		'BO' => __( 'Bolivia', 'stripe' ),
		'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'stripe' ),
		'BA' => __( 'Bosnia and Herzegovina', 'stripe' ),
		'BW' => __( 'Botswana', 'stripe' ),
		'BV' => __( 'Bouvet Island', 'stripe' ),
		'BR' => __( 'Brazil', 'stripe' ),
		'IO' => __( 'British Indian Ocean Territory', 'stripe' ),
		'BN' => __( 'Brunei', 'stripe' ),
		'BG' => __( 'Bulgaria', 'stripe' ),
		'BF' => __( 'Burkina Faso', 'stripe' ),
		'BI' => __( 'Burundi', 'stripe' ),
		'KH' => __( 'Cambodia', 'stripe' ),
		'CM' => __( 'Cameroon', 'stripe' ),
		'CA' => __( 'Canada', 'stripe' ),
		'CV' => __( 'Cape Verde', 'stripe' ),
		'KY' => __( 'Cayman Islands', 'stripe' ),
		'CF' => __( 'Central African Republic', 'stripe' ),
		'TD' => __( 'Chad', 'stripe' ),
		'CL' => __( 'Chile', 'stripe' ),
		'CN' => __( 'China', 'stripe' ),
		'CX' => __( 'Christmas Island', 'stripe' ),
		'CC' => __( 'Cocos (Keeling) Islands', 'stripe' ),
		'CO' => __( 'Colombia', 'stripe' ),
		'KM' => __( 'Comoros', 'stripe' ),
		'CG' => __( 'Congo (Brazzaville)', 'stripe' ),
		'CD' => __( 'Congo (Kinshasa)', 'stripe' ),
		'CK' => __( 'Cook Islands', 'stripe' ),
		'CR' => __( 'Costa Rica', 'stripe' ),
		'HR' => __( 'Croatia', 'stripe' ),
		'CU' => __( 'Cuba', 'stripe' ),
		'CW' => __( 'Cura&ccedil;ao', 'stripe' ),
		'CY' => __( 'Cyprus', 'stripe' ),
		'CZ' => __( 'Czech Republic', 'stripe' ),
		'DK' => __( 'Denmark', 'stripe' ),
		'DJ' => __( 'Djibouti', 'stripe' ),
		'DM' => __( 'Dominica', 'stripe' ),
		'DO' => __( 'Dominican Republic', 'stripe' ),
		'EC' => __( 'Ecuador', 'stripe' ),
		'EG' => __( 'Egypt', 'stripe' ),
		'SV' => __( 'El Salvador', 'stripe' ),
		'GQ' => __( 'Equatorial Guinea', 'stripe' ),
		'ER' => __( 'Eritrea', 'stripe' ),
		'EE' => __( 'Estonia', 'stripe' ),
		'ET' => __( 'Ethiopia', 'stripe' ),
		'FK' => __( 'Falkland Islands', 'stripe' ),
		'FO' => __( 'Faroe Islands', 'stripe' ),
		'FJ' => __( 'Fiji', 'stripe' ),
		'FI' => __( 'Finland', 'stripe' ),
		'FR' => __( 'France', 'stripe' ),
		'GF' => __( 'French Guiana', 'stripe' ),
		'PF' => __( 'French Polynesia', 'stripe' ),
		'TF' => __( 'French Southern Territories', 'stripe' ),
		'GA' => __( 'Gabon', 'stripe' ),
		'GM' => __( 'Gambia', 'stripe' ),
		'GE' => __( 'Georgia', 'stripe' ),
		'DE' => __( 'Germany', 'stripe' ),
		'GH' => __( 'Ghana', 'stripe' ),
		'GI' => __( 'Gibraltar', 'stripe' ),
		'GR' => __( 'Greece', 'stripe' ),
		'GL' => __( 'Greenland', 'stripe' ),
		'GD' => __( 'Grenada', 'stripe' ),
		'GP' => __( 'Guadeloupe', 'stripe' ),
		'GU' => __( 'Guam', 'stripe' ),
		'GT' => __( 'Guatemala', 'stripe' ),
		'GG' => __( 'Guernsey', 'stripe' ),
		'GN' => __( 'Guinea', 'stripe' ),
		'GW' => __( 'Guinea-Bissau', 'stripe' ),
		'GY' => __( 'Guyana', 'stripe' ),
		'HT' => __( 'Haiti', 'stripe' ),
		'HM' => __( 'Heard Island and McDonald Islands', 'stripe' ),
		'HN' => __( 'Honduras', 'stripe' ),
		'HK' => __( 'Hong Kong', 'stripe' ),
		'HU' => __( 'Hungary', 'stripe' ),
		'IS' => __( 'Iceland', 'stripe' ),
		'IN' => __( 'India', 'stripe' ),
		'ID' => __( 'Indonesia', 'stripe' ),
		'IR' => __( 'Iran', 'stripe' ),
		'IQ' => __( 'Iraq', 'stripe' ),
		'IE' => __( 'Ireland', 'stripe' ),
		'IM' => __( 'Isle of Man', 'stripe' ),
		'IL' => __( 'Israel', 'stripe' ),
		'IT' => __( 'Italy', 'stripe' ),
		'CI' => __( 'Ivory Coast', 'stripe' ),
		'JM' => __( 'Jamaica', 'stripe' ),
		'JP' => __( 'Japan', 'stripe' ),
		'JE' => __( 'Jersey', 'stripe' ),
		'JO' => __( 'Jordan', 'stripe' ),
		'KZ' => __( 'Kazakhstan', 'stripe' ),
		'KE' => __( 'Kenya', 'stripe' ),
		'KI' => __( 'Kiribati', 'stripe' ),
		'KW' => __( 'Kuwait', 'stripe' ),
		'KG' => __( 'Kyrgyzstan', 'stripe' ),
		'LA' => __( 'Laos', 'stripe' ),
		'LV' => __( 'Latvia', 'stripe' ),
		'LB' => __( 'Lebanon', 'stripe' ),
		'LS' => __( 'Lesotho', 'stripe' ),
		'LR' => __( 'Liberia', 'stripe' ),
		'LY' => __( 'Libya', 'stripe' ),
		'LI' => __( 'Liechtenstein', 'stripe' ),
		'LT' => __( 'Lithuania', 'stripe' ),
		'LU' => __( 'Luxembourg', 'stripe' ),
		'MO' => __( 'Macao', 'stripe' ),
		'MK' => __( 'North Macedonia', 'stripe' ),
		'MG' => __( 'Madagascar', 'stripe' ),
		'MW' => __( 'Malawi', 'stripe' ),
		'MY' => __( 'Malaysia', 'stripe' ),
		'MV' => __( 'Maldives', 'stripe' ),
		'ML' => __( 'Mali', 'stripe' ),
		'MT' => __( 'Malta', 'stripe' ),
		'MH' => __( 'Marshall Islands', 'stripe' ),
		'MQ' => __( 'Martinique', 'stripe' ),
		'MR' => __( 'Mauritania', 'stripe' ),
		'MU' => __( 'Mauritius', 'stripe' ),
		'YT' => __( 'Mayotte', 'stripe' ),
		'MX' => __( 'Mexico', 'stripe' ),
		'FM' => __( 'Micronesia', 'stripe' ),
		'MD' => __( 'Moldova', 'stripe' ),
		'MC' => __( 'Monaco', 'stripe' ),
		'MN' => __( 'Mongolia', 'stripe' ),
		'ME' => __( 'Montenegro', 'stripe' ),
		'MS' => __( 'Montserrat', 'stripe' ),
		'MA' => __( 'Morocco', 'stripe' ),
		'MZ' => __( 'Mozambique', 'stripe' ),
		'MM' => __( 'Myanmar', 'stripe' ),
		'NA' => __( 'Namibia', 'stripe' ),
		'NR' => __( 'Nauru', 'stripe' ),
		'NP' => __( 'Nepal', 'stripe' ),
		'NL' => __( 'Netherlands', 'stripe' ),
		'NC' => __( 'New Caledonia', 'stripe' ),
		'NZ' => __( 'New Zealand', 'stripe' ),
		'NI' => __( 'Nicaragua', 'stripe' ),
		'NE' => __( 'Niger', 'stripe' ),
		'NG' => __( 'Nigeria', 'stripe' ),
		'NU' => __( 'Niue', 'stripe' ),
		'NF' => __( 'Norfolk Island', 'stripe' ),
		'MP' => __( 'Northern Mariana Islands', 'stripe' ),
		'KP' => __( 'North Korea', 'stripe' ),
		'NO' => __( 'Norway', 'stripe' ),
		'OM' => __( 'Oman', 'stripe' ),
		'PK' => __( 'Pakistan', 'stripe' ),
		'PS' => __( 'Palestinian Territory', 'stripe' ),
		'PA' => __( 'Panama', 'stripe' ),
		'PG' => __( 'Papua New Guinea', 'stripe' ),
		'PY' => __( 'Paraguay', 'stripe' ),
		'PE' => __( 'Peru', 'stripe' ),
		'PH' => __( 'Philippines', 'stripe' ),
		'PN' => __( 'Pitcairn', 'stripe' ),
		'PL' => __( 'Poland', 'stripe' ),
		'PT' => __( 'Portugal', 'stripe' ),
		'PR' => __( 'Puerto Rico', 'stripe' ),
		'QA' => __( 'Qatar', 'stripe' ),
		'RE' => __( 'Reunion', 'stripe' ),
		'RO' => __( 'Romania', 'stripe' ),
		'RU' => __( 'Russia', 'stripe' ),
		'RW' => __( 'Rwanda', 'stripe' ),
		'BL' => __( 'Saint Barth&eacute;lemy', 'stripe' ),
		'SH' => __( 'Saint Helena', 'stripe' ),
		'KN' => __( 'Saint Kitts and Nevis', 'stripe' ),
		'LC' => __( 'Saint Lucia', 'stripe' ),
		'MF' => __( 'Saint Martin (French part)', 'stripe' ),
		'SX' => __( 'Saint Martin (Dutch part)', 'stripe' ),
		'PM' => __( 'Saint Pierre and Miquelon', 'stripe' ),
		'VC' => __( 'Saint Vincent and the Grenadines', 'stripe' ),
		'SM' => __( 'San Marino', 'stripe' ),
		'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'stripe' ),
		'SA' => __( 'Saudi Arabia', 'stripe' ),
		'SN' => __( 'Senegal', 'stripe' ),
		'RS' => __( 'Serbia', 'stripe' ),
		'SC' => __( 'Seychelles', 'stripe' ),
		'SL' => __( 'Sierra Leone', 'stripe' ),
		'SG' => __( 'Singapore', 'stripe' ),
		'SK' => __( 'Slovakia', 'stripe' ),
		'SI' => __( 'Slovenia', 'stripe' ),
		'SB' => __( 'Solomon Islands', 'stripe' ),
		'SO' => __( 'Somalia', 'stripe' ),
		'ZA' => __( 'South Africa', 'stripe' ),
		'GS' => __( 'South Georgia/Sandwich Islands', 'stripe' ),
		'KR' => __( 'South Korea', 'stripe' ),
		'SS' => __( 'South Sudan', 'stripe' ),
		'ES' => __( 'Spain', 'stripe' ),
		'LK' => __( 'Sri Lanka', 'stripe' ),
		'SD' => __( 'Sudan', 'stripe' ),
		'SR' => __( 'Suriname', 'stripe' ),
		'SJ' => __( 'Svalbard and Jan Mayen', 'stripe' ),
		'SZ' => __( 'Eswatini', 'stripe' ),
		'SE' => __( 'Sweden', 'stripe' ),
		'CH' => __( 'Switzerland', 'stripe' ),
		'SY' => __( 'Syria', 'stripe' ),
		'TW' => __( 'Taiwan', 'stripe' ),
		'TJ' => __( 'Tajikistan', 'stripe' ),
		'TZ' => __( 'Tanzania', 'stripe' ),
		'TH' => __( 'Thailand', 'stripe' ),
		'TL' => __( 'Timor-Leste', 'stripe' ),
		'TG' => __( 'Togo', 'stripe' ),
		'TK' => __( 'Tokelau', 'stripe' ),
		'TO' => __( 'Tonga', 'stripe' ),
		'TT' => __( 'Trinidad and Tobago', 'stripe' ),
		'TN' => __( 'Tunisia', 'stripe' ),
		'TR' => __( 'Turkey', 'stripe' ),
		'TM' => __( 'Turkmenistan', 'stripe' ),
		'TC' => __( 'Turks and Caicos Islands', 'stripe' ),
		'TV' => __( 'Tuvalu', 'stripe' ),
		'UG' => __( 'Uganda', 'stripe' ),
		'UA' => __( 'Ukraine', 'stripe' ),
		'AE' => __( 'United Arab Emirates', 'stripe' ),
		'GB' => __( 'United Kingdom (UK)', 'stripe' ),
		'US' => __( 'United States (US)', 'stripe' ),
		'UM' => __( 'United States (US) Minor Outlying Islands', 'stripe' ),
		'UY' => __( 'Uruguay', 'stripe' ),
		'UZ' => __( 'Uzbekistan', 'stripe' ),
		'VU' => __( 'Vanuatu', 'stripe' ),
		'VA' => __( 'Vatican', 'stripe' ),
		'VE' => __( 'Venezuela', 'stripe' ),
		'VN' => __( 'Vietnam', 'stripe' ),
		'VG' => __( 'Virgin Islands (British)', 'stripe' ),
		'VI' => __( 'Virgin Islands (US)', 'stripe' ),
		'WF' => __( 'Wallis and Futuna', 'stripe' ),
		'EH' => __( 'Western Sahara', 'stripe' ),
		'WS' => __( 'Samoa', 'stripe' ),
		'YE' => __( 'Yemen', 'stripe' ),
		'ZM' => __( 'Zambia', 'stripe' ),
		'ZW' => __( 'Zimbabwe', 'stripe' ),
	);

	return apply_filters( 'simpay_countries', $countries );
}
