<?php

// File generated from our OpenAPI spec

namespace SimplePay\Vendor\Stripe\Capital;

/**
 * This is an object representing an offer of financing from SimplePay\Vendor\Stripe Capital to a
 * Connect subaccount.
 *
 * @property string $id A unique identifier for the financing object.
 * @property string $object The object type: financing_offer.
 * @property \SimplePay\Vendor\Stripe\StripeObject $accepted_terms This is an object representing the terms of an offer of financing from SimplePay\Vendor\Stripe Capital to a Connected account. This resource represents the terms accepted by the Connected account, which may differ from those offered.
 * @property string $account The ID of the merchant associated with this financing object.
 * @property int $created Time at which the offer was created. Given in seconds since unix epoch.
 * @property float $expires_after Time at which the offer expires. Given in seconds since unix epoch.
 * @property string $financing_type The type of financing being offered.
 * @property bool $livemode Has the value <code>true</code> if the object exists in live mode or the value <code>false</code> if the object exists in test mode.
 * @property \SimplePay\Vendor\Stripe\StripeObject $metadata Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
 * @property \SimplePay\Vendor\Stripe\StripeObject $offered_terms This is an object representing the terms of an offer of financing from SimplePay\Vendor\Stripe Capital to a Connected account. This resource represents both the terms offered to the Connected account.
 * @property string $product_type Financing product identifier.
 * @property string $replacement The ID of the financing offer that replaced this offer.
 * @property string $replacement_for The ID of the financing offer that this offer is a replacement for.
 * @property string $status The current status of the offer.
 * @property string $type See <a href="https://stripe.com/docs/api/capital/connect_financing_object#financing_offer_object-financing_type">financing_type</a>.
 */
class FinancingOffer extends \SimplePay\Vendor\Stripe\ApiResource
{
    const OBJECT_NAME = 'capital.financing_offer';

    use \SimplePay\Vendor\Stripe\ApiOperations\All;
    use \SimplePay\Vendor\Stripe\ApiOperations\Retrieve;

    const FINANCING_TYPE_CASH_ADVANCE = 'cash_advance';
    const FINANCING_TYPE_FLEX_LOAN = 'flex_loan';

    const PRODUCT_TYPE_REFILL = 'refill';
    const PRODUCT_TYPE_STANDARD = 'standard';

    const STATUS_ACCEPTED = 'accepted';
    const STATUS_CANCELED = 'canceled';
    const STATUS_COMPLETED = 'completed';
    const STATUS_DELIVERED = 'delivered';
    const STATUS_EXPIRED = 'expired';
    const STATUS_FULLY_REPAID = 'fully_repaid';
    const STATUS_PAID_OUT = 'paid_out';
    const STATUS_REJECTED = 'rejected';
    const STATUS_REPLACED = 'replaced';
    const STATUS_UNDELIVERED = 'undelivered';

    const TYPE_CASH_ADVANCE = 'cash_advance';
    const TYPE_FLEX_LOAN = 'flex_loan';

    /**
     * @param null|array $params
     * @param null|array|string $opts
     *
     * @throws \SimplePay\Vendor\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \SimplePay\Vendor\Stripe\Capital\FinancingOffer the marked financing offer
     */
    public function markDelivered($params = null, $opts = null)
    {
        $url = $this->instanceUrl() . '/mark_delivered';
        list($response, $opts) = $this->_request('post', $url, $params, $opts);
        $this->refreshFrom($response, $opts);

        return $this;
    }
}
