<?php

// File generated from our OpenAPI spec

namespace SimplePay\Vendor\Stripe;

/**
 * A quote phase describes the line items, coupons, and trialing status of a
 * subscription for a predefined time period.
 *
 * @property string $id Unique identifier for the object.
 * @property string $object String representing the object's type. Objects of the same type share the same value.
 * @property int $amount_subtotal Total before any discounts or taxes are applied.
 * @property int $amount_total Total after discounts and taxes are applied.
 * @property null|string $billing_cycle_anchor If set to <code>reset</code>, the billing_cycle_anchor of the subscription is set to the start of the phase when entering the phase. If unset, then the billing cycle anchor is automatically modified as needed when entering the phase. For more information, see the billing cycle <a href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
 * @property null|string $collection_method Either <code>charge_automatically</code>, or <code>send_invoice</code>. When charging automatically, SimplePay\Vendor\Stripe will attempt to pay the underlying subscription at the end of each billing cycle using the default source attached to the customer. When sending an invoice, SimplePay\Vendor\Stripe will email your customer an invoice with payment instructions and mark the subscription as <code>active</code>.
 * @property (string|\SimplePay\Vendor\Stripe\TaxRate)[] $default_tax_rates The default tax rates to apply to the subscription during this phase of the quote.
 * @property (string|\SimplePay\Vendor\Stripe\Discount)[] $discounts The stackable discounts that will be applied to the subscription on this phase. Subscription item discounts are applied before subscription discounts.
 * @property null|int $end_date The end of this phase of the quote
 * @property null|\SimplePay\Vendor\Stripe\StripeObject $invoice_settings The invoice settings applicable during this phase.
 * @property null|int $iterations Integer representing the multiplier applied to the price interval. For example, <code>iterations=2</code> applied to a price with <code>interval=month</code> and <code>interval_count=3</code> results in a phase of duration <code>2 * 3 months = 6 months</code>.
 * @property \SimplePay\Vendor\Stripe\Collection<\SimplePay\Vendor\Stripe\LineItem> $line_items A list of items the customer is being quoted for.
 * @property string $proration_behavior If the quote will prorate when transitioning to this phase. Possible values are <code>create_prorations</code> and <code>none</code>.
 * @property \SimplePay\Vendor\Stripe\StripeObject $total_details
 * @property null|bool $trial If set to true the entire phase is counted as a trial and the customer will not be charged for any recurring fees.
 * @property null|int $trial_end When the trial ends within the phase.
 */
class QuotePhase extends ApiResource
{
    const OBJECT_NAME = 'quote_phase';

    use ApiOperations\All;
    use ApiOperations\Retrieve;

    const BILLING_CYCLE_ANCHOR_RESET = 'reset';

    const COLLECTION_METHOD_CHARGE_AUTOMATICALLY = 'charge_automatically';
    const COLLECTION_METHOD_SEND_INVOICE = 'send_invoice';

    const PRORATION_BEHAVIOR_ALWAYS_INVOICE = 'always_invoice';
    const PRORATION_BEHAVIOR_CREATE_PRORATIONS = 'create_prorations';
    const PRORATION_BEHAVIOR_NONE = 'none';

    /**
     * @param string $id
     * @param null|array $params
     * @param null|array|string $opts
     *
     * @throws \SimplePay\Vendor\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \SimplePay\Vendor\Stripe\Collection<\SimplePay\Vendor\Stripe\LineItem> list of LineItems
     */
    public static function allLineItems($id, $params = null, $opts = null)
    {
        $url = static::resourceUrl($id) . '/line_items';
        list($response, $opts) = static::_staticRequest('get', $url, $params, $opts);
        $obj = \SimplePay\Vendor\Stripe\Util\Util::convertToStripeObject($response->json, $opts);
        $obj->setLastResponse($response);

        return $obj;
    }
}
