<?php

/**

 * @author  RadiusTheme

 *

 * @since   1.0

 *

 * @version 1.0

 */

add_action('tgmpa_register', 'clenix_register_required_plugins');

function clenix_register_required_plugins() {

	$plugins = [

		// Bundled

		[

			'name'         => 'Clenix Core',

			'slug'         => 'clenix-core',

			'source'       => 'clenix-core.zip',

			'required'     => true,

			'external_url' => 'http://radiustheme.com',

			'version'      => '1.3.9',

		],

		[

			'name'         => 'RT Framework',

			'slug'         => 'rt-framework',

			'source'       => 'rt-framework.zip',

			'required'     => true,

			'external_url' => 'http://radiustheme.com',

			'version'      => '2.4',

		],

		[

			'name'         => 'RT Demo Importer',

			'slug'         => 'rt-demo-importer',

			'source'       => 'rt-demo-importer.zip',

			'required'     => true,

			'external_url' => 'http://radiustheme.com',

			'version'      => '6.0.0',

		],

		[

			'name'         => 'LayerSlider WP',

			'slug'         => 'LayerSlider',

			'source'       => 'LayerSlider.zip',

			'required'     => false,

			'external_url' => 'https://layerslider.kreaturamedia.com',

			'version'      => '7.6.9',

		],

		[

			'name'         => 'WooCommerce Variation images gallery Pro',

			'slug'         => 'woo-product-variation-gallery-pro',

			'source'       => 'woo-product-variation-gallery-pro.zip',

			'required'     => false,

			'external_url' => 'https://radiustheme.com',

			'version'      => '2.2.2',

		],

		// Repository

		[

			'name'     => 'Breadcrumb NavXT',

			'slug'     => 'breadcrumb-navxt',

			'required' => true,

		],

		[

			'name'     => 'Variation Images Gallery for WooCommerce',

			'slug'     => 'woo-product-variation-gallery',

			'required' => true,

		],

		[

			'name'     => 'Elementor Page Builder',

			'slug'     => 'elementor',

			'required' => true,

		],

		[

			'name'     => 'Redux Framework',

			'slug'     => 'redux-framework',

			'required' => true,

		],

		[

			'name'     => 'WooCommerce',

			'slug'     => 'woocommerce',

			'required' => false,

		],

		[

			'name'     => 'YITH WooCommerce Compare',

			'slug'     => 'yith-woocommerce-compare',

			'required' => false,

		],

		[

			'name'     => 'YITH WooCommerce Wishlist',

			'slug'     => 'yith-woocommerce-wishlist',

			'required' => false,

		],



		[

			'name'     => 'WP Fluent Forms',

			'slug'     => 'fluentform',

			'required' => false,

		],



		[

			'name'     => 'MailChimp for WordPress',

			'slug'     => 'mailchimp-for-wp',

			'required' => false,

		],

	];



	$config = [

		'id'           => 'clenix',                 	// Unique ID for hashing notices for multiple instances of TGMPA.

		'default_path' => CLENIX_PLUGINS_DIR,       	// Default absolute path to bundled plugins.

		'menu'         => 'clenix-install-plugins', 	// Menu slug.

		'has_notices'  => true,                    		// Show admin notices or not.

		'dismissable'  => true,                    		// If false, a user cannot dismiss the nag message.

		'dismiss_msg'  => '',                      		// If 'dismissable' is false, this message will be output at top of nag.

		'is_automatic' => false,                   		// Automatically activate plugins after installation or not.

		'message'      => '',                      		// Message to output right before the plugins table.

	];



	tgmpa($plugins, $config);

}

