<?php
// Security check
defined('ABSPATH') || die();

// @TODO figure out why this is not an add_filter situation
add_action( 'elementor/frontend/the_content', function( $content ) {
	return preg_replace( ['/(\selementor-section\s)/m', '/(elementor-column-wrap)/m'], ' $1 lazyelementorbackgroundimages ', $content );  
} );

// add css to hide bg image on images with lazyelementorbackgroundimages class
// add js (jQuery and Waypoint are dependencies) to remove the lazyelementorbackgroundimages class as the item approaches the viewport
add_action( 'wp_enqueue_scripts', 'lazy_elementor_background_images_js', 999 );
function lazy_elementor_background_images_js () { 
	if ( is_admin() ) return;
	if ( ! ( is_singular() ) ) return;
	
	global $lazy_elementor_background_images_js_added;
	ob_start(); ?>
	jQuery( function ( $ ) {
		if ( ! ( window.Waypoint ) ) {
			// if Waypoint is not available, then we MUST remove our class from all elements because otherwise BGs will never show
			$('.elementor-section.lazyelementorbackgroundimages,.elementor-column-wrap.lazyelementorbackgroundimages').removeClass('lazyelementorbackgroundimages');
			if ( window.console && console.warn ) {
				console.warn( 'Waypoint library is not loaded so backgrounds lazy loading is turned OFF' );
			}
			return;
		} 
		$('.lazyelementorbackgroundimages').each( function () {
			var $section = $( this );
			new Waypoint({
				element: $section.get( 0 ),
				handler: function( direction ) {
					//console.log( [ 'waypoint hit', $section.get( 0 ), $(window).scrollTop(), $section.offset() ] );
					$section.removeClass('lazyelementorbackgroundimages');
				},
				offset: $(window).height()*1.5 // when item is within 1.5x the viewport size, start loading it
			});
		} );
	});
<?php
	$skrip = ob_get_clean();
	
   	if ( ! wp_script_is( 'jquery', 'enqueued' ) ) {
		wp_enqueue_script( 'jquery' );
	}
   											 
	$lazy_elementor_background_images_js_added = wp_add_inline_script( 'jquery', $skrip );
}


add_action( 'wp_head', 'lazy_elementor_background_images_css' );
function lazy_elementor_background_images_css () { 
	if ( is_admin() ) return;
	if ( ! ( is_singular() ) ) return;
	global $lazy_elementor_background_images_js_added;
	if ( ! ( $lazy_elementor_background_images_js_added ) ) return; // don't add css if scripts weren't added
	ob_start(); ?>
		<style>
			.lazyelementorbackgroundimages:not(.elementor-motion-effects-element-type-background) {
				background-image: none !important; /* lazyload fix for elementor */
			}
		</style>
<?php
	echo ob_get_clean();
}