<?php

/**

 * Template Name: Blog 4

 * 

 * @author  RadiusTheme

 * @since   1.0

 * @version 1.0

 */



// Layout class

if ( ClenixTheme::$layout == 'full-width' ) {

	$clenix_layout_class = 'col-sm-12 col-12';

}

else{

	$clenix_layout_class = ClenixTheme_Helper::has_active_widget();

}



$args = array(

	'post_type' => "post",

);



if ( get_query_var('paged') ) {

	$args['paged'] = get_query_var('paged');

}

elseif ( get_query_var('page') ) {

	$args['paged'] = get_query_var('page');

}

else {

	$args['paged'] = 1;

}



$query = new WP_Query( $args );



global $wp_query;

$wp_query = NULL;

$wp_query = $query;

 

get_header(); ?>

<div id="primary" class="content-area">

	<div class="container">

		<div class="row">

			<?php if ( ClenixTheme::$layout == 'left-sidebar' ) { get_sidebar(); } ?>

			<div class="<?php echo esc_attr( $clenix_layout_class );?>">

				<main id="main" class="site-main">

					<?php if ( have_posts() ) :?>

						<?php

							$i = 0;							

							while ( have_posts() ) : the_post();					

							clenix_loadtemplate('template-parts/content-4', array('i' => $i ));				

							$i++;

							endwhile;

						?>

						<div class="mt50"><?php ClenixTheme_Helper::pagination();?></div>

					<?php else:?>

						<?php get_template_part( 'template-parts/content', 'none' );?>

					<?php endif;?>

					

				</main>

			</div>

			<?php if ( ClenixTheme::$layout == 'right-sidebar' ) { get_sidebar(); }	?>

		</div>

	</div>

</div>

<?php get_footer(); ?>