<?php


namespace App\Helpers;
use Request;
use Illuminate\Support\Facades\Auth;
use App\LogActivity as LogActivityModel;


class LogActivity
{


    public static function registerLog($subject)
    {
    	$log = [];
    	$log['subject'] = $subject;
    	$log['url'] = Request::fullUrl();
    	$log['method'] = Request::method();
    	$log['ip'] = Request::ip();
    	$log['agent'] = Request::header('user-agent');
    	$log['users_id'] = Auth::check() ? Auth::user()->id : 1;
    	LogActivityModel::create($log);
    }


    public static function logActivityLists()
    {
		\LogActivity::registerLog('View Activity Logs');
		$logs = LogActivityModel::with('users')->orderBy('id', 'desc')->take(500)->get();
		//dd($logs);
    	return $logs;
    }


}