<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Enrollment;
use PDF;
use App\Country;
use App\Visa;
use App\PaymentResponse;
use Illuminate\Support\Facades\Auth;

class EnrollusersController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(){
        
        $enrollUsersList = Enrollment::with('payments')->orderBy('id', 'desc')->get();
        \LogActivity::registerLog('View All Enrollment');
        return view('enrollusers.index', compact('enrollUsersList'));
        
    }//


    public function paymentdetails($id){
      \LogActivity::registerLog('View Payment Details of Enrollment ID :'.$id);
      $enrollUserDetails =  Enrollment::with('payments')->where('id', $id)->first();
      //dd($enrollUser);
      
      return view('enrollusers.paymentdetails', compact('enrollUserDetails'));
    }
    

    public function generatelink($id){
        \LogActivity::registerLog('Generate Payment for Enrollment ID :'.$id);
        $enrollUser =  Enrollment::where('id', $id)->first();
        $url = "http://".$_SERVER['HTTP_HOST']."/payment/confirmation";
        return view('enrollusers.generatelink', compact('enrollUser', 'url'));
      }
    

    public function show($enrollment){

        \LogActivity::registerLog('Edit/View Enrollment ID :'.$enrollment);

        $enrollment = Enrollment::with('country', 'payments')->where('id', $enrollment)->first();
        $countries = Country::orderBy('country_name', 'asc')->get();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('enrollusers.viewmore', compact('enrollment','visas', 'countries', 'schoolEducation', 'higherEducation', 'referenceFrom'));

        
    }


    public function update(Request $request)
    {
        $enroll = $request->all();
         //dd($enroll);
         if($enroll['disability'] == "N"){
            $enroll['intellectual'] = "0";
            $enroll['hearing'] = "0";
            $enroll['learing'] = "0";
            $enroll['physical'] = "0";
            $enroll['vision'] = "0";
            $enroll['medical'] = "0";
            $enroll['otherDisability'] = "0";
            $enroll['disabilityProblemOther'] = null;
         }

        
        \LogActivity::registerLog('Update Enrollment ID :'.$enroll['id']);

        $enrollment = Enrollment::find($enroll['id']);
        $enrollment->update($enroll);
        return redirect('enrollusers')->with('success','Updated Successfully');        
    }


    public function destroy($id)
    {
        $Enrollment = Enrollment::find($id);
        \LogActivity::registerLog('Delete Enrollment ID :'.$id);
        $Enrollment->delete();
        return redirect('enrollusers')->with('success','Deleted Successfully'); 
    }


    public function generatepdf($enrollment)
    {
        \LogActivity::registerLog('Generate/Print PDF of Enrollment ID :'.$enrollment);
        $enrollment = Enrollment::with('country', 'payments')->where('id', $enrollment)->first();
        $countries = Country::orderBy('country_name', 'asc')->get();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('enrollusers.generatepdf', compact('enrollment','visas', 'countries', 'schoolEducation', 'higherEducation', 'referenceFrom'));

    }


    public function schoolEducation(){
        return [
            '0'=>'I NEVER ATTEND SCHOOL',
            '1'=>'YEAR 8 OR BELOW',
            '2'=>'YEAR 9 OR EQUIVALENT',
            '3'=>'YEAR 10 OR EQUIVALENT',
            '4'=>'YEAR 11 OR EQUIVALENT',
            '5'=>'YEAR 12 OR EQUIVALENT',
            '6'=>'I AM STILL AT SCHOOL',
        ];
    }

    public function referenceFrom(){
        return [
            '0'=>'Google',
            '1'=>'Facebook',
            '2'=>'Friend',
            '3'=>'Collegue',
            '4'=>'Others',
        ];
    }


    public function higherEducation(){
        return [
            '0'=>'CERTIFICATE I',
            '1'=>'CERTIFICATE II',
            '2'=>'CERTIFICATE III',
            '3'=>'CERTIFICATE IV/ADVANCE CERTIFICATE',
            '4'=>'DIPLOMA OR ASSOCIATE DIPLOMA',
            '5'=>'ADVANCE DIPLOMA OR ASSOCIATE DEGREE',
            '6'=>'OTHER QUALIFICATION',
        ];
    }


}
