<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Database\QueryException;
use App\Skipeduser;
use App\Country;
use App\Visa;


class FailedEnrollmentController extends Controller
{


    public function index(){
        $failedEnrollUsersList = Skipeduser::all();
        //dd($enrollUsersList);
        return view('failedenrollment.index', compact('failedEnrollUsersList'));
        
    }//failedform


    public function create(Request $request){
        $enrollment = $request->all();
        //dd($enrollment);
        $enrollment['visitor'] = request()->ip();


        try {
            Skipeduser::create($enrollment);  
        } catch(\Illuminate\Database\QueryException $e){
            $errorCode = $e->errorInfo[1];
            if($errorCode == '1062'){
                return 'Email Already Registeres.';
            }
        }
        
        
    }


    public function show($id){

        $failedenrollment = Skipeduser::with('country')->where('id', $id)->first();
        //dd($enrollment);
        $countries = Country::all();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('failedenrollment.viewmore', compact('failedenrollment','visas', 'countries', 'schoolEducation', 'higherEducation', 'referenceFrom'));

        
    }


    public function generatepdf($enrollment)
    {
        $failedenrollment = Skipeduser::with('country')->where('id', $enrollment)->first();
        //dd($enrollment);
        $countries = Country::all();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('failedenrollment.generatepdf', compact('failedenrollment','visas', 'countries', 'schoolEducation', 'higherEducation', 'referenceFrom'));

    }


    public function schoolEducation(){
        return [
            '0'=>'I NEVER ATTEND SCHOOL',
            '1'=>'YEAR 8 OR BELOW',
            '2'=>'YEAR 9 OR EQUIVALENT',
            '3'=>'YEAR 10 OR EQUIVALENT',
            '4'=>'YEAR 11 OR EQUIVALENT',
            '5'=>'YEAR 12 OR EQUIVALENT',
            '6'=>'I AM STILL AT SCHOOL',
        ];
    }

    public function referenceFrom(){
        return [
            '0'=>'Google',
            '1'=>'Facebook',
            '2'=>'Friend',
            '3'=>'Collegue',
            '4'=>'Others',
        ];
    }


    public function higherEducation(){
        return [
            '0'=>'CERTIFICATE I',
            '1'=>'CERTIFICATE II',
            '2'=>'CERTIFICATE III',
            '3'=>'CERTIFICATE IV/ADVANCE CERTIFICATE',
            '4'=>'DIPLOMA OR ASSOCIATE DIPLOMA',
            '5'=>'ADVANCE DIPLOMA OR ASSOCIATE DEGREE',
            '6'=>'OTHER QUALIFICATION',
        ];
    }


}
