@extends('layouts.admin')
@section('content')


<! -- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Log Activity Lists</h6>
        </div>
        <div class="card-body">
            <div class="col-md-12">
	
		<table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">

			<thead>
				<tr>
					<th>S.No.</th>
					<th>Date/Time</th>
					<th>Subject</th>
					<th>URL</th>
					<th>Method</th>
					<th>IP Address</th>
					<th>By User</th>
				</tr>
			</thead>


			<tbody>
		@if($logs->count())
			@foreach($logs as $key => $log)
			<tr>
				<td>{{ ++$key }}</td>
				<td>{{ $log->created_at }}</td>
				<td>{{ $log->subject }}</td>
				<td class="text-success">{{ $log->url }}</td>
				<td><label class="label label-info">{{ $log->method }}</label></td>
				<td class="text-warning">{{ $log->ip }}</td>
				
				<td>{{ $log->users->name }}</td>
			</tr>
			@endforeach
		@endif
	</tbody>
	</table>
</div>
</div>
</div>
@endsection

@section('javascript')
    <!-- Page level plugins -->
    <script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <!-- Page level custom scripts -->
    <script src="{{ asset('js/demo/datatables-demo.js') }}"></script>
    
@endsection