<?php
global $bookingpress_slugs,$BookingPressPro, $bookingpress_pro_staff_members,$BookingPress;
$request_module = ( ! empty( $_REQUEST['page'] ) && ( $_REQUEST['page'] != 'bookingpress' ) ) ? str_replace( 'bookingpress_', '', sanitize_text_field( $_REQUEST['page'] ) ) : 'dashboard';
$bookingpress_user_id        = get_current_user_id();
$bookingpress_staffmember_id = $bookingpress_pro_staff_members->bookingpress_get_staffmember_id_using_wp_user_id( $bookingpress_user_id );
$bookingpress_upcomming_appointment = array( 'appointment_date' => '', 'booking_id' => '', 'customer_email' => '', 'customer_name' => '', 'service_name' => '',	'appointment_duration' => '',
);
if(!empty($bookingpress_staffmember_id)) {
	$bookingpress_staffmember_name = $bookingpress_pro_staff_members->bookingpress_get_staffmembername_using_id($bookingpress_staffmember_id);
	$bookingpress_upcomming_appointment = $bookingpress_pro_staff_members->bookingpress_get_staffmember_upcomming_appointment_data($bookingpress_staffmember_id);
}

$bookingpress_staffmember_access_admin = $BookingPress->bookingpress_get_settings( 'bookingpress_staffmember_access_admin', 'staffmember_setting' );
if ( $BookingPressPro->bookingpress_check_user_role( 'bookingpress-staffmember' ) && ( ! $bookingpress_pro_staff_members->bookingpress_check_staffmember_module_activation() || $bookingpress_pro_staff_members->bookingpress_current_login_staffmember_status() != 1 ) ) {
	
	wp_die( esc_html__( 'Sorry, you are not allowed to access this page', 'bookingpress-appointment-booking' ) );

} else {
	?>
<nav class="bpa-header-navbar__staff">
	<div class="bpa-hns__wrap">
		<div class="bpa-hns-wrap__left">
			<h2><?php esc_html_e('Welcome,','bookingpress-appointment-booking'); ?> <strong><?php echo esc_html(stripslashes_deep($bookingpress_staffmember_name));?></strong></h2>
		</div>
		<div class="bpa-hns-wrap__right">
			<?php
			if(!empty($bookingpress_upcomming_appointment)) { ?>
				<el-button class="bpa-btn bpa-btn__medium bpa-btn--icon-without-box bpa-hns-wrap-right__item bpa-hns__notification-item" @click="bookingpress_open_upcomming_appointment_model">
					<svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
						<path d="M14.9102 8.82422C14.9102 5.01172 12.8594 3.71484 10.9414 3.42578C10.9414 3.40625 10.9453 3.38672 10.9453 3.36328C10.9453 2.88281 10.5195 2.5 10 2.5C9.48047 2.5 9.07031 2.88281 9.07031 3.36328C9.07031 3.38672 9.07031 3.40625 9.07422 3.42578C7.15234 3.71875 5.08984 5.01953 5.08984 8.83203C5.08984 13.2773 3.98438 13.7539 2.5 15.0039H17.5C16.0234 13.75 14.9102 13.2695 14.9102 8.82422Z" fill="#727E95"/>
						<path d="M10.0078 17.5C11.0547 17.5 11.9141 16.7227 12.0273 15.8203H7.98828C8.09766 16.7227 8.96094 17.5 10.0078 17.5Z" fill="#727E95"/>
					</svg>
				</el-button>
			<?php }else { ?>
				<el-button class="bpa-btn bpa-btn__medium bpa-btn--icon-without-box bpa-hns-wrap-right__item bpa-hns__notification-item __bpa-is-disabled" @click="bookingpress_open_upcomming_appointment_model"> 
					<svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
						<path d="M14.9102 8.82422C14.9102 5.01172 12.8594 3.71484 10.9414 3.42578C10.9414 3.40625 10.9453 3.38672 10.9453 3.36328C10.9453 2.88281 10.5195 2.5 10 2.5C9.48047 2.5 9.07031 2.88281 9.07031 3.36328C9.07031 3.38672 9.07031 3.40625 9.07422 3.42578C7.15234 3.71875 5.08984 5.01953 5.08984 8.83203C5.08984 13.2773 3.98438 13.7539 2.5 15.0039H17.5C16.0234 13.75 14.9102 13.2695 14.9102 8.82422Z" fill="#727E95"/>
						<path d="M10.0078 17.5C11.0547 17.5 11.9141 16.7227 12.0273 15.8203H7.98828C8.09766 16.7227 8.96094 17.5 10.0078 17.5Z" fill="#727E95"/>
					</svg>
				</el-button> <?php
			}			
			if(!empty($bookingpress_staffmember_access_admin) && $bookingpress_staffmember_access_admin == 'true') { ?>
			<div class="bpa-hns-wrap-right__item" @click="bpa_staffmember_open_admin_view">
				<svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
					<path d="M2.59288 9.9999C2.59239 12.8384 4.21392 15.4275 6.7678 16.6663L3.23415 6.98541C2.81055 7.93387 2.59207 8.96111 2.59288 9.9999ZM10.1304 10.6478L7.90755 17.1058C9.3999 17.5452 10.9927 17.5039 12.4602 16.9876C12.4396 16.9552 12.4218 16.9211 12.4071 16.8855L10.1304 10.6478ZM15.0009 9.62636C14.9909 8.90192 14.7795 8.19456 14.3902 7.58355C13.9921 7.08263 13.7402 6.48134 13.6625 5.84619C13.6446 5.1403 14.2006 4.55263 14.9065 4.53158C14.9393 4.53158 14.9705 4.53554 15.0024 4.53754C11.9864 1.77485 7.30187 1.98025 4.53922 4.99621C4.27191 5.28798 4.02848 5.6007 3.8112 5.93137C3.98503 5.9369 4.14887 5.94038 4.28787 5.94038C5.0625 5.94038 6.26216 5.84614 6.26216 5.84614C6.43099 5.83638 6.57579 5.96534 6.58556 6.13417C6.59505 6.29834 6.47314 6.44071 6.30946 6.4566C6.30946 6.4566 5.90799 6.50359 5.46181 6.52696L8.15907 14.5505L9.78038 9.68891L8.6263 6.52702C8.22721 6.50363 7.84939 6.45665 7.84939 6.45665C7.6811 6.44038 7.55784 6.29074 7.57406 6.12245C7.5899 5.95865 7.73232 5.8367 7.89654 5.84619C7.89654 5.84619 9.11952 5.94043 9.84728 5.94043C10.6219 5.94043 11.8218 5.84619 11.8218 5.84619C11.9906 5.83632 12.1355 5.96517 12.1453 6.13395C12.1549 6.29834 12.0329 6.44092 11.869 6.45665C11.869 6.45665 11.4672 6.50364 11.0213 6.52702L13.6982 14.4895L14.4623 12.0681C14.7607 11.2851 14.9422 10.4623 15.0009 9.62636ZM16.5502 7.20801C16.5374 8.12066 16.346 9.02203 15.9868 9.86112L13.7244 16.4024C17.1943 14.3839 18.4252 9.96908 16.5004 6.4464C16.5341 6.69884 16.5507 6.95329 16.5502 7.20801ZM10.0002 1.11133C5.09104 1.11133 1.11133 5.09104 1.11133 10.0002C1.11133 14.9094 5.09104 18.8891 10.0002 18.8891C14.9094 18.8891 18.8891 14.9094 18.8891 10.0002C18.8891 5.09104 14.9094 1.11133 10.0002 1.11133ZM13.2524 17.6993C10.6511 18.8002 7.66944 18.5104 5.32888 16.9291C3.98536 16.022 2.93365 14.7449 2.301 13.2524C1.19987 10.6511 1.4898 7.66933 3.0714 5.32888C3.9783 3.98524 5.25543 2.93343 6.74805 2.30105C9.34934 1.2002 12.331 1.49002 14.6716 3.07129C16.0151 3.97836 17.0668 5.25548 17.6994 6.74799C18.8006 9.34928 18.5106 12.3311 16.929 14.6715C16.0221 16.0151 14.745 17.067 13.2524 17.6993Z" />
				</svg>
			</div>
			<?php } ?>	
			<div class="bpa-hns-wrap-right__item">
				<el-button class="bpa-btn bpa-btn__medium" @click="bookingpress_staffmember_logout('<?php echo add_query_arg( 'bookingpress_action', 'bookingpress_logout', esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>')">
					<span>
						<svg viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg">
							<path d="M3 9C3 9.19891 3.07902 9.38968 3.21967 9.53033C3.36032 9.67098 3.55109 9.75 3.75 9.75H9.4425L7.7175 11.4675C7.6472 11.5372 7.59141 11.6202 7.55333 11.7116C7.51525 11.803 7.49565 11.901 7.49565 12C7.49565 12.099 7.51525 12.197 7.55333 12.2884C7.59141 12.3798 7.6472 12.4628 7.7175 12.5325C7.78722 12.6028 7.87017 12.6586 7.96157 12.6967C8.05296 12.7347 8.15099 12.7543 8.25 12.7543C8.34901 12.7543 8.44704 12.7347 8.53843 12.6967C8.62983 12.6586 8.71278 12.6028 8.7825 12.5325L11.7825 9.5325C11.8508 9.46117 11.9043 9.37706 11.94 9.285C12.015 9.1024 12.015 8.8976 11.94 8.715C11.9043 8.62294 11.8508 8.53883 11.7825 8.4675L8.7825 5.4675C8.71257 5.39757 8.62955 5.3421 8.53819 5.30426C8.44682 5.26641 8.34889 5.24693 8.25 5.24693C8.15111 5.24693 8.05318 5.26641 7.96181 5.30426C7.87045 5.3421 7.78743 5.39757 7.7175 5.4675C7.64757 5.53743 7.5921 5.62045 7.55426 5.71181C7.51641 5.80318 7.49693 5.90111 7.49693 6C7.49693 6.09889 7.51641 6.19682 7.55426 6.28819C7.5921 6.37955 7.64757 6.46257 7.7175 6.5325L9.4425 8.25H3.75C3.55109 8.25 3.36032 8.32902 3.21967 8.46967C3.07902 8.61032 3 8.80109 3 9ZM12.75 1.5H5.25C4.65326 1.5 4.08097 1.73705 3.65901 2.15901C3.23705 2.58097 3 3.15326 3 3.75V6C3 6.19891 3.07902 6.38968 3.21967 6.53033C3.36032 6.67098 3.55109 6.75 3.75 6.75C3.94891 6.75 4.13968 6.67098 4.28033 6.53033C4.42098 6.38968 4.5 6.19891 4.5 6V3.75C4.5 3.55109 4.57902 3.36032 4.71967 3.21967C4.86032 3.07902 5.05109 3 5.25 3H12.75C12.9489 3 13.1397 3.07902 13.2803 3.21967C13.421 3.36032 13.5 3.55109 13.5 3.75V14.25C13.5 14.4489 13.421 14.6397 13.2803 14.7803C13.1397 14.921 12.9489 15 12.75 15H5.25C5.05109 15 4.86032 14.921 4.71967 14.7803C4.57902 14.6397 4.5 14.4489 4.5 14.25V12C4.5 11.8011 4.42098 11.6103 4.28033 11.4697C4.13968 11.329 3.94891 11.25 3.75 11.25C3.55109 11.25 3.36032 11.329 3.21967 11.4697C3.07902 11.6103 3 11.8011 3 12V14.25C3 14.8467 3.23705 15.419 3.65901 15.841C4.08097 16.2629 4.65326 16.5 5.25 16.5H12.75C13.3467 16.5 13.919 16.2629 14.341 15.841C14.7629 15.419 15 14.8467 15 14.25V3.75C15 3.15326 14.7629 2.58097 14.341 2.15901C13.919 1.73705 13.3467 1.5 12.75 1.5Z" />
						</svg>
					</span>
					<?php esc_html_e( 'Logout', 'bookingpress-appointment-booking' ); ?>
				</el-button>
			</div>
		</div>
	</div>
</nav>
<div class="bpa-staff-sidebar-navigation" :class="(bpa_toggle_active == 1) ? '__bpa-is-active' : ''">
	<div class="bpa-ssn__brand-logo">
		<a href="#" class="bpa-ssn-logo--lg">
			<svg width="140" height="36" viewBox="0 0 140 36" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M20.7106 17.4357C20.7106 17.4357 21.393 16.7489 21.393 14.6886C21.393 11.259 19.3414 10.5723 16.6293 10.5723H10.457V24.9815H14.5602V29.0978H16.6293V24.9815C19.009 24.9815 20.6625 24.9815 21.8786 23.4592C22.4611 22.7098 22.7698 21.7837 22.7535 20.8346C22.7603 20.3823 22.7014 19.9314 22.5785 19.496C22.2767 18.7218 22.0754 18.1181 20.7106 17.4357ZM18.659 22.9256H16.6293V20.8652C16.631 20.4598 16.7528 20.064 16.9793 19.7278C17.2058 19.3916 17.5268 19.13 17.9018 18.976C18.2769 18.8221 18.6891 18.7827 19.0865 18.8629C19.4839 18.943 19.8486 19.1391 20.1347 19.4264C20.4207 19.7136 20.6152 20.0792 20.6937 20.4769C20.7721 20.8747 20.731 21.2867 20.5755 21.6611C20.4199 22.0355 20.157 22.3554 19.8198 22.5804C19.4826 22.8055 19.0863 22.9256 18.6809 22.9256H18.659ZM16.9968 17.2388C16.6467 17.4069 16.3141 17.6091 16.0038 17.8425C15.5249 18.1789 15.1405 18.6328 14.8877 19.1607C14.6349 19.6885 14.5221 20.2725 14.5602 20.8565V22.9168H12.5086V12.6326H16.6293C18.2653 12.6326 19.3633 13.315 19.3633 14.6886C19.3414 15.9484 18.4009 16.5521 16.9968 17.2476V17.2388Z" fill="#12D488"/>
				<path d="M32.808 5.55689V31.6327C32.8091 32.5403 32.45 33.4113 31.8094 34.0544C31.1688 34.6974 30.2992 35.0599 29.3916 35.0622H3.41641C2.50876 35.0599 1.63914 34.6974 0.998565 34.0544C0.35799 33.4113 -0.00115934 32.5403 2.81166e-06 31.6327V5.55689C-0.00115934 4.64924 0.35799 3.77824 0.998565 3.1352C1.63914 2.49217 2.50876 2.12968 3.41641 2.12736H8.40759V1.09501C8.39842 0.954663 8.41815 0.813931 8.46555 0.681517C8.51295 0.549103 8.58702 0.427824 8.68317 0.325185C8.77932 0.222545 8.89552 0.140727 9.02456 0.0847933C9.1536 0.0288597 9.29274 0 9.43339 0C9.57403 0 9.71318 0.0288597 9.84222 0.0847933C9.97126 0.140727 10.0875 0.222545 10.1836 0.325185C10.2798 0.427824 10.3538 0.549103 10.4012 0.681517C10.4486 0.813931 10.4684 0.954663 10.4592 1.09501V5.21131C10.4684 5.35166 10.4486 5.49239 10.4012 5.6248C10.3538 5.75722 10.2798 5.87849 10.1836 5.98113C10.0875 6.08377 9.97126 6.16559 9.84222 6.22153C9.71318 6.27746 9.57403 6.30632 9.43339 6.30632C9.29274 6.30632 9.1536 6.27746 9.02456 6.22153C8.89552 6.16559 8.77932 6.08377 8.68317 5.98113C8.58702 5.87849 8.51295 5.75722 8.46555 5.6248C8.41815 5.49239 8.39842 5.35166 8.40759 5.21131V4.18333H4.09881C3.55429 4.18565 3.03293 4.40388 2.64913 4.79014C2.26533 5.1764 2.05043 5.69915 2.05159 6.24367V30.9459C2.05102 31.2153 2.10352 31.4822 2.20609 31.7313C2.30866 31.9805 2.4593 32.2069 2.6494 32.3979C2.8395 32.5888 3.06534 32.7404 3.31403 32.844C3.56272 32.9476 3.82939 33.0013 4.09881 33.0019H28.7048C28.9746 33.0019 29.2417 32.9486 29.4909 32.8453C29.7401 32.7419 29.9665 32.5904 30.157 32.3994C30.3476 32.2084 30.4986 31.9818 30.6015 31.7323C30.7043 31.4829 30.757 31.2157 30.7564 30.9459V6.24367C30.757 5.97368 30.7043 5.70621 30.6016 5.45655C30.4988 5.20689 30.3478 4.97992 30.1573 4.7886C29.9668 4.59728 29.7405 4.44536 29.4912 4.3415C29.242 4.23765 28.9748 4.1839 28.7048 4.18333H24.4004V5.21131C24.4096 5.35166 24.3898 5.49239 24.3424 5.6248C24.295 5.75722 24.221 5.87849 24.1248 5.98113C24.0287 6.08377 23.9125 6.16559 23.7834 6.22153C23.6544 6.27746 23.5152 6.30632 23.3746 6.30632C23.2339 6.30632 23.0948 6.27746 22.9658 6.22153C22.8367 6.16559 22.7205 6.08377 22.6244 5.98113C22.5282 5.87849 22.4542 5.75722 22.4068 5.6248C22.3594 5.49239 22.3396 5.35166 22.3488 5.21131V4.18333H18.4556C18.1829 4.18333 17.9215 4.07502 17.7287 3.88224C17.5359 3.68946 17.4276 3.42798 17.4276 3.15535C17.4276 3.02035 17.4542 2.88667 17.5058 2.76195C17.5575 2.63723 17.6332 2.52391 17.7287 2.42845C17.8241 2.33299 17.9375 2.25727 18.0622 2.20561C18.1869 2.15395 18.3206 2.12736 18.4556 2.12736H22.3488V1.09501C22.3396 0.954663 22.3594 0.813931 22.4068 0.681517C22.4542 0.549103 22.5282 0.427824 22.6244 0.325185C22.7205 0.222545 22.8367 0.140727 22.9658 0.0847933C23.0948 0.0288597 23.2339 0 23.3746 0C23.5152 0 23.6544 0.0288597 23.7834 0.0847933C23.9125 0.140727 24.0287 0.222545 24.1248 0.325185C24.221 0.427824 24.295 0.549103 24.3424 0.681517C24.3898 0.813931 24.4096 0.954663 24.4004 1.09501V2.12736H29.3916C30.2992 2.12968 31.1688 2.49217 31.8094 3.1352C32.45 3.77824 32.8091 4.64924 32.808 5.55689Z" fill="#12D488"/>
				<path d="M42.138 22.3399C41.5387 22.3399 40.9438 22.3399 40.3489 22.283C39.7251 22.2435 39.1051 22.1572 38.4941 22.025V11.4302C39.0425 11.3287 39.5959 11.2571 40.152 11.2158C40.7513 11.1677 41.3069 11.1458 41.8231 11.1458C42.4662 11.141 43.1087 11.1908 43.7434 11.2946C44.2722 11.377 44.7828 11.5501 45.2526 11.8064C45.6555 12.0289 45.9944 12.3513 46.2368 12.7425C46.4879 13.1875 46.612 13.6929 46.5955 14.2035C46.5948 14.6312 46.4765 15.0504 46.2536 15.4153C46.0306 15.7803 45.7115 16.0768 45.3313 16.2726C45.9168 16.451 46.4204 16.8306 46.753 17.3443C47.0071 17.8142 47.1366 18.3413 47.1292 18.8754C47.165 19.3829 47.068 19.8909 46.8479 20.3496C46.6278 20.8083 46.2921 21.2017 45.8737 21.4913C45.0309 22.057 43.7857 22.3399 42.138 22.3399ZM40.8913 15.5508H42.0943C42.6512 15.5901 43.2091 15.4893 43.7172 15.2578C43.878 15.1618 44.0089 15.023 44.0954 14.8569C44.1819 14.6909 44.2206 14.504 44.2071 14.3173C44.223 14.1299 44.1838 13.9419 44.0945 13.7764C44.0051 13.6109 43.8694 13.4751 43.704 13.3855C43.2376 13.1813 42.7295 13.0899 42.2211 13.1187H41.5475C41.3069 13.1187 41.11 13.1406 40.9001 13.1581L40.8913 15.5508ZM40.8913 17.4275V20.2533C41.0707 20.2533 41.2675 20.2927 41.4775 20.3014C41.6874 20.3102 41.9149 20.3014 42.173 20.3014C42.7836 20.3247 43.3921 20.2173 43.9578 19.9865C44.1774 19.8842 44.3602 19.7169 44.4815 19.5072C44.6028 19.2974 44.6567 19.0555 44.6358 18.8141C44.653 18.5987 44.6087 18.3828 44.508 18.1915C44.4074 18.0002 44.2545 17.8415 44.0671 17.7337C43.5604 17.4912 43.0008 17.3799 42.4398 17.41L40.8913 17.4275Z" fill="#202C45"/>
				<path d="M56.7357 18.0428C56.7422 18.6523 56.6461 19.2586 56.4514 19.8363C56.2764 20.3519 55.9964 20.8255 55.629 21.2273C55.2672 21.6069 54.8288 21.9051 54.3429 22.1022C53.2655 22.522 52.0696 22.522 50.9922 22.1022C50.5063 21.9051 50.0679 21.6069 49.7061 21.2273C49.3362 20.8251 49.052 20.3518 48.8706 19.8363C48.6635 19.2613 48.5613 18.6539 48.5687 18.0428C48.5619 17.4339 48.6672 16.8289 48.8793 16.258C49.0664 15.7475 49.3551 15.2802 49.728 14.8845C50.101 14.5063 50.5477 14.2085 51.0403 14.0096C51.5574 13.7958 52.1124 13.6887 52.6719 13.6946C53.2372 13.6879 53.7981 13.795 54.3211 14.0096C54.8154 14.2053 55.2626 14.5035 55.6334 14.8845C55.9882 15.2858 56.2615 15.7524 56.4383 16.258C56.6438 16.8303 56.7446 17.4348 56.7357 18.0428ZM54.3342 18.0428C54.3662 17.4414 54.2136 16.8446 53.8968 16.3324C53.7522 16.1387 53.5644 15.9814 53.3484 15.8731C53.1323 15.7647 52.8939 15.7083 52.6522 15.7083C52.4105 15.7083 52.1722 15.7647 51.9561 15.8731C51.7401 15.9814 51.5523 16.1387 51.4077 16.3324C51.0891 16.8438 50.9363 17.4412 50.9703 18.0428C50.9346 18.657 51.0872 19.2674 51.4077 19.7925C51.5494 19.9903 51.7363 20.1515 51.9527 20.2626C52.1691 20.3738 52.4089 20.4318 52.6522 20.4318C52.8956 20.4318 53.1354 20.3738 53.3518 20.2626C53.5682 20.1515 53.755 19.9903 53.8968 19.7925C54.2149 19.2664 54.3674 18.6567 54.3342 18.0428Z" fill="#202C45"/>
				<path d="M66.3165 18.0427C66.323 18.6523 66.2269 19.2586 66.0321 19.8362C65.8588 20.3526 65.5786 20.8266 65.2098 21.2273C64.848 21.6068 64.4096 21.9051 63.9237 22.1022C62.8477 22.5221 61.6532 22.5221 60.5773 22.1022C60.0895 21.9062 59.6494 21.6079 59.2868 21.2273C58.9199 20.8228 58.636 20.3502 58.4513 19.8362C58.2457 19.261 58.145 18.6536 58.1539 18.0427C58.1457 17.4341 58.2495 16.8291 58.4601 16.258C58.6569 15.7462 58.9544 15.2792 59.3349 14.8844C59.7077 14.5058 60.1544 14.208 60.6473 14.0096C61.1659 13.7958 61.7223 13.6887 62.2833 13.6946C62.8485 13.6883 63.4093 13.7954 63.9324 14.0096C64.417 14.2092 64.8549 14.5071 65.2185 14.8844C65.5731 15.2844 65.8439 15.7515 66.0146 16.258C66.2217 16.8299 66.3239 17.4345 66.3165 18.0427ZM63.9149 18.0427C63.947 17.4413 63.7943 16.8445 63.4775 16.3324C63.3417 16.1311 63.1567 15.9679 62.94 15.8584C62.7233 15.7489 62.4821 15.6967 62.2395 15.7068C61.9952 15.6973 61.7524 15.7497 61.5337 15.859C61.315 15.9684 61.1275 16.1312 60.9885 16.3324C60.6698 16.8437 60.517 17.4412 60.551 18.0427C60.5154 18.6569 60.668 19.2674 60.9885 19.7925C61.1251 19.997 61.3118 20.163 61.5308 20.2748C61.7498 20.3866 61.9938 20.4405 62.2395 20.4312C62.4875 20.4378 62.7329 20.3791 62.951 20.2608C63.1691 20.1426 63.3522 19.969 63.4819 19.7575C63.7918 19.241 63.9424 18.6445 63.9149 18.0427Z" fill="#202C45"/>
				<path d="M70.4848 16.8744L71.2022 16.0913C71.4515 15.8201 71.6877 15.5489 71.9196 15.2821L72.5757 14.5209L73.105 13.891H75.9003C75.3447 14.5341 74.7979 15.1465 74.2686 15.7283C73.7393 16.3101 73.1531 16.9137 72.5188 17.5349C72.8653 17.8536 73.1911 18.194 73.4943 18.5541C73.8312 18.9478 74.1549 19.359 74.4698 19.779C74.7848 20.1989 75.0779 20.6232 75.3447 21.0432C75.6115 21.4631 75.8303 21.8524 76.0096 22.198H73.3019C73.1356 21.9268 72.9432 21.6206 72.7288 21.2881C72.5145 20.9557 72.2914 20.6232 72.042 20.2908C71.7927 19.9583 71.5434 19.639 71.2765 19.3328C71.0347 19.0515 70.7683 18.7924 70.4804 18.5585V22.198H68.127V10.3259L70.4804 9.94531L70.4848 16.8744Z" fill="#202C45"/>
				<path d="M79.8503 11.4999C79.8562 11.6914 79.8201 11.8819 79.7446 12.058C79.669 12.2341 79.5558 12.3915 79.4129 12.5191C79.1387 12.7559 78.7886 12.8861 78.4264 12.8861C78.0642 12.8861 77.7141 12.7559 77.44 12.5191C77.1713 12.248 77.0205 11.8816 77.0205 11.4999C77.0205 11.1181 77.1713 10.7518 77.44 10.4806C77.7129 10.2413 78.0635 10.1094 78.4264 10.1094C78.7894 10.1094 79.14 10.2413 79.4129 10.4806C79.5572 10.6071 79.6714 10.7643 79.7471 10.9407C79.8228 11.117 79.8581 11.3081 79.8503 11.4999ZM79.6185 22.204H77.265V13.8927H79.6185V22.204Z" fill="#202C45"/>
				<path d="M81.8373 14.189C82.3454 14.0513 82.8609 13.9432 83.3815 13.8653C84.0403 13.7656 84.7056 13.7159 85.3719 13.7166C85.967 13.7008 86.5601 13.7942 87.1216 13.9921C87.5543 14.1511 87.9375 14.4211 88.2327 14.7752C88.5138 15.1268 88.714 15.536 88.8189 15.9737C88.9391 16.481 88.9979 17.001 88.9939 17.5223V22.2116H86.6404V17.8066C86.6833 17.2528 86.5792 16.6975 86.3386 16.1968C86.2092 16.0275 86.0378 15.8948 85.8414 15.8119C85.645 15.7291 85.4304 15.6989 85.2187 15.7244C85.0481 15.7244 84.8688 15.7244 84.6807 15.7244C84.4926 15.7244 84.322 15.7594 84.1733 15.7813V22.2116H81.8242L81.8373 14.189Z" fill="#202C45"/>
				<path d="M98.3031 21.1714C98.3031 22.5333 97.959 23.5409 97.2708 24.1941C96.5825 24.8474 95.5152 25.1769 94.0687 25.1827C93.5611 25.1832 93.0546 25.1378 92.5552 25.0471C92.0782 24.9674 91.6086 24.8489 91.151 24.6928L91.5578 22.7199C91.9345 22.8698 92.3239 22.9855 92.7214 23.0655C93.1764 23.1564 93.6397 23.1989 94.1037 23.1924C94.3586 23.2193 94.6163 23.1944 94.8614 23.1192C95.1064 23.044 95.3338 22.9201 95.5297 22.7549C95.6744 22.6038 95.7875 22.4254 95.8626 22.2302C95.9377 22.0349 95.9732 21.8267 95.9672 21.6176V21.3201C95.7163 21.4342 95.4537 21.5207 95.1842 21.5782C94.8964 21.6379 94.6032 21.6672 94.3093 21.6657C93.8242 21.6949 93.3385 21.619 92.8855 21.4431C92.4325 21.2672 92.0229 20.9954 91.6846 20.6465C91.0336 19.8454 90.7073 18.829 90.7704 17.7987C90.7613 17.2304 90.8577 16.6653 91.0547 16.1321C91.2287 15.6383 91.5112 15.1899 91.8815 14.8198C92.2513 14.464 92.6906 14.1884 93.1719 14.0105C93.7446 13.8071 94.3491 13.7078 94.9567 13.7174C95.2483 13.7174 95.54 13.7306 95.8316 13.7568C96.1232 13.783 96.4148 13.818 96.7065 13.8618C96.9995 13.9012 97.2795 13.9536 97.5507 14.0105C97.8219 14.0674 98.0581 14.1286 98.2681 14.1899L98.3031 21.1714ZM93.1369 17.7944C93.1369 19.1067 93.6706 19.7672 94.7336 19.7672C94.9632 19.7696 95.1918 19.7372 95.4116 19.671C95.5986 19.6185 95.7791 19.5451 95.9497 19.4523V15.6903C95.836 15.6903 95.696 15.6509 95.5385 15.6378C95.3554 15.619 95.1714 15.6103 94.9873 15.6115C94.7248 15.595 94.4623 15.6425 94.2223 15.75C93.9822 15.8574 93.7719 16.0216 93.6094 16.2283C93.2842 16.6843 93.1182 17.2346 93.1369 17.7944Z" fill="#202C45"/>
				<path d="M103.955 11.1426C105.585 11.1426 106.839 11.4342 107.717 12.0175C108.592 12.5949 109.029 13.531 109.029 14.8389C109.029 16.1469 108.592 17.1049 107.717 17.6867C106.842 18.2685 105.569 18.5616 103.928 18.5616H103.154V22.2229H100.691V11.4444C101.254 11.3358 101.822 11.2613 102.393 11.2213C102.979 11.1645 103.504 11.1426 103.955 11.1426ZM104.117 13.2423C103.937 13.2423 103.758 13.2423 103.587 13.2423L103.15 13.2773V16.4356H103.924C104.584 16.4728 105.244 16.3528 105.849 16.0856C106.075 15.9559 106.257 15.7618 106.372 15.5281C106.488 15.2944 106.531 15.0316 106.496 14.7733C106.505 14.5111 106.448 14.2508 106.33 14.0166C106.22 13.8158 106.056 13.6493 105.858 13.5354C105.625 13.4041 105.37 13.318 105.105 13.2817C104.774 13.2412 104.441 13.2281 104.108 13.2423H104.117Z" fill="#202C45"/>
				<path d="M115.694 15.9943C115.484 15.9418 115.234 15.8849 114.95 15.828C114.649 15.7689 114.343 15.7396 114.036 15.7405C113.859 15.7426 113.682 15.7558 113.506 15.7799C113.349 15.7976 113.192 15.8268 113.038 15.8674V22.2146H110.672V14.3407C111.161 14.1673 111.659 14.0213 112.164 13.9033C112.794 13.7664 113.438 13.7003 114.084 13.7064C114.211 13.7064 114.364 13.7064 114.543 13.7283C114.723 13.7502 114.902 13.7677 115.081 13.7939L115.615 13.8858C115.772 13.9177 115.925 13.963 116.074 14.0214L115.694 15.9943Z" fill="#202C45"/>
				<path d="M116.798 18.1175C116.784 17.4569 116.9 16.8 117.139 16.184C117.338 15.6708 117.635 15.2012 118.014 14.8017C118.375 14.4375 118.809 14.1529 119.287 13.9662C119.756 13.7792 120.256 13.6827 120.761 13.6819C121.277 13.6546 121.793 13.7368 122.274 13.923C122.756 14.1092 123.193 14.3953 123.556 14.7623C124.245 15.4827 124.587 16.5442 124.584 17.9469C124.584 18.0825 124.584 18.2312 124.584 18.3843C124.584 18.5374 124.563 18.6905 124.554 18.8218H119.217C119.238 19.0517 119.31 19.2742 119.427 19.4731C119.544 19.6721 119.704 19.8425 119.895 19.9722C120.373 20.283 120.936 20.436 121.505 20.4097C121.932 20.4102 122.358 20.3707 122.778 20.2916C123.127 20.231 123.469 20.1327 123.797 19.9985L124.112 21.9101C123.948 21.9871 123.779 22.05 123.605 22.0982C123.375 22.1673 123.141 22.2228 122.905 22.2644C122.647 22.3125 122.371 22.3519 122.073 22.3825C121.783 22.4135 121.491 22.4296 121.199 22.4307C120.533 22.4456 119.871 22.3328 119.248 22.0982C118.73 21.8996 118.261 21.5906 117.874 21.1927C117.508 20.8016 117.233 20.3339 117.069 19.8235C116.887 19.2732 116.796 18.6971 116.798 18.1175ZM122.327 17.2426C122.318 17.0438 122.284 16.8469 122.227 16.6564C122.169 16.4717 122.077 16.2996 121.955 16.149C121.828 15.9984 121.672 15.8749 121.496 15.7859C121.28 15.6945 121.048 15.6474 120.814 15.6474C120.579 15.6474 120.347 15.6945 120.131 15.7859C119.95 15.8684 119.789 15.9893 119.659 16.1403C119.531 16.2918 119.432 16.4652 119.366 16.6521C119.297 16.8452 119.247 17.0444 119.217 17.247L122.327 17.2426Z" fill="#202C45"/>
				<path d="M128.802 20.5134C129.114 20.534 129.426 20.4908 129.721 20.3865C129.81 20.3417 129.883 20.2708 129.931 20.1832C129.979 20.0957 129.998 19.9957 129.988 19.8966C129.979 19.7905 129.941 19.6888 129.88 19.602C129.818 19.5151 129.735 19.4462 129.638 19.4023C129.302 19.2079 128.949 19.0453 128.584 18.9167C128.241 18.7892 127.905 18.6432 127.577 18.4793C127.296 18.3437 127.038 18.1651 126.812 17.95C126.6 17.7409 126.434 17.4908 126.322 17.2151C126.201 16.8877 126.143 16.5404 126.151 16.1915C126.139 15.8355 126.211 15.4818 126.364 15.1598C126.516 14.8378 126.743 14.5571 127.026 14.3411C127.723 13.8548 128.562 13.616 129.41 13.6631C129.898 13.6604 130.384 13.7058 130.863 13.7987C131.239 13.8625 131.61 13.9591 131.969 14.0874L131.558 15.9202C131.271 15.8213 130.979 15.7366 130.683 15.6665C130.328 15.5915 129.966 15.5548 129.603 15.5572C128.868 15.5572 128.496 15.7628 128.496 16.174C128.495 16.2609 128.511 16.3471 128.544 16.4277C128.586 16.5136 128.651 16.5863 128.732 16.6376C128.856 16.7228 128.986 16.7975 129.122 16.8607C129.283 16.9395 129.493 17.027 129.747 17.1232C130.185 17.2822 130.612 17.4707 131.024 17.6875C131.321 17.8438 131.59 18.0477 131.821 18.2912C132.011 18.4958 132.151 18.7412 132.232 19.0086C132.315 19.306 132.355 19.614 132.35 19.9228C132.37 20.2861 132.295 20.6483 132.134 20.9741C131.972 21.2999 131.728 21.5783 131.427 21.7819C130.634 22.249 129.72 22.4684 128.802 22.4118C128.183 22.4233 127.565 22.3601 126.961 22.2238C126.613 22.1438 126.272 22.037 125.941 21.9044L126.335 19.9972C126.735 20.154 127.148 20.2769 127.569 20.3646C127.973 20.4581 128.387 20.508 128.802 20.5134Z" fill="#202C45"/>
				<path d="M136.484 20.5135C136.794 20.5342 137.106 20.491 137.398 20.3867C137.489 20.343 137.563 20.2725 137.612 20.1847C137.66 20.097 137.681 19.9964 137.67 19.8967C137.661 19.7907 137.623 19.689 137.562 19.6021C137.5 19.5152 137.417 19.4463 137.32 19.4024C136.983 19.2082 136.628 19.0456 136.261 18.9169C135.92 18.7886 135.585 18.6426 135.259 18.4794C134.978 18.3438 134.72 18.1652 134.494 17.9501C134.282 17.741 134.116 17.491 134.004 17.2152C133.881 16.8882 133.822 16.5408 133.829 16.1916C133.816 15.8357 133.889 15.4819 134.041 15.1599C134.193 14.838 134.421 14.5572 134.704 14.3412C135.4 13.8543 136.24 13.6155 137.088 13.6632C137.575 13.6607 138.062 13.7061 138.54 13.7988C138.917 13.8633 139.287 13.9599 139.647 14.0875L139.236 15.9204C138.948 15.8214 138.657 15.7367 138.361 15.6667C138.006 15.5916 137.643 15.555 137.28 15.5573C136.541 15.5573 136.174 15.7629 136.174 16.1741C136.173 16.261 136.189 16.3473 136.222 16.4278C136.264 16.5138 136.329 16.5864 136.41 16.6378C136.533 16.724 136.663 16.7986 136.799 16.8609C136.961 16.9396 137.171 17.0271 137.42 17.1234C137.85 17.2871 138.268 17.4801 138.671 17.7008C138.968 17.8571 139.237 18.061 139.468 18.3044C139.658 18.509 139.798 18.7544 139.879 19.0218C139.962 19.3193 140.002 19.6272 139.997 19.9361C140.017 20.2993 139.942 20.6615 139.781 20.9874C139.619 21.3132 139.375 21.5916 139.074 21.7952C138.281 22.2621 137.367 22.4814 136.449 22.4251C135.832 22.4363 135.215 22.3732 134.612 22.237C134.265 22.157 133.924 22.0503 133.593 21.9177L133.986 20.0105C134.386 20.1679 134.799 20.2908 135.22 20.3779C135.635 20.4692 136.059 20.5146 136.484 20.5135Z" fill="#202C45"/>
			</svg>
		</a>
		<a href="#" class="bpa-ssn-logo--sm">
			<svg viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg">
				<rect width="64" height="64" rx="12"/>
				<path d="M50 18.9608V47.2745C50 49.3359 48.325 51 46.25 51H17.75C15.675 51 14 49.3359 14 47.2745V18.9608C14 16.8993 15.675 15.2353 17.75 15.2353H23V14.1176C23 13.7451 23.375 13 24.125 13C24.875 13 25.25 13.7451 25.25 14.1176V18.5882C25.25 18.9608 24.875 19.7059 24.125 19.7059C23.375 19.7059 23 18.9608 23 18.5882V17.4706H18.5C17.25 17.4706 16.25 18.4641 16.25 19.7059V46.5294C16.25 47.7712 17.25 48.7647 18.5 48.7647H45.5C46.75 48.7647 47.75 47.7712 47.75 46.5294V19.7059C47.75 18.4641 46.75 17.4706 45.5 17.4706H41C41 17.4706 41 18.0418 41 18.5882C41 18.9608 40.625 19.7059 39.875 19.7059C39.125 19.7059 38.75 18.9608 38.75 18.5882V17.4706H33.125C32.5 17.4706 32 16.9739 32 16.3529C32 15.732 32.5 15.2353 33.125 15.2353H38.75V14.1176C38.75 13.7451 39.125 13 39.875 13C40.625 13 41 13.7451 41 14.1176V15.2353H46.25C48.325 15.2353 50 16.8993 50 18.9608Z" fill="white"/>
				<path d="M37.2501 30.8823C37.2501 30.8823 38.0001 30.1372 38.0001 27.9019C38.0001 24.1765 35.7501 23.4314 32.7501 23.4314H26.0001V39.0784H30.5001V43.549H32.7501V39.0784C35.3501 39.0784 37.1751 39.0784 38.5251 37.4144C39.1751 36.6196 39.5001 35.6013 39.5001 34.5582C39.5001 34.0118 39.4251 33.4654 39.3001 33.1176C38.9751 32.2732 38.7501 31.6274 37.2501 30.8823ZM35.0001 36.8431C34.2501 36.8431 32.7501 36.8431 32.7501 36.8431C32.7501 36.8431 32.7501 36.098 32.7501 34.6078C32.7501 33.366 33.7501 32.3725 35.0001 32.3725C36.2001 32.3725 37.2501 33.3412 37.2501 34.6078C37.2501 35.9242 36.1501 36.8431 35.0001 36.8431ZM33.1751 30.6836C32.8001 30.8575 32.4251 31.081 32.0751 31.3294C31.2501 31.9503 30.5001 32.8444 30.5001 34.6078V36.8431H28.2501V25.6667H32.7501C34.5501 25.6667 35.7501 26.4118 35.7501 27.9019C35.7501 29.268 34.7251 29.9137 33.1751 30.6836Z" fill="white"/>
			</svg>
		</a>		
	</div>
	<div class="bpa-ssn__navbar-wrap">		
		<ul class="bpa-ssn__navbar">
			<?php  if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress' ) ) { ?>
			<li>
				<a href="<?php echo esc_url( admin_url() . 'admin.php?page=bookingpress'); // phpcs:ignore ?>" class="<?php echo ( 'dashboard' == $request_module ) ? '__bpa-is-active' : ''; ?>">
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_4458_14179)">
							<path d="M4 13H10C10.55 13 11 12.55 11 12V4C11 3.45 10.55 3 10 3H4C3.45 3 3 3.45 3 4V12C3 12.55 3.45 13 4 13ZM4 21H10C10.55 21 11 20.55 11 20V16C11 15.45 10.55 15 10 15H4C3.45 15 3 15.45 3 16V20C3 20.55 3.45 21 4 21ZM14 21H20C20.55 21 21 20.55 21 20V12C21 11.45 20.55 11 20 11H14C13.45 11 13 11.45 13 12V20C13 20.55 13.45 21 14 21ZM13 4V8C13 8.55 13.45 9 14 9H20C20.55 9 21 8.55 21 8V4C21 3.45 20.55 3 20 3H14C13.45 3 13 3.45 13 4Z" fill="#727E95"/>
						</g>
						<defs>
							<clipPath id="clip0_4458_14179">
								<rect width="24" height="24" fill="white"/>
							</clipPath>
						</defs>
					</svg>
					<?php esc_html_e( 'Dashboard', 'bookingpress-appointment-booking' ); ?>
				</a>
			</li>
			<?php }
			if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress_calendar' ) ) {
			?>
			<li>
				<a href="<?php echo add_query_arg( 'page', $bookingpress_slugs->bookingpress_calendar, esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>" class="<?php echo ( 'calendar' == $request_module ) ? '__bpa-is-active' : ''; ?>">
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_4458_14174)">
							<path d="M16 3V4H8V3C8 2.45 7.55 2 7 2C6.45 2 6 2.45 6 3V4H5C3.89 4 3.01 4.9 3.01 6L3 20C3 21.1 3.89 22 5 22H19C20.1 22 21 21.1 21 20V6C21 4.9 20.1 4 19 4H18V3C18 2.45 17.55 2 17 2C16.45 2 16 2.45 16 3ZM18 20H6C5.45 20 5 19.55 5 19V9H19V19C19 19.55 18.55 20 18 20Z" fill="#727E95"/>
						</g>
						<defs>
							<clipPath id="clip0_4458_14174">
								<rect width="24" height="24" fill="white"/>
							</clipPath>
						</defs>
					</svg>
					<?php esc_html_e( 'Calendar', 'bookingpress-appointment-booking' ); ?>
				</a>
			</li>
			<?php }
			if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress_appointments' ) ) {
			?>
			<li>
				<a href="<?php echo add_query_arg( 'page', $bookingpress_slugs->bookingpress_appointments, esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>" class="<?php echo ( 'appointments' == $request_module ) ? '__bpa-is-active' : ''; ?>">
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_4470_13557)">
							<path d="M21 12V6C21 4.9 20.1 4 19 4H18V3C18 2.45 17.55 2 17 2C16.45 2 16 2.45 16 3V4H8V3C8 2.45 7.55 2 7 2C6.45 2 6 2.45 6 3V4H5C3.9 4 3 4.9 3 6V20C3 21.1 3.9 22 5 22H12V20H5V10H19V12H21Z"/>
							<path d="M18 13C15.24 13 13 15.24 13 18C13 20.76 15.24 23 18 23C20.76 23 23 20.76 23 18C23 15.24 20.76 13 18 13ZM19.65 20.35L17.5 18.2V15H18.5V17.79L20.35 19.64L19.65 20.35Z"/>
						</g>
						<defs>
							<clipPath id="clip0_4470_13557">
								<rect width="24" height="24" fill="white"/>
							</clipPath>
						</defs>
					</svg>
					<?php esc_html_e( 'Appointments', 'bookingpress-appointment-booking' ); ?>					
				</a>
			</li>
			<?php }
			if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress_customers' ) ) {
			?>
			<li>
				<a href="<?php echo add_query_arg( 'page', $bookingpress_slugs->bookingpress_customers, esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>" class="<?php echo ( 'customers' == $request_module ) ? '__bpa-is-active' : ''; ?>">
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_4458_14009)">
							<path d="M16.95 11.9998C18.468 11.9998 19.689 10.7678 19.689 9.2498C19.689 7.7318 18.468 6.4998 16.95 6.4998C15.432 6.4998 14.2 7.7318 14.2 9.2498C14.2 10.7678 15.432 11.9998 16.95 11.9998ZM8.7 10.8998C10.526 10.8998 11.989 9.4258 11.989 7.5998C11.989 5.7738 10.526 4.2998 8.7 4.2998C6.874 4.2998 5.4 5.7738 5.4 7.5998C5.4 9.4258 6.874 10.8998 8.7 10.8998ZM16.95 14.1998C14.937 14.1998 10.9 15.2118 10.9 17.2248V18.5998C10.9 19.2048 11.395 19.6998 12 19.6998H21.9C22.505 19.6998 23 19.2048 23 18.5998V17.2248C23 15.2118 18.963 14.1998 16.95 14.1998ZM8.7 13.0998C6.137 13.0998 1 14.3868 1 16.9498V18.5998C1 19.2048 1.495 19.6998 2.1 19.6998H8.7V17.2248C8.7 16.2898 9.063 14.6508 11.307 13.4078C10.35 13.2098 9.426 13.0998 8.7 13.0998Z" fill="#727E95"/>
						</g>
						<defs>
							<clipPath id="clip0_4458_14009">
								<rect width="24" height="24" fill="white"/>
							</clipPath>
						</defs>
					</svg>
					<?php esc_html_e( 'Customers', 'bookingpress-appointment-booking' ); ?>					
				</a>
			</li>
			<?php }
			if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress_payments' ) ) {
			?>
			<li>
				<a href="<?php echo add_query_arg( 'page', $bookingpress_slugs->bookingpress_payments, esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>" class="<?php echo ( 'payments' == $request_module ) ? '__bpa-is-active' : ''; ?>">
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_4458_14014)">
							<path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM13.41 18.09V18.67C13.41 19.4 12.81 20 12.08 20H12.07C11.34 20 10.74 19.4 10.74 18.67V18.07C9.41 17.79 8.23 17.06 7.73 15.83C7.5 15.28 7.93 14.67 8.53 14.67H8.77C9.14 14.67 9.44 14.92 9.58 15.27C9.87 16.02 10.63 16.54 12.09 16.54C14.05 16.54 14.49 15.56 14.49 14.95C14.49 14.12 14.05 13.34 11.82 12.81C9.34 12.21 7.64 11.19 7.64 9.14C7.64 7.42 9.03 6.3 10.75 5.93V5.33C10.75 4.6 11.35 4 12.08 4H12.09C12.82 4 13.42 4.6 13.42 5.33V5.95C14.8 6.29 15.67 7.15 16.05 8.21C16.25 8.76 15.83 9.34 15.24 9.34H14.98C14.61 9.34 14.31 9.08 14.21 8.72C13.98 7.96 13.35 7.47 12.09 7.47C10.59 7.47 9.69 8.15 9.69 9.11C9.69 9.95 10.34 10.5 12.36 11.02C14.38 11.54 16.54 12.41 16.54 14.93C16.52 16.76 15.15 17.76 13.41 18.09Z" fill="#727E95"/>
						</g>
						<defs>
							<clipPath id="clip0_4458_14014">
								<rect width="24" height="24" fill="white"/>
							</clipPath>
						</defs>
					</svg>
					<?php esc_html_e( 'Payments', 'bookingpress-appointment-booking' ); ?>
				</a>
			</li>
			<?php }
			if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress_timesheet' ) ) {
			?>
			<li>
				<a href="<?php echo add_query_arg( 'page', $bookingpress_slugs->bookingpress_timesheet, esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>" class="<?php echo ( 'timesheet' == $request_module ) ? '__bpa-is-active' : ''; ?>">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_4458_14017)">
							<path d="M17 12C14.24 12 12 14.24 12 17C12 19.76 14.24 22 17 22C19.76 22 22 19.76 22 17C22 14.24 19.76 12 17 12ZM18.65 19.35L16.5 17.2V14H17.5V16.79L19.35 18.64L18.65 19.35ZM18 3H14.82C14.4 1.84 13.3 1 12 1C10.7 1 9.6 1.84 9.18 3H6C4.9 3 4 3.9 4 5V20C4 21.1 4.9 22 6 22H12.11C11.52 21.43 11.04 20.75 10.69 20H6V5H8V8H16V5H18V10.08C18.71 10.18 19.38 10.39 20 10.68V5C20 3.9 19.1 3 18 3ZM12 5C11.45 5 11 4.55 11 4C11 3.45 11.45 3 12 3C12.55 3 13 3.45 13 4C13 4.55 12.55 5 12 5Z" fill="#727E95"/>
						</g>
						<defs>
							<clipPath id="clip0_4458_14017">
								<rect width="24" height="24" fill="white"/>
							</clipPath>
						</defs>
					</svg>
					<?php esc_html_e( 'TimeSheet', 'bookingpress-appointment-booking' ); ?>					
				</a>
			</li>
			<?php }
			if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress_myprofile' ) ) {
			?>
			<li>
				<a href="<?php echo add_query_arg( 'page', $bookingpress_slugs->bookingpress_myprofile, esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>" class="<?php echo ( 'myprofile' == $request_module ) ? '__bpa-is-active' : ''; ?>">
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_4733_13775)">
							<path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 5C13.66 5 15 6.34 15 8C15 9.66 13.66 11 12 11C10.34 11 9 9.66 9 8C9 6.34 10.34 5 12 5ZM12 19.2C9.5 19.2 7.29 17.92 6 15.98C6.03 13.99 10 12.9 12 12.9C13.99 12.9 17.97 13.99 18 15.98C16.71 17.92 14.5 19.2 12 19.2Z" fill="#727E95"/>
						</g>
						<defs>
							<clipPath id="clip0_4733_13775">
								<rect width="24" height="24" fill="white"/>
							</clipPath>
						</defs>
					</svg>
					<?php esc_html_e( 'My Profile', 'bookingpress-appointment-booking' ); ?>					
				</a>
			</li>
			<?php }
			if ( $BookingPressPro->bookingpress_check_capability( 'bookingpress_myservices' ) ) {
			?>
			<li>
				<a href="<?php echo add_query_arg( 'page', $bookingpress_slugs->bookingpress_myservices, esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>" class="<?php echo ( 'myservices' == $request_module ) ? '__bpa-is-active' : ''; ?>"> 
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<path d="M7.5 3V4.5H5.25C5.05109 4.5 4.86032 4.57902 4.71967 4.71967C4.57902 4.86032 4.5 5.05109 4.5 5.25V21.75C4.5 21.9489 4.57902 22.1397 4.71967 22.2803C4.86032 22.421 5.05109 22.5 5.25 22.5H18.75C18.9489 22.5 19.1397 22.421 19.2803 22.2803C19.421 22.1397 19.5 21.9489 19.5 21.75V5.25C19.5 5.05109 19.421 4.86032 19.2803 4.71967C19.1397 4.57902 18.9489 4.5 18.75 4.5H16.5V3H7.5ZM6 6H7.5V7.5H16.5V6H18V21H6V6ZM8.25 9C8.05109 9 7.86032 9.07902 7.71967 9.21967C7.57902 9.36032 7.5 9.55109 7.5 9.75C7.5 9.94891 7.57902 10.1397 7.71967 10.2803C7.86032 10.421 8.05109 10.5 8.25 10.5C8.44891 10.5 8.63968 10.421 8.78033 10.2803C8.92098 10.1397 9 9.94891 9 9.75C9 9.55109 8.92098 9.36032 8.78033 9.21967C8.63968 9.07902 8.44891 9 8.25 9ZM10.5 9V10.5H16.5V9H10.5ZM8.25 12C8.05109 12 7.86032 12.079 7.71967 12.2197C7.57902 12.3603 7.5 12.5511 7.5 12.75C7.5 12.9489 7.57902 13.1397 7.71967 13.2803C7.86032 13.421 8.05109 13.5 8.25 13.5C8.44891 13.5 8.63968 13.421 8.78033 13.2803C8.92098 13.1397 9 12.9489 9 12.75C9 12.5511 8.92098 12.3603 8.78033 12.2197C8.63968 12.079 8.44891 12 8.25 12ZM10.5 12V13.5H16.5V12H10.5ZM8.25 15C8.05109 15 7.86032 15.079 7.71967 15.2197C7.57902 15.3603 7.5 15.5511 7.5 15.75C7.5 15.9489 7.57902 16.1397 7.71967 16.2803C7.86032 16.421 8.05109 16.5 8.25 16.5C8.44891 16.5 8.63968 16.421 8.78033 16.2803C8.92098 16.1397 9 15.9489 9 15.75C9 15.5511 8.92098 15.3603 8.78033 15.2197C8.63968 15.079 8.44891 15 8.25 15ZM10.5 15V16.5H16.5V15H10.5ZM8.25 18C8.05109 18 7.86032 18.079 7.71967 18.2197C7.57902 18.3603 7.5 18.5511 7.5 18.75C7.5 18.9489 7.57902 19.1397 7.71967 19.2803C7.86032 19.421 8.05109 19.5 8.25 19.5C8.44891 19.5 8.63968 19.421 8.78033 19.2803C8.92098 19.1397 9 18.9489 9 18.75C9 18.5511 8.92098 18.3603 8.78033 18.2197C8.63968 18.079 8.44891 18 8.25 18ZM10.5 18V19.5H16.5V18H10.5Z" />
					</svg>
					<?php esc_html_e( 'My Services', 'bookingpress-appointment-booking' ); ?>
				</a>
			</li>
			<?php } ?>			
			<li>
				<a href="<?php echo add_query_arg( 'bookingpress_action', 'bookingpress_logout', esc_url( admin_url() . 'admin.php?page=bookingpress' ) ); // phpcs:ignore ?>">
					<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<path d="M4 12C4 12.2652 4.10536 12.5196 4.29289 12.7071C4.48043 12.8946 4.73478 13 5 13H12.59L10.29 15.29C10.1963 15.383 10.1219 15.4936 10.0711 15.6154C10.0203 15.7373 9.9942 15.868 9.9942 16C9.9942 16.132 10.0203 16.2627 10.0711 16.3846C10.1219 16.5064 10.1963 16.617 10.29 16.71C10.383 16.8037 10.4936 16.8781 10.6154 16.9289C10.7373 16.9797 10.868 17.0058 11 17.0058C11.132 17.0058 11.2627 16.9797 11.3846 16.9289C11.5064 16.8781 11.617 16.8037 11.71 16.71L15.71 12.71C15.801 12.6149 15.8724 12.5028 15.92 12.38C16.02 12.1365 16.02 11.8635 15.92 11.62C15.8724 11.4972 15.801 11.3851 15.71 11.29L11.71 7.29C11.6168 7.19676 11.5061 7.1228 11.3842 7.07234C11.2624 7.02188 11.1319 6.99591 11 6.99591C10.8681 6.99591 10.7376 7.02188 10.6158 7.07234C10.4939 7.1228 10.3832 7.19676 10.29 7.29C10.1968 7.38324 10.1228 7.49393 10.0723 7.61575C10.0219 7.73757 9.99591 7.86814 9.99591 8C9.99591 8.13186 10.0219 8.26243 10.0723 8.38425C10.1228 8.50607 10.1968 8.61676 10.29 8.71L12.59 11H5C4.73478 11 4.48043 11.1054 4.29289 11.2929C4.10536 11.4804 4 11.7348 4 12ZM17 2H7C6.20435 2 5.44129 2.31607 4.87868 2.87868C4.31607 3.44129 4 4.20435 4 5V8C4 8.26522 4.10536 8.51957 4.29289 8.70711C4.48043 8.89464 4.73478 9 5 9C5.26522 9 5.51957 8.89464 5.70711 8.70711C5.89464 8.51957 6 8.26522 6 8V5C6 4.73478 6.10536 4.48043 6.29289 4.29289C6.48043 4.10536 6.73478 4 7 4H17C17.2652 4 17.5196 4.10536 17.7071 4.29289C17.8946 4.48043 18 4.73478 18 5V19C18 19.2652 17.8946 19.5196 17.7071 19.7071C17.5196 19.8946 17.2652 20 17 20H7C6.73478 20 6.48043 19.8946 6.29289 19.7071C6.10536 19.5196 6 19.2652 6 19V16C6 15.7348 5.89464 15.4804 5.70711 15.2929C5.51957 15.1054 5.26522 15 5 15C4.73478 15 4.48043 15.1054 4.29289 15.2929C4.10536 15.4804 4 15.7348 4 16V19C4 19.7956 4.31607 20.5587 4.87868 21.1213C5.44129 21.6839 6.20435 22 7 22H17C17.7956 22 18.5587 21.6839 19.1213 21.1213C19.6839 20.5587 20 19.7956 20 19V5C20 4.20435 19.6839 3.44129 19.1213 2.87868C18.5587 2.31607 17.7956 2 17 2Z" />
					</svg>
					<?php esc_html_e( 'Logout', 'bookingpress-appointment-booking' ); ?>
				</a>
			</li>
			<?php if(!empty($bookingpress_staffmember_access_admin) && $bookingpress_staffmember_access_admin == 'true') { ?>
			<li class="bpa-ssn-nav__swtich-wp-btn">
				<el-button class="bpa-btn bpa-btn--full-width" @click="bpa_staffmember_open_admin_view">
					<svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
						<path d="M2.59288 9.9999C2.59239 12.8384 4.21392 15.4275 6.7678 16.6663L3.23415 6.98541C2.81055 7.93387 2.59207 8.96111 2.59288 9.9999ZM10.1304 10.6478L7.90755 17.1058C9.3999 17.5452 10.9927 17.5039 12.4602 16.9876C12.4396 16.9552 12.4218 16.9211 12.4071 16.8855L10.1304 10.6478ZM15.0009 9.62636C14.9909 8.90192 14.7795 8.19456 14.3902 7.58355C13.9921 7.08263 13.7402 6.48134 13.6625 5.84619C13.6446 5.1403 14.2006 4.55263 14.9065 4.53158C14.9393 4.53158 14.9705 4.53554 15.0024 4.53754C11.9864 1.77485 7.30187 1.98025 4.53922 4.99621C4.27191 5.28798 4.02848 5.6007 3.8112 5.93137C3.98503 5.9369 4.14887 5.94038 4.28787 5.94038C5.0625 5.94038 6.26216 5.84614 6.26216 5.84614C6.43099 5.83638 6.57579 5.96534 6.58556 6.13417C6.59505 6.29834 6.47314 6.44071 6.30946 6.4566C6.30946 6.4566 5.90799 6.50359 5.46181 6.52696L8.15907 14.5505L9.78038 9.68891L8.6263 6.52702C8.22721 6.50363 7.84939 6.45665 7.84939 6.45665C7.6811 6.44038 7.55784 6.29074 7.57406 6.12245C7.5899 5.95865 7.73232 5.8367 7.89654 5.84619C7.89654 5.84619 9.11952 5.94043 9.84728 5.94043C10.6219 5.94043 11.8218 5.84619 11.8218 5.84619C11.9906 5.83632 12.1355 5.96517 12.1453 6.13395C12.1549 6.29834 12.0329 6.44092 11.869 6.45665C11.869 6.45665 11.4672 6.50364 11.0213 6.52702L13.6982 14.4895L14.4623 12.0681C14.7607 11.2851 14.9422 10.4623 15.0009 9.62636ZM16.5502 7.20801C16.5374 8.12066 16.346 9.02203 15.9868 9.86112L13.7244 16.4024C17.1943 14.3839 18.4252 9.96908 16.5004 6.4464C16.5341 6.69884 16.5507 6.95329 16.5502 7.20801ZM10.0002 1.11133C5.09104 1.11133 1.11133 5.09104 1.11133 10.0002C1.11133 14.9094 5.09104 18.8891 10.0002 18.8891C14.9094 18.8891 18.8891 14.9094 18.8891 10.0002C18.8891 5.09104 14.9094 1.11133 10.0002 1.11133ZM13.2524 17.6993C10.6511 18.8002 7.66944 18.5104 5.32888 16.9291C3.98536 16.022 2.93365 14.7449 2.301 13.2524C1.19987 10.6511 1.4898 7.66933 3.0714 5.32888C3.9783 3.98524 5.25543 2.93343 6.74805 2.30105C9.34934 1.2002 12.331 1.49002 14.6716 3.07129C16.0151 3.97836 17.0668 5.25548 17.6994 6.74799C18.8006 9.34928 18.5106 12.3311 16.929 14.6715C16.0221 16.0151 14.745 17.067 13.2524 17.6993Z" />
					</svg>
					<?php esc_html_e( 'Swtich to WordPress', 'bookingpress-appointment-booking' ); ?>
				</el-button>
			</li>
			<?php } ?>
		</ul>
	</div>
</div>
<div class="bpa-staff-header-navbar__mob">
	<div class="bpa-shn-mob__wrap">
		<div class="bpa-shn-wrap__left">
			<a href="#">
				<svg viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg">
					<rect width="64" height="64" rx="12"/>
					<path d="M50 18.9608V47.2745C50 49.3359 48.325 51 46.25 51H17.75C15.675 51 14 49.3359 14 47.2745V18.9608C14 16.8993 15.675 15.2353 17.75 15.2353H23V14.1176C23 13.7451 23.375 13 24.125 13C24.875 13 25.25 13.7451 25.25 14.1176V18.5882C25.25 18.9608 24.875 19.7059 24.125 19.7059C23.375 19.7059 23 18.9608 23 18.5882V17.4706H18.5C17.25 17.4706 16.25 18.4641 16.25 19.7059V46.5294C16.25 47.7712 17.25 48.7647 18.5 48.7647H45.5C46.75 48.7647 47.75 47.7712 47.75 46.5294V19.7059C47.75 18.4641 46.75 17.4706 45.5 17.4706H41C41 17.4706 41 18.0418 41 18.5882C41 18.9608 40.625 19.7059 39.875 19.7059C39.125 19.7059 38.75 18.9608 38.75 18.5882V17.4706H33.125C32.5 17.4706 32 16.9739 32 16.3529C32 15.732 32.5 15.2353 33.125 15.2353H38.75V14.1176C38.75 13.7451 39.125 13 39.875 13C40.625 13 41 13.7451 41 14.1176V15.2353H46.25C48.325 15.2353 50 16.8993 50 18.9608Z" fill="white"/>
					<path d="M37.2501 30.8823C37.2501 30.8823 38.0001 30.1372 38.0001 27.9019C38.0001 24.1765 35.7501 23.4314 32.7501 23.4314H26.0001V39.0784H30.5001V43.549H32.7501V39.0784C35.3501 39.0784 37.1751 39.0784 38.5251 37.4144C39.1751 36.6196 39.5001 35.6013 39.5001 34.5582C39.5001 34.0118 39.4251 33.4654 39.3001 33.1176C38.9751 32.2732 38.7501 31.6274 37.2501 30.8823ZM35.0001 36.8431C34.2501 36.8431 32.7501 36.8431 32.7501 36.8431C32.7501 36.8431 32.7501 36.098 32.7501 34.6078C32.7501 33.366 33.7501 32.3725 35.0001 32.3725C36.2001 32.3725 37.2501 33.3412 37.2501 34.6078C37.2501 35.9242 36.1501 36.8431 35.0001 36.8431ZM33.1751 30.6836C32.8001 30.8575 32.4251 31.081 32.0751 31.3294C31.2501 31.9503 30.5001 32.8444 30.5001 34.6078V36.8431H28.2501V25.6667H32.7501C34.5501 25.6667 35.7501 26.4118 35.7501 27.9019C35.7501 29.268 34.7251 29.9137 33.1751 30.6836Z" fill="white"/>
				</svg>
			</a>
		</div>
		<div class="bpa-shn-wrap__right">
			<svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
				<path d="M14.9102 8.82422C14.9102 5.01172 12.8594 3.71484 10.9414 3.42578C10.9414 3.40625 10.9453 3.38672 10.9453 3.36328C10.9453 2.88281 10.5195 2.5 10 2.5C9.48047 2.5 9.07031 2.88281 9.07031 3.36328C9.07031 3.38672 9.07031 3.40625 9.07422 3.42578C7.15234 3.71875 5.08984 5.01953 5.08984 8.83203C5.08984 13.2773 3.98438 13.7539 2.5 15.0039H17.5C16.0234 13.75 14.9102 13.2695 14.9102 8.82422Z" fill="#727E95"/>
				<path d="M10.0078 17.5C11.0547 17.5 11.9141 16.7227 12.0273 15.8203H7.98828C8.09766 16.7227 8.96094 17.5 10.0078 17.5Z" fill="#727E95"/>
			</svg>
			<div class="bpa-shn-mob-hamburger" @click="bpa_staffmemeber_toogle_menu" :class="(bpa_toggle_active == 1) ? '__bpa-is-active' : ''">
				<div class="bpa-menu-toggle" id="bpa-mobile-menu">
					<span class="bpa-mm-bar"></span>
					<span class="bpa-mm-bar"></span>
					<span class="bpa-mm-bar"></span>
				</div>
			</div>
		</div>
	</div>
</div>
<?php } ?>
<div class="mob-nav-overlay" id="mob-nav-overlay"></div>

<?php if(!empty($bookingpress_upcomming_appointment)) { ?>
<el-dialog custom-class="bpa-dialog bpa-dailog__small bpa-dialog--staff-upcoming-appointment" id="staffmember_customize_notification_model" title="" :visible.sync="staffmember_customize_notification_model" :close-on-press-escape="close_modal_on_esc" :modal="is_mask_display" @open="bookingpress_enable_modal" @close="bookingpress_disable_modal">	
	<div class="bpa-dialog-body">
		<div class="bpa-sua__wrapper">
			<div class="bpa-sua-upcoming-pill">
				<el-tag><?php esc_html_e('Upcoming','bookingpress-appointment-booking'); ?></el-tag>
			</div>
		</div>
		<div class="bpa-sua__info-wrapper">
			<div class="bpa-sua-iw__head">
				<span><?php echo esc_html__('ID','bookingpress-appointment-booking').': #'.esc_html($bookingpress_upcomming_appointment['booking_id']); ?></span>
				<h4><?php  echo esc_html($bookingpress_upcomming_appointment['service_name']); ?></h4>
			</div>
			<div class="bpa-sua-iw__body">
				<div class="bpa-sua-iw__body-item">
					<div class="bpa-sua-iw__body-item-row">
						<span><?php esc_html_e('Date:','bookingpress-appointment-booking'); ?></span>
						<p><?php  echo esc_html($bookingpress_upcomming_appointment['appointment_date']); ?></p>
					</div>
					<div class="bpa-sua-iw__body-item-row">
						<span><?php esc_html_e('Duration:','bookingpress-appointment-booking'); ?></span>
						<p><?php echo esc_html($bookingpress_upcomming_appointment['appointment_duration']); ?></p>
					</div>
				</div>
				<div class="bpa-sua-iw__body-item">
					<h5><?php esc_html_e('Customer Details','bookingpress-appointment-booking'); ?></h5>
					<div class="bpa-sua-iw__body-item-row">
						<span><?php esc_html_e('Full Name:','bookingpress-appointment-booking'); ?></span>
						<p><?php echo esc_html($bookingpress_upcomming_appointment['customer_name']); ?></p>
					</div>
					<div class="bpa-sua-iw__body-item-row">
						<span><?php esc_html_e('Email:','bookingpress-appointment-booking'); ?></span>
						<p><?php echo esc_html($bookingpress_upcomming_appointment['customer_email']); ?></p>
					</div>
				</div>
			</div>
		</div>
	</div>
</el-dialog>
<?php } ?>