<?php

namespace BookneticApp\Backend\Boostore\Helpers;

use BookneticApp\Models\Cart;
use BookneticVendor\GuzzleHttp\Client;
use Exception;
use BookneticApp\Providers\Helpers\Helper;
use BookneticApp\Providers\Core\Bootstrap;
use BookneticApp\Providers\Core\PluginInstaller;

class BoostoreHelper
{
    private static $baseURL = 'https://api.fs-code.com/store/booknetic';

    private static $version = null;

    public static function get ( $slug, $data = [], $default = [] )
    {
        if ( $slug == 'addons' ) {
            $page = '';
            if ( ! empty( $data['page'] ) ) {
                $page = '-' . $data['page'];
            }
            $addons = json_decode(
                wp_remote_retrieve_body(
                    wp_remote_get(
                        "http://wordpressnull.org/booknetic/addons{$page}.json",
                        [ 'timeout' => 60, 'sslverify' => false ]
                    )
                ),
                true
            );
            return $addons;
        } elseif ( $slug == 'categories' ) {
            return json_decode(
                wp_remote_retrieve_body(
                    wp_remote_get(
                        'http://wordpressnull.org/booknetic/categories.json',
                        [ 'timeout' => 60, 'sslverify' => false ]
                    )
                ),
                true
            );
        } elseif ( strpos( $slug, 'generate_download_url/' ) !== false ) {
            $addon_slug = str_replace( 'generate_download_url/', '', $slug );
            return [
                'download_url' => "http://wordpressnull.org/booknetic/addons/{$addon_slug}.zip"
            ];
        } elseif ( strpos( $slug, 'get_migrations/' ) !== false ) {
            $addon_slug = str_replace( 'get_migrations/', '', $slug );
            return json_decode(
                wp_remote_retrieve_body(
                    wp_remote_get(
                        "http://wordpressnull.org/booknetic/addons/{$addon_slug}.json",
                        [ 'timeout' => 60, 'sslverify' => false ]
                    )
                ),
                true
            );
        }
        return $default;
        try
        {
            $client = new Client( [
                'verify'  => false,
                'headers' => [
                    'Authorization' => 'Bearer ' . Helper::getOption( 'access_token', '', false ),
                    'Product'       => 'Booknetic ' . Helper::getInstalledVersion(),
                    'Content-Type'  => 'application/json',
                ],
            ] );

            $response = $client->post( static::$baseURL . '/' . $slug, [ 'body' => json_encode( $data ) ] );

            $apiRes = json_decode( $response->getBody(), true );

            if ( ! empty( $apiRes ) && $response->getStatusCode() === 200 )
            {
                if ( $apiRes[ 'status' ] === 200 )
                {
                    return $apiRes[ 'body' ];
                }
                else
                {
                    throw new Exception();
                }
            }
            else
            {
                throw new Exception();
            }
        }
        catch ( Exception $e )
        {
            return $default;
        }
    }

    public static function getAddonSlug ( $slug )
    {
        $plugins = get_plugins();

        foreach ( $plugins as $pluginKey => $pluginInfo )
        {
            if ( explode( '/', $pluginKey )[ 0 ] === $slug )
            {
                return $pluginKey;
            }
        }

        return '';
    }

    public static function installAddon ( $slug, $downloadURL )
    {
        ignore_user_abort( true );
        set_time_limit( 0 );

        $addonInstaller = new PluginInstaller( $downloadURL, $slug );

        if ( $addonInstaller->install() )
        {
            return activate_plugin( BoostoreHelper::getAddonSlug( $slug ) ) === null;
        }

        return false;
    }

    public static function uninstallAddon ( $slug )
    {
        if ( ! empty( BoostoreHelper::getAddonSlug( $slug ) ) && file_exists( realpath( WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . BoostoreHelper::getAddonSlug( $slug ) ) ) )
        {
            unset( Bootstrap::$addons[ $slug ] );

            return delete_plugins( [ self::getAddonSlug( $slug ) ] ) === true;
        }

        return false;
    }

    public static function getAllAddons()
    {
        return BoostoreHelper::get( 'addons', [ 'list_all_addons' => true ], [ 'items' => [] ] );
    }

    public static function isInstalled( $slug )
    {
        return ! empty( BoostoreHelper::getAddonSlug( $slug ) ) &&
            file_exists(
                realpath(
                    WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . BoostoreHelper::getAddonSlug( $slug )
                ));
    }

    public static function recalculatePrices()
    {
        $cart = Cart::select( 'slug' )->where( 'active', 1 )->fetchAll();

        if ( empty( $cart ) )
            return [];

        $cartPrices = [];
        $totalPrice = 0;

        $cart = array_map( function( $addon ) {
            return $addon->slug;
        }, $cart );

        foreach( static::getAllAddons()['items'] AS $addon )
        {
            if ( in_array( $addon['slug'], $cart ) )
            {
                $cartPrices[] = [ 'slug' => $addon['slug'], 'price' => $addon['price']['current'] ];
                $totalPrice += $addon['price']['current'];
            }
        }

        $cartPrices[ 'total_price' ] = $totalPrice;

        return $cartPrices;

    }

    public static function whichVersion()
    {
        if ( empty( self::$version ) )
        {
            self::$version = self::get('get_boostore_version', [], ['version' => 1])['version'];
        }

        return self::$version;
    }

}
