<?php
/**
 * Internationalization: States
 *
 * Taken from simple-pay: https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/plugins/woocommerce/i18n/states.php
 *
 * @package SimplePay\Core
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 4.6.0
 */

namespace SimplePay\Core\i18n;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return array(
	'AF' => array(),
	'AL' => array( // Albanian states.
		'AL-01' => __( 'Berat', 'stripe' ),
		'AL-09' => __( 'Dibër', 'stripe' ),
		'AL-02' => __( 'Durrës', 'stripe' ),
		'AL-03' => __( 'Elbasan', 'stripe' ),
		'AL-04' => __( 'Fier', 'stripe' ),
		'AL-05' => __( 'Gjirokastër', 'stripe' ),
		'AL-06' => __( 'Korçë', 'stripe' ),
		'AL-07' => __( 'Kukës', 'stripe' ),
		'AL-08' => __( 'Lezhë', 'stripe' ),
		'AL-10' => __( 'Shkodër', 'stripe' ),
		'AL-11' => __( 'Tirana', 'stripe' ),
		'AL-12' => __( 'Vlorë', 'stripe' ),
	),
	'AO' => array( // Angolan states.
		'BGO' => __( 'Bengo', 'stripe' ),
		'BLU' => __( 'Benguela', 'stripe' ),
		'BIE' => __( 'Bié', 'stripe' ),
		'CAB' => __( 'Cabinda', 'stripe' ),
		'CNN' => __( 'Cunene', 'stripe' ),
		'HUA' => __( 'Huambo', 'stripe' ),
		'HUI' => __( 'Huíla', 'stripe' ),
		'CCU' => __( 'Kuando Kubango', 'stripe' ),
		'CNO' => __( 'Kwanza-Norte', 'stripe' ),
		'CUS' => __( 'Kwanza-Sul', 'stripe' ),
		'LUA' => __( 'Luanda', 'stripe' ),
		'LNO' => __( 'Lunda-Norte', 'stripe' ),
		'LSU' => __( 'Lunda-Sul', 'stripe' ),
		'MAL' => __( 'Malanje', 'stripe' ),
		'MOX' => __( 'Moxico', 'stripe' ),
		'NAM' => __( 'Namibe', 'stripe' ),
		'UIG' => __( 'Uíge', 'stripe' ),
		'ZAI' => __( 'Zaire', 'stripe' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'stripe' ),
		'B' => __( 'Buenos Aires', 'stripe' ),
		'K' => __( 'Catamarca', 'stripe' ),
		'H' => __( 'Chaco', 'stripe' ),
		'U' => __( 'Chubut', 'stripe' ),
		'X' => __( 'Córdoba', 'stripe' ),
		'W' => __( 'Corrientes', 'stripe' ),
		'E' => __( 'Entre Ríos', 'stripe' ),
		'P' => __( 'Formosa', 'stripe' ),
		'Y' => __( 'Jujuy', 'stripe' ),
		'L' => __( 'La Pampa', 'stripe' ),
		'F' => __( 'La Rioja', 'stripe' ),
		'M' => __( 'Mendoza', 'stripe' ),
		'N' => __( 'Misiones', 'stripe' ),
		'Q' => __( 'Neuquén', 'stripe' ),
		'R' => __( 'Río Negro', 'stripe' ),
		'A' => __( 'Salta', 'stripe' ),
		'J' => __( 'San Juan', 'stripe' ),
		'D' => __( 'San Luis', 'stripe' ),
		'Z' => __( 'Santa Cruz', 'stripe' ),
		'S' => __( 'Santa Fe', 'stripe' ),
		'G' => __( 'Santiago del Estero', 'stripe' ),
		'V' => __( 'Tierra del Fuego', 'stripe' ),
		'T' => __( 'Tucumán', 'stripe' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'stripe' ),
		'NSW' => __( 'New South Wales', 'stripe' ),
		'NT'  => __( 'Northern Territory', 'stripe' ),
		'QLD' => __( 'Queensland', 'stripe' ),
		'SA'  => __( 'South Australia', 'stripe' ),
		'TAS' => __( 'Tasmania', 'stripe' ),
		'VIC' => __( 'Victoria', 'stripe' ),
		'WA'  => __( 'Western Australia', 'stripe' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi districts.
		'BD-05' => __( 'Bagerhat', 'stripe' ),
		'BD-01' => __( 'Bandarban', 'stripe' ),
		'BD-02' => __( 'Barguna', 'stripe' ),
		'BD-06' => __( 'Barishal', 'stripe' ),
		'BD-07' => __( 'Bhola', 'stripe' ),
		'BD-03' => __( 'Bogura', 'stripe' ),
		'BD-04' => __( 'Brahmanbaria', 'stripe' ),
		'BD-09' => __( 'Chandpur', 'stripe' ),
		'BD-10' => __( 'Chattogram', 'stripe' ),
		'BD-12' => __( 'Chuadanga', 'stripe' ),
		'BD-11' => __( "Cox's Bazar", 'stripe' ),
		'BD-08' => __( 'Cumilla', 'stripe' ),
		'BD-13' => __( 'Dhaka', 'stripe' ),
		'BD-14' => __( 'Dinajpur', 'stripe' ),
		'BD-15' => __( 'Faridpur ', 'stripe' ),
		'BD-16' => __( 'Feni', 'stripe' ),
		'BD-19' => __( 'Gaibandha', 'stripe' ),
		'BD-18' => __( 'Gazipur', 'stripe' ),
		'BD-17' => __( 'Gopalganj', 'stripe' ),
		'BD-20' => __( 'Habiganj', 'stripe' ),
		'BD-21' => __( 'Jamalpur', 'stripe' ),
		'BD-22' => __( 'Jashore', 'stripe' ),
		'BD-25' => __( 'Jhalokati', 'stripe' ),
		'BD-23' => __( 'Jhenaidah', 'stripe' ),
		'BD-24' => __( 'Joypurhat', 'stripe' ),
		'BD-29' => __( 'Khagrachhari', 'stripe' ),
		'BD-27' => __( 'Khulna', 'stripe' ),
		'BD-26' => __( 'Kishoreganj', 'stripe' ),
		'BD-28' => __( 'Kurigram', 'stripe' ),
		'BD-30' => __( 'Kushtia', 'stripe' ),
		'BD-31' => __( 'Lakshmipur', 'stripe' ),
		'BD-32' => __( 'Lalmonirhat', 'stripe' ),
		'BD-36' => __( 'Madaripur', 'stripe' ),
		'BD-37' => __( 'Magura', 'stripe' ),
		'BD-33' => __( 'Manikganj ', 'stripe' ),
		'BD-39' => __( 'Meherpur', 'stripe' ),
		'BD-38' => __( 'Moulvibazar', 'stripe' ),
		'BD-35' => __( 'Munshiganj', 'stripe' ),
		'BD-34' => __( 'Mymensingh', 'stripe' ),
		'BD-48' => __( 'Naogaon', 'stripe' ),
		'BD-43' => __( 'Narail', 'stripe' ),
		'BD-40' => __( 'Narayanganj', 'stripe' ),
		'BD-42' => __( 'Narsingdi', 'stripe' ),
		'BD-44' => __( 'Natore', 'stripe' ),
		'BD-45' => __( 'Nawabganj', 'stripe' ),
		'BD-41' => __( 'Netrakona', 'stripe' ),
		'BD-46' => __( 'Nilphamari', 'stripe' ),
		'BD-47' => __( 'Noakhali', 'stripe' ),
		'BD-49' => __( 'Pabna', 'stripe' ),
		'BD-52' => __( 'Panchagarh', 'stripe' ),
		'BD-51' => __( 'Patuakhali', 'stripe' ),
		'BD-50' => __( 'Pirojpur', 'stripe' ),
		'BD-53' => __( 'Rajbari', 'stripe' ),
		'BD-54' => __( 'Rajshahi', 'stripe' ),
		'BD-56' => __( 'Rangamati', 'stripe' ),
		'BD-55' => __( 'Rangpur', 'stripe' ),
		'BD-58' => __( 'Satkhira', 'stripe' ),
		'BD-62' => __( 'Shariatpur', 'stripe' ),
		'BD-57' => __( 'Sherpur', 'stripe' ),
		'BD-59' => __( 'Sirajganj', 'stripe' ),
		'BD-61' => __( 'Sunamganj', 'stripe' ),
		'BD-60' => __( 'Sylhet', 'stripe' ),
		'BD-63' => __( 'Tangail', 'stripe' ),
		'BD-64' => __( 'Thakurgaon', 'stripe' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'stripe' ),
		'BG-02' => __( 'Burgas', 'stripe' ),
		'BG-08' => __( 'Dobrich', 'stripe' ),
		'BG-07' => __( 'Gabrovo', 'stripe' ),
		'BG-26' => __( 'Haskovo', 'stripe' ),
		'BG-09' => __( 'Kardzhali', 'stripe' ),
		'BG-10' => __( 'Kyustendil', 'stripe' ),
		'BG-11' => __( 'Lovech', 'stripe' ),
		'BG-12' => __( 'Montana', 'stripe' ),
		'BG-13' => __( 'Pazardzhik', 'stripe' ),
		'BG-14' => __( 'Pernik', 'stripe' ),
		'BG-15' => __( 'Pleven', 'stripe' ),
		'BG-16' => __( 'Plovdiv', 'stripe' ),
		'BG-17' => __( 'Razgrad', 'stripe' ),
		'BG-18' => __( 'Ruse', 'stripe' ),
		'BG-27' => __( 'Shumen', 'stripe' ),
		'BG-19' => __( 'Silistra', 'stripe' ),
		'BG-20' => __( 'Sliven', 'stripe' ),
		'BG-21' => __( 'Smolyan', 'stripe' ),
		'BG-23' => __( 'Sofia District', 'stripe' ),
		'BG-22' => __( 'Sofia', 'stripe' ),
		'BG-24' => __( 'Stara Zagora', 'stripe' ),
		'BG-25' => __( 'Targovishte', 'stripe' ),
		'BG-03' => __( 'Varna', 'stripe' ),
		'BG-04' => __( 'Veliko Tarnovo', 'stripe' ),
		'BG-05' => __( 'Vidin', 'stripe' ),
		'BG-06' => __( 'Vratsa', 'stripe' ),
		'BG-28' => __( 'Yambol', 'stripe' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Beninese states.
		'AL' => __( 'Alibori', 'stripe' ),
		'AK' => __( 'Atakora', 'stripe' ),
		'AQ' => __( 'Atlantique', 'stripe' ),
		'BO' => __( 'Borgou', 'stripe' ),
		'CO' => __( 'Collines', 'stripe' ),
		'KO' => __( 'Kouffo', 'stripe' ),
		'DO' => __( 'Donga', 'stripe' ),
		'LI' => __( 'Littoral', 'stripe' ),
		'MO' => __( 'Mono', 'stripe' ),
		'OU' => __( 'Ouémé', 'stripe' ),
		'PL' => __( 'Plateau', 'stripe' ),
		'ZO' => __( 'Zou', 'stripe' ),
	),
	'BO' => array( // Bolivian states.
		'BO-B' => __( 'Beni', 'stripe' ),
		'BO-H' => __( 'Chuquisaca', 'stripe' ),
		'BO-C' => __( 'Cochabamba', 'stripe' ),
		'BO-L' => __( 'La Paz', 'stripe' ),
		'BO-O' => __( 'Oruro', 'stripe' ),
		'BO-N' => __( 'Pando', 'stripe' ),
		'BO-P' => __( 'Potosí', 'stripe' ),
		'BO-S' => __( 'Santa Cruz', 'stripe' ),
		'BO-T' => __( 'Tarija', 'stripe' ),
	),
	'BR' => array( // Brazilian states.
		'AC' => __( 'Acre', 'stripe' ),
		'AL' => __( 'Alagoas', 'stripe' ),
		'AP' => __( 'Amapá', 'stripe' ),
		'AM' => __( 'Amazonas', 'stripe' ),
		'BA' => __( 'Bahia', 'stripe' ),
		'CE' => __( 'Ceará', 'stripe' ),
		'DF' => __( 'Distrito Federal', 'stripe' ),
		'ES' => __( 'Espírito Santo', 'stripe' ),
		'GO' => __( 'Goiás', 'stripe' ),
		'MA' => __( 'Maranhão', 'stripe' ),
		'MT' => __( 'Mato Grosso', 'stripe' ),
		'MS' => __( 'Mato Grosso do Sul', 'stripe' ),
		'MG' => __( 'Minas Gerais', 'stripe' ),
		'PA' => __( 'Pará', 'stripe' ),
		'PB' => __( 'Paraíba', 'stripe' ),
		'PR' => __( 'Paraná', 'stripe' ),
		'PE' => __( 'Pernambuco', 'stripe' ),
		'PI' => __( 'Piauí', 'stripe' ),
		'RJ' => __( 'Rio de Janeiro', 'stripe' ),
		'RN' => __( 'Rio Grande do Norte', 'stripe' ),
		'RS' => __( 'Rio Grande do Sul', 'stripe' ),
		'RO' => __( 'Rondônia', 'stripe' ),
		'RR' => __( 'Roraima', 'stripe' ),
		'SC' => __( 'Santa Catarina', 'stripe' ),
		'SP' => __( 'São Paulo', 'stripe' ),
		'SE' => __( 'Sergipe', 'stripe' ),
		'TO' => __( 'Tocantins', 'stripe' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'stripe' ),
		'BC' => __( 'British Columbia', 'stripe' ),
		'MB' => __( 'Manitoba', 'stripe' ),
		'NB' => __( 'New Brunswick', 'stripe' ),
		'NL' => __( 'Newfoundland and Labrador', 'stripe' ),
		'NT' => __( 'Northwest Territories', 'stripe' ),
		'NS' => __( 'Nova Scotia', 'stripe' ),
		'NU' => __( 'Nunavut', 'stripe' ),
		'ON' => __( 'Ontario', 'stripe' ),
		'PE' => __( 'Prince Edward Island', 'stripe' ),
		'QC' => __( 'Quebec', 'stripe' ),
		'SK' => __( 'Saskatchewan', 'stripe' ),
		'YT' => __( 'Yukon Territory', 'stripe' ),
	),
	'CH' => array( // Swiss cantons.
		'AG' => __( 'Aargau', 'stripe' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'stripe' ),
		'AI' => __( 'Appenzell Innerrhoden', 'stripe' ),
		'BL' => __( 'Basel-Landschaft', 'stripe' ),
		'BS' => __( 'Basel-Stadt', 'stripe' ),
		'BE' => __( 'Bern', 'stripe' ),
		'FR' => __( 'Fribourg', 'stripe' ),
		'GE' => __( 'Geneva', 'stripe' ),
		'GL' => __( 'Glarus', 'stripe' ),
		'GR' => __( 'Graubünden', 'stripe' ),
		'JU' => __( 'Jura', 'stripe' ),
		'LU' => __( 'Luzern', 'stripe' ),
		'NE' => __( 'Neuchâtel', 'stripe' ),
		'NW' => __( 'Nidwalden', 'stripe' ),
		'OW' => __( 'Obwalden', 'stripe' ),
		'SH' => __( 'Schaffhausen', 'stripe' ),
		'SZ' => __( 'Schwyz', 'stripe' ),
		'SO' => __( 'Solothurn', 'stripe' ),
		'SG' => __( 'St. Gallen', 'stripe' ),
		'TG' => __( 'Thurgau', 'stripe' ),
		'TI' => __( 'Ticino', 'stripe' ),
		'UR' => __( 'Uri', 'stripe' ),
		'VS' => __( 'Valais', 'stripe' ),
		'VD' => __( 'Vaud', 'stripe' ),
		'ZG' => __( 'Zug', 'stripe' ),
		'ZH' => __( 'Zürich', 'stripe' ),
	),
	'CL' => array( // Chilean states.
		'CL-AI' => __( 'Aisén del General Carlos Ibañez del Campo', 'stripe' ),
		'CL-AN' => __( 'Antofagasta', 'stripe' ),
		'CL-AP' => __( 'Arica y Parinacota', 'stripe' ),
		'CL-AR' => __( 'La Araucanía', 'stripe' ),
		'CL-AT' => __( 'Atacama', 'stripe' ),
		'CL-BI' => __( 'Biobío', 'stripe' ),
		'CL-CO' => __( 'Coquimbo', 'stripe' ),
		'CL-LI' => __( 'Libertador General Bernardo O\'Higgins', 'stripe' ),
		'CL-LL' => __( 'Los Lagos', 'stripe' ),
		'CL-LR' => __( 'Los Ríos', 'stripe' ),
		'CL-MA' => __( 'Magallanes', 'stripe' ),
		'CL-ML' => __( 'Maule', 'stripe' ),
		'CL-NB' => __( 'Ñuble', 'stripe' ),
		'CL-RM' => __( 'Región Metropolitana de Santiago', 'stripe' ),
		'CL-TA' => __( 'Tarapacá', 'stripe' ),
		'CL-VS' => __( 'Valparaíso', 'stripe' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'stripe' ),
		'CN2'  => __( 'Beijing / 北京', 'stripe' ),
		'CN3'  => __( 'Tianjin / 天津', 'stripe' ),
		'CN4'  => __( 'Hebei / 河北', 'stripe' ),
		'CN5'  => __( 'Shanxi / 山西', 'stripe' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'stripe' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'stripe' ),
		'CN8'  => __( 'Jilin / 吉林', 'stripe' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'stripe' ),
		'CN10' => __( 'Shanghai / 上海', 'stripe' ),
		'CN11' => __( 'Jiangsu / 江苏', 'stripe' ),
		'CN12' => __( 'Zhejiang / 浙江', 'stripe' ),
		'CN13' => __( 'Anhui / 安徽', 'stripe' ),
		'CN14' => __( 'Fujian / 福建', 'stripe' ),
		'CN15' => __( 'Jiangxi / 江西', 'stripe' ),
		'CN16' => __( 'Shandong / 山东', 'stripe' ),
		'CN17' => __( 'Henan / 河南', 'stripe' ),
		'CN18' => __( 'Hubei / 湖北', 'stripe' ),
		'CN19' => __( 'Hunan / 湖南', 'stripe' ),
		'CN20' => __( 'Guangdong / 广东', 'stripe' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'stripe' ),
		'CN22' => __( 'Hainan / 海南', 'stripe' ),
		'CN23' => __( 'Chongqing / 重庆', 'stripe' ),
		'CN24' => __( 'Sichuan / 四川', 'stripe' ),
		'CN25' => __( 'Guizhou / 贵州', 'stripe' ),
		'CN26' => __( 'Shaanxi / 陕西', 'stripe' ),
		'CN27' => __( 'Gansu / 甘肃', 'stripe' ),
		'CN28' => __( 'Qinghai / 青海', 'stripe' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'stripe' ),
		'CN30' => __( 'Macao / 澳门', 'stripe' ),
		'CN31' => __( 'Tibet / 西藏', 'stripe' ),
		'CN32' => __( 'Xinjiang / 新疆', 'stripe' ),
	),
	'CO' => array( // Colombian states.
		'CO-AMA' => __( 'Amazonas', 'stripe' ),
		'CO-ANT' => __( 'Antioquia', 'stripe' ),
		'CO-ARA' => __( 'Arauca', 'stripe' ),
		'CO-ATL' => __( 'Atlántico', 'stripe' ),
		'CO-BOL' => __( 'Bolívar', 'stripe' ),
		'CO-BOY' => __( 'Boyacá', 'stripe' ),
		'CO-CAL' => __( 'Caldas', 'stripe' ),
		'CO-CAQ' => __( 'Caquetá', 'stripe' ),
		'CO-CAS' => __( 'Casanare', 'stripe' ),
		'CO-CAU' => __( 'Cauca', 'stripe' ),
		'CO-CES' => __( 'Cesar', 'stripe' ),
		'CO-CHO' => __( 'Chocó', 'stripe' ),
		'CO-COR' => __( 'Córdoba', 'stripe' ),
		'CO-CUN' => __( 'Cundinamarca', 'stripe' ),
		'CO-DC'  => __( 'Capital District', 'stripe' ),
		'CO-GUA' => __( 'Guainía', 'stripe' ),
		'CO-GUV' => __( 'Guaviare', 'stripe' ),
		'CO-HUI' => __( 'Huila', 'stripe' ),
		'CO-LAG' => __( 'La Guajira', 'stripe' ),
		'CO-MAG' => __( 'Magdalena', 'stripe' ),
		'CO-MET' => __( 'Meta', 'stripe' ),
		'CO-NAR' => __( 'Nariño', 'stripe' ),
		'CO-NSA' => __( 'Norte de Santander', 'stripe' ),
		'CO-PUT' => __( 'Putumayo', 'stripe' ),
		'CO-QUI' => __( 'Quindío', 'stripe' ),
		'CO-RIS' => __( 'Risaralda', 'stripe' ),
		'CO-SAN' => __( 'Santander', 'stripe' ),
		'CO-SAP' => __( 'San Andrés & Providencia', 'stripe' ),
		'CO-SUC' => __( 'Sucre', 'stripe' ),
		'CO-TOL' => __( 'Tolima', 'stripe' ),
		'CO-VAC' => __( 'Valle del Cauca', 'stripe' ),
		'CO-VAU' => __( 'Vaupés', 'stripe' ),
		'CO-VID' => __( 'Vichada', 'stripe' ),
	),
	'CR' => array( // Costa Rican states.
		'CR-A'  => __( 'Alajuela', 'stripe' ),
		'CR-C'  => __( 'Cartago', 'stripe' ),
		'CR-G'  => __( 'Guanacaste', 'stripe' ),
		'CR-H'  => __( 'Heredia', 'stripe' ),
		'CR-L'  => __( 'Limón', 'stripe' ),
		'CR-P'  => __( 'Puntarenas', 'stripe' ),
		'CR-SJ' => __( 'San José', 'stripe' ),
	),
	'CZ' => array(),
	'DE' => array( // German states.
		'DE-BW' => __( 'Baden-Württemberg', 'stripe' ),
		'DE-BY' => __( 'Bavaria', 'stripe' ),
		'DE-BE' => __( 'Berlin', 'stripe' ),
		'DE-BB' => __( 'Brandenburg', 'stripe' ),
		'DE-HB' => __( 'Bremen', 'stripe' ),
		'DE-HH' => __( 'Hamburg', 'stripe' ),
		'DE-HE' => __( 'Hesse', 'stripe' ),
		'DE-MV' => __( 'Mecklenburg-Vorpommern', 'stripe' ),
		'DE-NI' => __( 'Lower Saxony', 'stripe' ),
		'DE-NW' => __( 'North Rhine-Westphalia', 'stripe' ),
		'DE-RP' => __( 'Rhineland-Palatinate', 'stripe' ),
		'DE-SL' => __( 'Saarland', 'stripe' ),
		'DE-SN' => __( 'Saxony', 'stripe' ),
		'DE-ST' => __( 'Saxony-Anhalt', 'stripe' ),
		'DE-SH' => __( 'Schleswig-Holstein', 'stripe' ),
		'DE-TH' => __( 'Thuringia', 'stripe' ),
	),
	'DK' => array(),
	'DO' => array( // Dominican states.
		'DO-01' => __( 'Distrito Nacional', 'stripe' ),
		'DO-02' => __( 'Azua', 'stripe' ),
		'DO-03' => __( 'Baoruco', 'stripe' ),
		'DO-04' => __( 'Barahona', 'stripe' ),
		'DO-33' => __( 'Cibao Nordeste', 'stripe' ),
		'DO-34' => __( 'Cibao Noroeste', 'stripe' ),
		'DO-35' => __( 'Cibao Norte', 'stripe' ),
		'DO-36' => __( 'Cibao Sur', 'stripe' ),
		'DO-05' => __( 'Dajabón', 'stripe' ),
		'DO-06' => __( 'Duarte', 'stripe' ),
		'DO-08' => __( 'El Seibo', 'stripe' ),
		'DO-37' => __( 'El Valle', 'stripe' ),
		'DO-07' => __( 'Elías Piña', 'stripe' ),
		'DO-38' => __( 'Enriquillo', 'stripe' ),
		'DO-09' => __( 'Espaillat', 'stripe' ),
		'DO-30' => __( 'Hato Mayor', 'stripe' ),
		'DO-19' => __( 'Hermanas Mirabal', 'stripe' ),
		'DO-39' => __( 'Higüamo', 'stripe' ),
		'DO-10' => __( 'Independencia', 'stripe' ),
		'DO-11' => __( 'La Altagracia', 'stripe' ),
		'DO-12' => __( 'La Romana', 'stripe' ),
		'DO-13' => __( 'La Vega', 'stripe' ),
		'DO-14' => __( 'María Trinidad Sánchez', 'stripe' ),
		'DO-28' => __( 'Monseñor Nouel', 'stripe' ),
		'DO-15' => __( 'Monte Cristi', 'stripe' ),
		'DO-29' => __( 'Monte Plata', 'stripe' ),
		'DO-40' => __( 'Ozama', 'stripe' ),
		'DO-16' => __( 'Pedernales', 'stripe' ),
		'DO-17' => __( 'Peravia', 'stripe' ),
		'DO-18' => __( 'Puerto Plata', 'stripe' ),
		'DO-20' => __( 'Samaná', 'stripe' ),
		'DO-21' => __( 'San Cristóbal', 'stripe' ),
		'DO-31' => __( 'San José de Ocoa', 'stripe' ),
		'DO-22' => __( 'San Juan', 'stripe' ),
		'DO-23' => __( 'San Pedro de Macorís', 'stripe' ),
		'DO-24' => __( 'Sánchez Ramírez', 'stripe' ),
		'DO-25' => __( 'Santiago', 'stripe' ),
		'DO-26' => __( 'Santiago Rodríguez', 'stripe' ),
		'DO-32' => __( 'Santo Domingo', 'stripe' ),
		'DO-41' => __( 'Valdesia', 'stripe' ),
		'DO-27' => __( 'Valverde', 'stripe' ),
		'DO-42' => __( 'Yuma', 'stripe' ),
	),
	'DZ' => array( // Algerian states.
		'DZ-01' => __( 'Adrar', 'stripe' ),
		'DZ-02' => __( 'Chlef', 'stripe' ),
		'DZ-03' => __( 'Laghouat', 'stripe' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'stripe' ),
		'DZ-05' => __( 'Batna', 'stripe' ),
		'DZ-06' => __( 'Béjaïa', 'stripe' ),
		'DZ-07' => __( 'Biskra', 'stripe' ),
		'DZ-08' => __( 'Béchar', 'stripe' ),
		'DZ-09' => __( 'Blida', 'stripe' ),
		'DZ-10' => __( 'Bouira', 'stripe' ),
		'DZ-11' => __( 'Tamanghasset', 'stripe' ),
		'DZ-12' => __( 'Tébessa', 'stripe' ),
		'DZ-13' => __( 'Tlemcen', 'stripe' ),
		'DZ-14' => __( 'Tiaret', 'stripe' ),
		'DZ-15' => __( 'Tizi Ouzou', 'stripe' ),
		'DZ-16' => __( 'Algiers', 'stripe' ),
		'DZ-17' => __( 'Djelfa', 'stripe' ),
		'DZ-18' => __( 'Jijel', 'stripe' ),
		'DZ-19' => __( 'Sétif', 'stripe' ),
		'DZ-20' => __( 'Saïda', 'stripe' ),
		'DZ-21' => __( 'Skikda', 'stripe' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'stripe' ),
		'DZ-23' => __( 'Annaba', 'stripe' ),
		'DZ-24' => __( 'Guelma', 'stripe' ),
		'DZ-25' => __( 'Constantine', 'stripe' ),
		'DZ-26' => __( 'Médéa', 'stripe' ),
		'DZ-27' => __( 'Mostaganem', 'stripe' ),
		'DZ-28' => __( 'M’Sila', 'stripe' ),
		'DZ-29' => __( 'Mascara', 'stripe' ),
		'DZ-30' => __( 'Ouargla', 'stripe' ),
		'DZ-31' => __( 'Oran', 'stripe' ),
		'DZ-32' => __( 'El Bayadh', 'stripe' ),
		'DZ-33' => __( 'Illizi', 'stripe' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'stripe' ),
		'DZ-35' => __( 'Boumerdès', 'stripe' ),
		'DZ-36' => __( 'El Tarf', 'stripe' ),
		'DZ-37' => __( 'Tindouf', 'stripe' ),
		'DZ-38' => __( 'Tissemsilt', 'stripe' ),
		'DZ-39' => __( 'El Oued', 'stripe' ),
		'DZ-40' => __( 'Khenchela', 'stripe' ),
		'DZ-41' => __( 'Souk Ahras', 'stripe' ),
		'DZ-42' => __( 'Tipasa', 'stripe' ),
		'DZ-43' => __( 'Mila', 'stripe' ),
		'DZ-44' => __( 'Aïn Defla', 'stripe' ),
		'DZ-45' => __( 'Naama', 'stripe' ),
		'DZ-46' => __( 'Aïn Témouchent', 'stripe' ),
		'DZ-47' => __( 'Ghardaïa', 'stripe' ),
		'DZ-48' => __( 'Relizane', 'stripe' ),
	),
	'EE' => array(),
	'EC' => array( // Ecuadorian states.
		'EC-A'  => __( 'Azuay', 'stripe' ),
		'EC-B'  => __( 'Bolívar', 'stripe' ),
		'EC-F'  => __( 'Cañar', 'stripe' ),
		'EC-C'  => __( 'Carchi', 'stripe' ),
		'EC-H'  => __( 'Chimborazo', 'stripe' ),
		'EC-X'  => __( 'Cotopaxi', 'stripe' ),
		'EC-O'  => __( 'El Oro', 'stripe' ),
		'EC-E'  => __( 'Esmeraldas', 'stripe' ),
		'EC-W'  => __( 'Galápagos', 'stripe' ),
		'EC-G'  => __( 'Guayas', 'stripe' ),
		'EC-I'  => __( 'Imbabura', 'stripe' ),
		'EC-L'  => __( 'Loja', 'stripe' ),
		'EC-R'  => __( 'Los Ríos', 'stripe' ),
		'EC-M'  => __( 'Manabí', 'stripe' ),
		'EC-S'  => __( 'Morona-Santiago', 'stripe' ),
		'EC-N'  => __( 'Napo', 'stripe' ),
		'EC-D'  => __( 'Orellana', 'stripe' ),
		'EC-Y'  => __( 'Pastaza', 'stripe' ),
		'EC-P'  => __( 'Pichincha', 'stripe' ),
		'EC-SE' => __( 'Santa Elena', 'stripe' ),
		'EC-SD' => __( 'Santo Domingo de los Tsáchilas', 'stripe' ),
		'EC-U'  => __( 'Sucumbíos', 'stripe' ),
		'EC-T'  => __( 'Tungurahua', 'stripe' ),
		'EC-Z'  => __( 'Zamora-Chinchipe', 'stripe' ),
	),
	'EG' => array( // Egyptian states.
		'EGALX' => __( 'Alexandria', 'stripe' ),
		'EGASN' => __( 'Aswan', 'stripe' ),
		'EGAST' => __( 'Asyut', 'stripe' ),
		'EGBA'  => __( 'Red Sea', 'stripe' ),
		'EGBH'  => __( 'Beheira', 'stripe' ),
		'EGBNS' => __( 'Beni Suef', 'stripe' ),
		'EGC'   => __( 'Cairo', 'stripe' ),
		'EGDK'  => __( 'Dakahlia', 'stripe' ),
		'EGDT'  => __( 'Damietta', 'stripe' ),
		'EGFYM' => __( 'Faiyum', 'stripe' ),
		'EGGH'  => __( 'Gharbia', 'stripe' ),
		'EGGZ'  => __( 'Giza', 'stripe' ),
		'EGIS'  => __( 'Ismailia', 'stripe' ),
		'EGJS'  => __( 'South Sinai', 'stripe' ),
		'EGKB'  => __( 'Qalyubia', 'stripe' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'stripe' ),
		'EGKN'  => __( 'Qena', 'stripe' ),
		'EGLX'  => __( 'Luxor', 'stripe' ),
		'EGMN'  => __( 'Minya', 'stripe' ),
		'EGMNF' => __( 'Monufia', 'stripe' ),
		'EGMT'  => __( 'Matrouh', 'stripe' ),
		'EGPTS' => __( 'Port Said', 'stripe' ),
		'EGSHG' => __( 'Sohag', 'stripe' ),
		'EGSHR' => __( 'Al Sharqia', 'stripe' ),
		'EGSIN' => __( 'North Sinai', 'stripe' ),
		'EGSUZ' => __( 'Suez', 'stripe' ),
		'EGWAD' => __( 'New Valley', 'stripe' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'stripe' ),
		'VI' => __( 'Araba/Álava', 'stripe' ),
		'AB' => __( 'Albacete', 'stripe' ),
		'A'  => __( 'Alicante', 'stripe' ),
		'AL' => __( 'Almería', 'stripe' ),
		'O'  => __( 'Asturias', 'stripe' ),
		'AV' => __( 'Ávila', 'stripe' ),
		'BA' => __( 'Badajoz', 'stripe' ),
		'PM' => __( 'Baleares', 'stripe' ),
		'B'  => __( 'Barcelona', 'stripe' ),
		'BU' => __( 'Burgos', 'stripe' ),
		'CC' => __( 'Cáceres', 'stripe' ),
		'CA' => __( 'Cádiz', 'stripe' ),
		'S'  => __( 'Cantabria', 'stripe' ),
		'CS' => __( 'Castellón', 'stripe' ),
		'CE' => __( 'Ceuta', 'stripe' ),
		'CR' => __( 'Ciudad Real', 'stripe' ),
		'CO' => __( 'Córdoba', 'stripe' ),
		'CU' => __( 'Cuenca', 'stripe' ),
		'GI' => __( 'Girona', 'stripe' ),
		'GR' => __( 'Granada', 'stripe' ),
		'GU' => __( 'Guadalajara', 'stripe' ),
		'SS' => __( 'Gipuzkoa', 'stripe' ),
		'H'  => __( 'Huelva', 'stripe' ),
		'HU' => __( 'Huesca', 'stripe' ),
		'J'  => __( 'Jaén', 'stripe' ),
		'LO' => __( 'La Rioja', 'stripe' ),
		'GC' => __( 'Las Palmas', 'stripe' ),
		'LE' => __( 'León', 'stripe' ),
		'L'  => __( 'Lleida', 'stripe' ),
		'LU' => __( 'Lugo', 'stripe' ),
		'M'  => __( 'Madrid', 'stripe' ),
		'MA' => __( 'Málaga', 'stripe' ),
		'ML' => __( 'Melilla', 'stripe' ),
		'MU' => __( 'Murcia', 'stripe' ),
		'NA' => __( 'Navarra', 'stripe' ),
		'OR' => __( 'Ourense', 'stripe' ),
		'P'  => __( 'Palencia', 'stripe' ),
		'PO' => __( 'Pontevedra', 'stripe' ),
		'SA' => __( 'Salamanca', 'stripe' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'stripe' ),
		'SG' => __( 'Segovia', 'stripe' ),
		'SE' => __( 'Sevilla', 'stripe' ),
		'SO' => __( 'Soria', 'stripe' ),
		'T'  => __( 'Tarragona', 'stripe' ),
		'TE' => __( 'Teruel', 'stripe' ),
		'TO' => __( 'Toledo', 'stripe' ),
		'V'  => __( 'Valencia', 'stripe' ),
		'VA' => __( 'Valladolid', 'stripe' ),
		'BI' => __( 'Biscay', 'stripe' ),
		'ZA' => __( 'Zamora', 'stripe' ),
		'Z'  => __( 'Zaragoza', 'stripe' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GF' => array(),
	'GH' => array( // Ghanaian regions.
		'AF' => __( 'Ahafo', 'stripe' ),
		'AH' => __( 'Ashanti', 'stripe' ),
		'BA' => __( 'Brong-Ahafo', 'stripe' ),
		'BO' => __( 'Bono', 'stripe' ),
		'BE' => __( 'Bono East', 'stripe' ),
		'CP' => __( 'Central', 'stripe' ),
		'EP' => __( 'Eastern', 'stripe' ),
		'AA' => __( 'Greater Accra', 'stripe' ),
		'NE' => __( 'North East', 'stripe' ),
		'NP' => __( 'Northern', 'stripe' ),
		'OT' => __( 'Oti', 'stripe' ),
		'SV' => __( 'Savannah', 'stripe' ),
		'UE' => __( 'Upper East', 'stripe' ),
		'UW' => __( 'Upper West', 'stripe' ),
		'TV' => __( 'Volta', 'stripe' ),
		'WP' => __( 'Western', 'stripe' ),
		'WN' => __( 'Western North', 'stripe' ),
	),
	'GP' => array(),
	'GR' => array( // Greek regions.
		'I' => __( 'Attica', 'stripe' ),
		'A' => __( 'East Macedonia and Thrace', 'stripe' ),
		'B' => __( 'Central Macedonia', 'stripe' ),
		'C' => __( 'West Macedonia', 'stripe' ),
		'D' => __( 'Epirus', 'stripe' ),
		'E' => __( 'Thessaly', 'stripe' ),
		'F' => __( 'Ionian Islands', 'stripe' ),
		'G' => __( 'West Greece', 'stripe' ),
		'H' => __( 'Central Greece', 'stripe' ),
		'J' => __( 'Peloponnese', 'stripe' ),
		'K' => __( 'North Aegean', 'stripe' ),
		'L' => __( 'South Aegean', 'stripe' ),
		'M' => __( 'Crete', 'stripe' ),
	),
	'GT' => array( // Guatemalan states.
		'GT-AV' => __( 'Alta Verapaz', 'stripe' ),
		'GT-BV' => __( 'Baja Verapaz', 'stripe' ),
		'GT-CM' => __( 'Chimaltenango', 'stripe' ),
		'GT-CQ' => __( 'Chiquimula', 'stripe' ),
		'GT-PR' => __( 'El Progreso', 'stripe' ),
		'GT-ES' => __( 'Escuintla', 'stripe' ),
		'GT-GU' => __( 'Guatemala', 'stripe' ),
		'GT-HU' => __( 'Huehuetenango', 'stripe' ),
		'GT-IZ' => __( 'Izabal', 'stripe' ),
		'GT-JA' => __( 'Jalapa', 'stripe' ),
		'GT-JU' => __( 'Jutiapa', 'stripe' ),
		'GT-PE' => __( 'Petén', 'stripe' ),
		'GT-QZ' => __( 'Quetzaltenango', 'stripe' ),
		'GT-QC' => __( 'Quiché', 'stripe' ),
		'GT-RE' => __( 'Retalhuleu', 'stripe' ),
		'GT-SA' => __( 'Sacatepéquez', 'stripe' ),
		'GT-SM' => __( 'San Marcos', 'stripe' ),
		'GT-SR' => __( 'Santa Rosa', 'stripe' ),
		'GT-SO' => __( 'Sololá', 'stripe' ),
		'GT-SU' => __( 'Suchitepéquez', 'stripe' ),
		'GT-TO' => __( 'Totonicapán', 'stripe' ),
		'GT-ZA' => __( 'Zacapa', 'stripe' ),
	),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'stripe' ),
		'KOWLOON'         => __( 'Kowloon', 'stripe' ),
		'NEW TERRITORIES' => __( 'New Territories', 'stripe' ),
	),
	'HN' => array( // Honduran states.
		'HN-AT' => __( 'Atlántida', 'stripe' ),
		'HN-IB' => __( 'Bay Islands', 'stripe' ),
		'HN-CH' => __( 'Choluteca', 'stripe' ),
		'HN-CL' => __( 'Colón', 'stripe' ),
		'HN-CM' => __( 'Comayagua', 'stripe' ),
		'HN-CP' => __( 'Copán', 'stripe' ),
		'HN-CR' => __( 'Cortés', 'stripe' ),
		'HN-EP' => __( 'El Paraíso', 'stripe' ),
		'HN-FM' => __( 'Francisco Morazán', 'stripe' ),
		'HN-GD' => __( 'Gracias a Dios', 'stripe' ),
		'HN-IN' => __( 'Intibucá', 'stripe' ),
		'HN-LE' => __( 'Lempira', 'stripe' ),
		'HN-LP' => __( 'La Paz', 'stripe' ),
		'HN-OC' => __( 'Ocotepeque', 'stripe' ),
		'HN-OL' => __( 'Olancho', 'stripe' ),
		'HN-SB' => __( 'Santa Bárbara', 'stripe' ),
		'HN-VA' => __( 'Valle', 'stripe' ),
		'HN-YO' => __( 'Yoro', 'stripe' ),
	),
	'HU' => array( // Hungarian states.
		'BK' => __( 'Bács-Kiskun', 'stripe' ),
		'BE' => __( 'Békés', 'stripe' ),
		'BA' => __( 'Baranya', 'stripe' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'stripe' ),
		'BU' => __( 'Budapest', 'stripe' ),
		'CS' => __( 'Csongrád-Csanád', 'stripe' ),
		'FE' => __( 'Fejér', 'stripe' ),
		'GS' => __( 'Győr-Moson-Sopron', 'stripe' ),
		'HB' => __( 'Hajdú-Bihar', 'stripe' ),
		'HE' => __( 'Heves', 'stripe' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'stripe' ),
		'KE' => __( 'Komárom-Esztergom', 'stripe' ),
		'NO' => __( 'Nógrád', 'stripe' ),
		'PE' => __( 'Pest', 'stripe' ),
		'SO' => __( 'Somogy', 'stripe' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'stripe' ),
		'TO' => __( 'Tolna', 'stripe' ),
		'VA' => __( 'Vas', 'stripe' ),
		'VE' => __( 'Veszprém', 'stripe' ),
		'ZA' => __( 'Zala', 'stripe' ),
	),
	'ID' => array( // Indonesian provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'stripe' ),
		'SU' => __( 'Sumatera Utara', 'stripe' ),
		'SB' => __( 'Sumatera Barat', 'stripe' ),
		'RI' => __( 'Riau', 'stripe' ),
		'KR' => __( 'Kepulauan Riau', 'stripe' ),
		'JA' => __( 'Jambi', 'stripe' ),
		'SS' => __( 'Sumatera Selatan', 'stripe' ),
		'BB' => __( 'Bangka Belitung', 'stripe' ),
		'BE' => __( 'Bengkulu', 'stripe' ),
		'LA' => __( 'Lampung', 'stripe' ),
		'JK' => __( 'DKI Jakarta', 'stripe' ),
		'JB' => __( 'Jawa Barat', 'stripe' ),
		'BT' => __( 'Banten', 'stripe' ),
		'JT' => __( 'Jawa Tengah', 'stripe' ),
		'JI' => __( 'Jawa Timur', 'stripe' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'stripe' ),
		'BA' => __( 'Bali', 'stripe' ),
		'NB' => __( 'Nusa Tenggara Barat', 'stripe' ),
		'NT' => __( 'Nusa Tenggara Timur', 'stripe' ),
		'KB' => __( 'Kalimantan Barat', 'stripe' ),
		'KT' => __( 'Kalimantan Tengah', 'stripe' ),
		'KI' => __( 'Kalimantan Timur', 'stripe' ),
		'KS' => __( 'Kalimantan Selatan', 'stripe' ),
		'KU' => __( 'Kalimantan Utara', 'stripe' ),
		'SA' => __( 'Sulawesi Utara', 'stripe' ),
		'ST' => __( 'Sulawesi Tengah', 'stripe' ),
		'SG' => __( 'Sulawesi Tenggara', 'stripe' ),
		'SR' => __( 'Sulawesi Barat', 'stripe' ),
		'SN' => __( 'Sulawesi Selatan', 'stripe' ),
		'GO' => __( 'Gorontalo', 'stripe' ),
		'MA' => __( 'Maluku', 'stripe' ),
		'MU' => __( 'Maluku Utara', 'stripe' ),
		'PA' => __( 'Papua', 'stripe' ),
		'PB' => __( 'Papua Barat', 'stripe' ),
	),
	'IE' => array( // Irish states.
		'CW' => __( 'Carlow', 'stripe' ),
		'CN' => __( 'Cavan', 'stripe' ),
		'CE' => __( 'Clare', 'stripe' ),
		'CO' => __( 'Cork', 'stripe' ),
		'DL' => __( 'Donegal', 'stripe' ),
		'D'  => __( 'Dublin', 'stripe' ),
		'G'  => __( 'Galway', 'stripe' ),
		'KY' => __( 'Kerry', 'stripe' ),
		'KE' => __( 'Kildare', 'stripe' ),
		'KK' => __( 'Kilkenny', 'stripe' ),
		'LS' => __( 'Laois', 'stripe' ),
		'LM' => __( 'Leitrim', 'stripe' ),
		'LK' => __( 'Limerick', 'stripe' ),
		'LD' => __( 'Longford', 'stripe' ),
		'LH' => __( 'Louth', 'stripe' ),
		'MO' => __( 'Mayo', 'stripe' ),
		'MH' => __( 'Meath', 'stripe' ),
		'MN' => __( 'Monaghan', 'stripe' ),
		'OY' => __( 'Offaly', 'stripe' ),
		'RN' => __( 'Roscommon', 'stripe' ),
		'SO' => __( 'Sligo', 'stripe' ),
		'TA' => __( 'Tipperary', 'stripe' ),
		'WD' => __( 'Waterford', 'stripe' ),
		'WH' => __( 'Westmeath', 'stripe' ),
		'WX' => __( 'Wexford', 'stripe' ),
		'WW' => __( 'Wicklow', 'stripe' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'stripe' ),
		'AR' => __( 'Arunachal Pradesh', 'stripe' ),
		'AS' => __( 'Assam', 'stripe' ),
		'BR' => __( 'Bihar', 'stripe' ),
		'CT' => __( 'Chhattisgarh', 'stripe' ),
		'GA' => __( 'Goa', 'stripe' ),
		'GJ' => __( 'Gujarat', 'stripe' ),
		'HR' => __( 'Haryana', 'stripe' ),
		'HP' => __( 'Himachal Pradesh', 'stripe' ),
		'JK' => __( 'Jammu and Kashmir', 'stripe' ),
		'JH' => __( 'Jharkhand', 'stripe' ),
		'KA' => __( 'Karnataka', 'stripe' ),
		'KL' => __( 'Kerala', 'stripe' ),
		'LA' => __( 'Ladakh', 'stripe' ),
		'MP' => __( 'Madhya Pradesh', 'stripe' ),
		'MH' => __( 'Maharashtra', 'stripe' ),
		'MN' => __( 'Manipur', 'stripe' ),
		'ML' => __( 'Meghalaya', 'stripe' ),
		'MZ' => __( 'Mizoram', 'stripe' ),
		'NL' => __( 'Nagaland', 'stripe' ),
		'OR' => __( 'Odisha', 'stripe' ),
		'PB' => __( 'Punjab', 'stripe' ),
		'RJ' => __( 'Rajasthan', 'stripe' ),
		'SK' => __( 'Sikkim', 'stripe' ),
		'TN' => __( 'Tamil Nadu', 'stripe' ),
		'TS' => __( 'Telangana', 'stripe' ),
		'TR' => __( 'Tripura', 'stripe' ),
		'UK' => __( 'Uttarakhand', 'stripe' ),
		'UP' => __( 'Uttar Pradesh', 'stripe' ),
		'WB' => __( 'West Bengal', 'stripe' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'stripe' ),
		'CH' => __( 'Chandigarh', 'stripe' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'stripe' ),
		'DD' => __( 'Daman and Diu', 'stripe' ),
		'DL' => __( 'Delhi', 'stripe' ),
		'LD' => __( 'Lakshadeep', 'stripe' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'stripe' ),
	),
	'IR' => array( // Irania states.
		'KHZ' => __( 'Khuzestan (خوزستان)', 'stripe' ),
		'THR' => __( 'Tehran (تهران)', 'stripe' ),
		'ILM' => __( 'Ilaam (ایلام)', 'stripe' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'stripe' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'stripe' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'stripe' ),
		'YZD' => __( 'Yazd (یزد)', 'stripe' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'stripe' ),
		'KRN' => __( 'Kerman (کرمان)', 'stripe' ),
		'HDN' => __( 'Hamadan (همدان)', 'stripe' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'stripe' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'stripe' ),
		'LRS' => __( 'Luristan (لرستان)', 'stripe' ),
		'ABZ' => __( 'Alborz (البرز)', 'stripe' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'stripe' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'stripe' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'stripe' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'stripe' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'stripe' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'stripe' ),
		'SMN' => __( 'Semnan (سمنان)', 'stripe' ),
		'FRS' => __( 'Fars (فارس)', 'stripe' ),
		'QHM' => __( 'Qom (قم)', 'stripe' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'stripe' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'stripe' ),
		'GLS' => __( 'Golestan (گلستان)', 'stripe' ),
		'GIL' => __( 'Gilan (گیلان)', 'stripe' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'stripe' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'stripe' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'stripe' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'stripe' ),
	),
	'IS' => array(),
	'IT' => array( // Italian provinces.
		'AG' => __( 'Agrigento', 'stripe' ),
		'AL' => __( 'Alessandria', 'stripe' ),
		'AN' => __( 'Ancona', 'stripe' ),
		'AO' => __( 'Aosta', 'stripe' ),
		'AR' => __( 'Arezzo', 'stripe' ),
		'AP' => __( 'Ascoli Piceno', 'stripe' ),
		'AT' => __( 'Asti', 'stripe' ),
		'AV' => __( 'Avellino', 'stripe' ),
		'BA' => __( 'Bari', 'stripe' ),
		'BT' => __( 'Barletta-Andria-Trani', 'stripe' ),
		'BL' => __( 'Belluno', 'stripe' ),
		'BN' => __( 'Benevento', 'stripe' ),
		'BG' => __( 'Bergamo', 'stripe' ),
		'BI' => __( 'Biella', 'stripe' ),
		'BO' => __( 'Bologna', 'stripe' ),
		'BZ' => __( 'Bolzano', 'stripe' ),
		'BS' => __( 'Brescia', 'stripe' ),
		'BR' => __( 'Brindisi', 'stripe' ),
		'CA' => __( 'Cagliari', 'stripe' ),
		'CL' => __( 'Caltanissetta', 'stripe' ),
		'CB' => __( 'Campobasso', 'stripe' ),
		'CE' => __( 'Caserta', 'stripe' ),
		'CT' => __( 'Catania', 'stripe' ),
		'CZ' => __( 'Catanzaro', 'stripe' ),
		'CH' => __( 'Chieti', 'stripe' ),
		'CO' => __( 'Como', 'stripe' ),
		'CS' => __( 'Cosenza', 'stripe' ),
		'CR' => __( 'Cremona', 'stripe' ),
		'KR' => __( 'Crotone', 'stripe' ),
		'CN' => __( 'Cuneo', 'stripe' ),
		'EN' => __( 'Enna', 'stripe' ),
		'FM' => __( 'Fermo', 'stripe' ),
		'FE' => __( 'Ferrara', 'stripe' ),
		'FI' => __( 'Firenze', 'stripe' ),
		'FG' => __( 'Foggia', 'stripe' ),
		'FC' => __( 'Forlì-Cesena', 'stripe' ),
		'FR' => __( 'Frosinone', 'stripe' ),
		'GE' => __( 'Genova', 'stripe' ),
		'GO' => __( 'Gorizia', 'stripe' ),
		'GR' => __( 'Grosseto', 'stripe' ),
		'IM' => __( 'Imperia', 'stripe' ),
		'IS' => __( 'Isernia', 'stripe' ),
		'SP' => __( 'La Spezia', 'stripe' ),
		'AQ' => __( "L'Aquila", 'stripe' ),
		'LT' => __( 'Latina', 'stripe' ),
		'LE' => __( 'Lecce', 'stripe' ),
		'LC' => __( 'Lecco', 'stripe' ),
		'LI' => __( 'Livorno', 'stripe' ),
		'LO' => __( 'Lodi', 'stripe' ),
		'LU' => __( 'Lucca', 'stripe' ),
		'MC' => __( 'Macerata', 'stripe' ),
		'MN' => __( 'Mantova', 'stripe' ),
		'MS' => __( 'Massa-Carrara', 'stripe' ),
		'MT' => __( 'Matera', 'stripe' ),
		'ME' => __( 'Messina', 'stripe' ),
		'MI' => __( 'Milano', 'stripe' ),
		'MO' => __( 'Modena', 'stripe' ),
		'MB' => __( 'Monza e della Brianza', 'stripe' ),
		'NA' => __( 'Napoli', 'stripe' ),
		'NO' => __( 'Novara', 'stripe' ),
		'NU' => __( 'Nuoro', 'stripe' ),
		'OR' => __( 'Oristano', 'stripe' ),
		'PD' => __( 'Padova', 'stripe' ),
		'PA' => __( 'Palermo', 'stripe' ),
		'PR' => __( 'Parma', 'stripe' ),
		'PV' => __( 'Pavia', 'stripe' ),
		'PG' => __( 'Perugia', 'stripe' ),
		'PU' => __( 'Pesaro e Urbino', 'stripe' ),
		'PE' => __( 'Pescara', 'stripe' ),
		'PC' => __( 'Piacenza', 'stripe' ),
		'PI' => __( 'Pisa', 'stripe' ),
		'PT' => __( 'Pistoia', 'stripe' ),
		'PN' => __( 'Pordenone', 'stripe' ),
		'PZ' => __( 'Potenza', 'stripe' ),
		'PO' => __( 'Prato', 'stripe' ),
		'RG' => __( 'Ragusa', 'stripe' ),
		'RA' => __( 'Ravenna', 'stripe' ),
		'RC' => __( 'Reggio Calabria', 'stripe' ),
		'RE' => __( 'Reggio Emilia', 'stripe' ),
		'RI' => __( 'Rieti', 'stripe' ),
		'RN' => __( 'Rimini', 'stripe' ),
		'RM' => __( 'Roma', 'stripe' ),
		'RO' => __( 'Rovigo', 'stripe' ),
		'SA' => __( 'Salerno', 'stripe' ),
		'SS' => __( 'Sassari', 'stripe' ),
		'SV' => __( 'Savona', 'stripe' ),
		'SI' => __( 'Siena', 'stripe' ),
		'SR' => __( 'Siracusa', 'stripe' ),
		'SO' => __( 'Sondrio', 'stripe' ),
		'SU' => __( 'Sud Sardegna', 'stripe' ),
		'TA' => __( 'Taranto', 'stripe' ),
		'TE' => __( 'Teramo', 'stripe' ),
		'TR' => __( 'Terni', 'stripe' ),
		'TO' => __( 'Torino', 'stripe' ),
		'TP' => __( 'Trapani', 'stripe' ),
		'TN' => __( 'Trento', 'stripe' ),
		'TV' => __( 'Treviso', 'stripe' ),
		'TS' => __( 'Trieste', 'stripe' ),
		'UD' => __( 'Udine', 'stripe' ),
		'VA' => __( 'Varese', 'stripe' ),
		'VE' => __( 'Venezia', 'stripe' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'stripe' ),
		'VC' => __( 'Vercelli', 'stripe' ),
		'VR' => __( 'Verona', 'stripe' ),
		'VV' => __( 'Vibo Valentia', 'stripe' ),
		'VI' => __( 'Vicenza', 'stripe' ),
		'VT' => __( 'Viterbo', 'stripe' ),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaican parishes.
		'JM-01' => __( 'Kingston', 'stripe' ),
		'JM-02' => __( 'Saint Andrew', 'stripe' ),
		'JM-03' => __( 'Saint Thomas', 'stripe' ),
		'JM-04' => __( 'Portland', 'stripe' ),
		'JM-05' => __( 'Saint Mary', 'stripe' ),
		'JM-06' => __( 'Saint Ann', 'stripe' ),
		'JM-07' => __( 'Trelawny', 'stripe' ),
		'JM-08' => __( 'Saint James', 'stripe' ),
		'JM-09' => __( 'Hanover', 'stripe' ),
		'JM-10' => __( 'Westmoreland', 'stripe' ),
		'JM-11' => __( 'Saint Elizabeth', 'stripe' ),
		'JM-12' => __( 'Manchester', 'stripe' ),
		'JM-13' => __( 'Clarendon', 'stripe' ),
		'JM-14' => __( 'Saint Catherine', 'stripe' ),
	),

	/**
	 * Japanese states.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'stripe' ),
		'JP02' => __( 'Aomori', 'stripe' ),
		'JP03' => __( 'Iwate', 'stripe' ),
		'JP04' => __( 'Miyagi', 'stripe' ),
		'JP05' => __( 'Akita', 'stripe' ),
		'JP06' => __( 'Yamagata', 'stripe' ),
		'JP07' => __( 'Fukushima', 'stripe' ),
		'JP08' => __( 'Ibaraki', 'stripe' ),
		'JP09' => __( 'Tochigi', 'stripe' ),
		'JP10' => __( 'Gunma', 'stripe' ),
		'JP11' => __( 'Saitama', 'stripe' ),
		'JP12' => __( 'Chiba', 'stripe' ),
		'JP13' => __( 'Tokyo', 'stripe' ),
		'JP14' => __( 'Kanagawa', 'stripe' ),
		'JP15' => __( 'Niigata', 'stripe' ),
		'JP16' => __( 'Toyama', 'stripe' ),
		'JP17' => __( 'Ishikawa', 'stripe' ),
		'JP18' => __( 'Fukui', 'stripe' ),
		'JP19' => __( 'Yamanashi', 'stripe' ),
		'JP20' => __( 'Nagano', 'stripe' ),
		'JP21' => __( 'Gifu', 'stripe' ),
		'JP22' => __( 'Shizuoka', 'stripe' ),
		'JP23' => __( 'Aichi', 'stripe' ),
		'JP24' => __( 'Mie', 'stripe' ),
		'JP25' => __( 'Shiga', 'stripe' ),
		'JP26' => __( 'Kyoto', 'stripe' ),
		'JP27' => __( 'Osaka', 'stripe' ),
		'JP28' => __( 'Hyogo', 'stripe' ),
		'JP29' => __( 'Nara', 'stripe' ),
		'JP30' => __( 'Wakayama', 'stripe' ),
		'JP31' => __( 'Tottori', 'stripe' ),
		'JP32' => __( 'Shimane', 'stripe' ),
		'JP33' => __( 'Okayama', 'stripe' ),
		'JP34' => __( 'Hiroshima', 'stripe' ),
		'JP35' => __( 'Yamaguchi', 'stripe' ),
		'JP36' => __( 'Tokushima', 'stripe' ),
		'JP37' => __( 'Kagawa', 'stripe' ),
		'JP38' => __( 'Ehime', 'stripe' ),
		'JP39' => __( 'Kochi', 'stripe' ),
		'JP40' => __( 'Fukuoka', 'stripe' ),
		'JP41' => __( 'Saga', 'stripe' ),
		'JP42' => __( 'Nagasaki', 'stripe' ),
		'JP43' => __( 'Kumamoto', 'stripe' ),
		'JP44' => __( 'Oita', 'stripe' ),
		'JP45' => __( 'Miyazaki', 'stripe' ),
		'JP46' => __( 'Kagoshima', 'stripe' ),
		'JP47' => __( 'Okinawa', 'stripe' ),
	),
	'KE' => array( // Kenyan counties.
		'KE01' => __( 'Baringo', 'stripe' ),
		'KE02' => __( 'Bomet', 'stripe' ),
		'KE03' => __( 'Bungoma', 'stripe' ),
		'KE04' => __( 'Busia', 'stripe' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'stripe' ),
		'KE06' => __( 'Embu', 'stripe' ),
		'KE07' => __( 'Garissa', 'stripe' ),
		'KE08' => __( 'Homa Bay', 'stripe' ),
		'KE09' => __( 'Isiolo', 'stripe' ),
		'KE10' => __( 'Kajiado', 'stripe' ),
		'KE11' => __( 'Kakamega', 'stripe' ),
		'KE12' => __( 'Kericho', 'stripe' ),
		'KE13' => __( 'Kiambu', 'stripe' ),
		'KE14' => __( 'Kilifi', 'stripe' ),
		'KE15' => __( 'Kirinyaga', 'stripe' ),
		'KE16' => __( 'Kisii', 'stripe' ),
		'KE17' => __( 'Kisumu', 'stripe' ),
		'KE18' => __( 'Kitui', 'stripe' ),
		'KE19' => __( 'Kwale', 'stripe' ),
		'KE20' => __( 'Laikipia', 'stripe' ),
		'KE21' => __( 'Lamu', 'stripe' ),
		'KE22' => __( 'Machakos', 'stripe' ),
		'KE23' => __( 'Makueni', 'stripe' ),
		'KE24' => __( 'Mandera', 'stripe' ),
		'KE25' => __( 'Marsabit', 'stripe' ),
		'KE26' => __( 'Meru', 'stripe' ),
		'KE27' => __( 'Migori', 'stripe' ),
		'KE28' => __( 'Mombasa', 'stripe' ),
		'KE29' => __( 'Murang’a', 'stripe' ),
		'KE30' => __( 'Nairobi County', 'stripe' ),
		'KE31' => __( 'Nakuru', 'stripe' ),
		'KE32' => __( 'Nandi', 'stripe' ),
		'KE33' => __( 'Narok', 'stripe' ),
		'KE34' => __( 'Nyamira', 'stripe' ),
		'KE35' => __( 'Nyandarua', 'stripe' ),
		'KE36' => __( 'Nyeri', 'stripe' ),
		'KE37' => __( 'Samburu', 'stripe' ),
		'KE38' => __( 'Siaya', 'stripe' ),
		'KE39' => __( 'Taita-Taveta', 'stripe' ),
		'KE40' => __( 'Tana River', 'stripe' ),
		'KE41' => __( 'Tharaka-Nithi', 'stripe' ),
		'KE42' => __( 'Trans Nzoia', 'stripe' ),
		'KE43' => __( 'Turkana', 'stripe' ),
		'KE44' => __( 'Uasin Gishu', 'stripe' ),
		'KE45' => __( 'Vihiga', 'stripe' ),
		'KE46' => __( 'Wajir', 'stripe' ),
		'KE47' => __( 'West Pokot', 'stripe' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array( // Laotian provinces.
		'AT' => __( 'Attapeu', 'stripe' ),
		'BK' => __( 'Bokeo', 'stripe' ),
		'BL' => __( 'Bolikhamsai', 'stripe' ),
		'CH' => __( 'Champasak', 'stripe' ),
		'HO' => __( 'Houaphanh', 'stripe' ),
		'KH' => __( 'Khammouane', 'stripe' ),
		'LM' => __( 'Luang Namtha', 'stripe' ),
		'LP' => __( 'Luang Prabang', 'stripe' ),
		'OU' => __( 'Oudomxay', 'stripe' ),
		'PH' => __( 'Phongsaly', 'stripe' ),
		'SL' => __( 'Salavan', 'stripe' ),
		'SV' => __( 'Savannakhet', 'stripe' ),
		'VI' => __( 'Vientiane Province', 'stripe' ),
		'VT' => __( 'Vientiane', 'stripe' ),
		'XA' => __( 'Sainyabuli', 'stripe' ),
		'XE' => __( 'Sekong', 'stripe' ),
		'XI' => __( 'Xiangkhouang', 'stripe' ),
		'XS' => __( 'Xaisomboun', 'stripe' ),
	),
	'LB' => array(),
	'LI' => array(),
	'LR' => array( // Liberian provinces.
		'BM' => __( 'Bomi', 'stripe' ),
		'BN' => __( 'Bong', 'stripe' ),
		'GA' => __( 'Gbarpolu', 'stripe' ),
		'GB' => __( 'Grand Bassa', 'stripe' ),
		'GC' => __( 'Grand Cape Mount', 'stripe' ),
		'GG' => __( 'Grand Gedeh', 'stripe' ),
		'GK' => __( 'Grand Kru', 'stripe' ),
		'LO' => __( 'Lofa', 'stripe' ),
		'MA' => __( 'Margibi', 'stripe' ),
		'MY' => __( 'Maryland', 'stripe' ),
		'MO' => __( 'Montserrado', 'stripe' ),
		'NM' => __( 'Nimba', 'stripe' ),
		'RV' => __( 'Rivercess', 'stripe' ),
		'RG' => __( 'River Gee', 'stripe' ),
		'SN' => __( 'Sinoe', 'stripe' ),
	),
	'LU' => array(),
	'MD' => array( // Moldovan states.
		'C'  => __( 'Chișinău', 'stripe' ),
		'BL' => __( 'Bălți', 'stripe' ),
		'AN' => __( 'Anenii Noi', 'stripe' ),
		'BS' => __( 'Basarabeasca', 'stripe' ),
		'BR' => __( 'Briceni', 'stripe' ),
		'CH' => __( 'Cahul', 'stripe' ),
		'CT' => __( 'Cantemir', 'stripe' ),
		'CL' => __( 'Călărași', 'stripe' ),
		'CS' => __( 'Căușeni', 'stripe' ),
		'CM' => __( 'Cimișlia', 'stripe' ),
		'CR' => __( 'Criuleni', 'stripe' ),
		'DN' => __( 'Dondușeni', 'stripe' ),
		'DR' => __( 'Drochia', 'stripe' ),
		'DB' => __( 'Dubăsari', 'stripe' ),
		'ED' => __( 'Edineț', 'stripe' ),
		'FL' => __( 'Fălești', 'stripe' ),
		'FR' => __( 'Florești', 'stripe' ),
		'GE' => __( 'UTA Găgăuzia', 'stripe' ),
		'GL' => __( 'Glodeni', 'stripe' ),
		'HN' => __( 'Hîncești', 'stripe' ),
		'IL' => __( 'Ialoveni', 'stripe' ),
		'LV' => __( 'Leova', 'stripe' ),
		'NS' => __( 'Nisporeni', 'stripe' ),
		'OC' => __( 'Ocnița', 'stripe' ),
		'OR' => __( 'Orhei', 'stripe' ),
		'RZ' => __( 'Rezina', 'stripe' ),
		'RS' => __( 'Rîșcani', 'stripe' ),
		'SG' => __( 'Sîngerei', 'stripe' ),
		'SR' => __( 'Soroca', 'stripe' ),
		'ST' => __( 'Strășeni', 'stripe' ),
		'SD' => __( 'Șoldănești', 'stripe' ),
		'SV' => __( 'Ștefan Vodă', 'stripe' ),
		'TR' => __( 'Taraclia', 'stripe' ),
		'TL' => __( 'Telenești', 'stripe' ),
		'UN' => __( 'Ungheni', 'stripe' ),
	),
	'MF' => array(),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexican states.
		'DF' => __( 'Ciudad de México', 'stripe' ),
		'JA' => __( 'Jalisco', 'stripe' ),
		'NL' => __( 'Nuevo León', 'stripe' ),
		'AG' => __( 'Aguascalientes', 'stripe' ),
		'BC' => __( 'Baja California', 'stripe' ),
		'BS' => __( 'Baja California Sur', 'stripe' ),
		'CM' => __( 'Campeche', 'stripe' ),
		'CS' => __( 'Chiapas', 'stripe' ),
		'CH' => __( 'Chihuahua', 'stripe' ),
		'CO' => __( 'Coahuila', 'stripe' ),
		'CL' => __( 'Colima', 'stripe' ),
		'DG' => __( 'Durango', 'stripe' ),
		'GT' => __( 'Guanajuato', 'stripe' ),
		'GR' => __( 'Guerrero', 'stripe' ),
		'HG' => __( 'Hidalgo', 'stripe' ),
		'MX' => __( 'Estado de México', 'stripe' ),
		'MI' => __( 'Michoacán', 'stripe' ),
		'MO' => __( 'Morelos', 'stripe' ),
		'NA' => __( 'Nayarit', 'stripe' ),
		'OA' => __( 'Oaxaca', 'stripe' ),
		'PU' => __( 'Puebla', 'stripe' ),
		'QT' => __( 'Querétaro', 'stripe' ),
		'QR' => __( 'Quintana Roo', 'stripe' ),
		'SL' => __( 'San Luis Potosí', 'stripe' ),
		'SI' => __( 'Sinaloa', 'stripe' ),
		'SO' => __( 'Sonora', 'stripe' ),
		'TB' => __( 'Tabasco', 'stripe' ),
		'TM' => __( 'Tamaulipas', 'stripe' ),
		'TL' => __( 'Tlaxcala', 'stripe' ),
		'VE' => __( 'Veracruz', 'stripe' ),
		'YU' => __( 'Yucatán', 'stripe' ),
		'ZA' => __( 'Zacatecas', 'stripe' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'stripe' ),
		'KDH' => __( 'Kedah', 'stripe' ),
		'KTN' => __( 'Kelantan', 'stripe' ),
		'LBN' => __( 'Labuan', 'stripe' ),
		'MLK' => __( 'Malacca (Melaka)', 'stripe' ),
		'NSN' => __( 'Negeri Sembilan', 'stripe' ),
		'PHG' => __( 'Pahang', 'stripe' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'stripe' ),
		'PRK' => __( 'Perak', 'stripe' ),
		'PLS' => __( 'Perlis', 'stripe' ),
		'SBH' => __( 'Sabah', 'stripe' ),
		'SWK' => __( 'Sarawak', 'stripe' ),
		'SGR' => __( 'Selangor', 'stripe' ),
		'TRG' => __( 'Terengganu', 'stripe' ),
		'PJY' => __( 'Putrajaya', 'stripe' ),
		'KUL' => __( 'Kuala Lumpur', 'stripe' ),
	),
	'MZ' => array( // Mozambican provinces.
		'MZP'   => __( 'Cabo Delgado', 'stripe' ),
		'MZG'   => __( 'Gaza', 'stripe' ),
		'MZI'   => __( 'Inhambane', 'stripe' ),
		'MZB'   => __( 'Manica', 'stripe' ),
		'MZL'   => __( 'Maputo Province', 'stripe' ),
		'MZMPM' => __( 'Maputo', 'stripe' ),
		'MZN'   => __( 'Nampula', 'stripe' ),
		'MZA'   => __( 'Niassa', 'stripe' ),
		'MZS'   => __( 'Sofala', 'stripe' ),
		'MZT'   => __( 'Tete', 'stripe' ),
		'MZQ'   => __( 'Zambézia', 'stripe' ),
	),
	'NA' => array( // Namibian regions.
		'ER' => __( 'Erongo', 'stripe' ),
		'HA' => __( 'Hardap', 'stripe' ),
		'KA' => __( 'Karas', 'stripe' ),
		'KE' => __( 'Kavango East', 'stripe' ),
		'KW' => __( 'Kavango West', 'stripe' ),
		'KH' => __( 'Khomas', 'stripe' ),
		'KU' => __( 'Kunene', 'stripe' ),
		'OW' => __( 'Ohangwena', 'stripe' ),
		'OH' => __( 'Omaheke', 'stripe' ),
		'OS' => __( 'Omusati', 'stripe' ),
		'ON' => __( 'Oshana', 'stripe' ),
		'OT' => __( 'Oshikoto', 'stripe' ),
		'OD' => __( 'Otjozondjupa', 'stripe' ),
		'CA' => __( 'Zambezi', 'stripe' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'stripe' ),
		'FC' => __( 'Abuja', 'stripe' ),
		'AD' => __( 'Adamawa', 'stripe' ),
		'AK' => __( 'Akwa Ibom', 'stripe' ),
		'AN' => __( 'Anambra', 'stripe' ),
		'BA' => __( 'Bauchi', 'stripe' ),
		'BY' => __( 'Bayelsa', 'stripe' ),
		'BE' => __( 'Benue', 'stripe' ),
		'BO' => __( 'Borno', 'stripe' ),
		'CR' => __( 'Cross River', 'stripe' ),
		'DE' => __( 'Delta', 'stripe' ),
		'EB' => __( 'Ebonyi', 'stripe' ),
		'ED' => __( 'Edo', 'stripe' ),
		'EK' => __( 'Ekiti', 'stripe' ),
		'EN' => __( 'Enugu', 'stripe' ),
		'GO' => __( 'Gombe', 'stripe' ),
		'IM' => __( 'Imo', 'stripe' ),
		'JI' => __( 'Jigawa', 'stripe' ),
		'KD' => __( 'Kaduna', 'stripe' ),
		'KN' => __( 'Kano', 'stripe' ),
		'KT' => __( 'Katsina', 'stripe' ),
		'KE' => __( 'Kebbi', 'stripe' ),
		'KO' => __( 'Kogi', 'stripe' ),
		'KW' => __( 'Kwara', 'stripe' ),
		'LA' => __( 'Lagos', 'stripe' ),
		'NA' => __( 'Nasarawa', 'stripe' ),
		'NI' => __( 'Niger', 'stripe' ),
		'OG' => __( 'Ogun', 'stripe' ),
		'ON' => __( 'Ondo', 'stripe' ),
		'OS' => __( 'Osun', 'stripe' ),
		'OY' => __( 'Oyo', 'stripe' ),
		'PL' => __( 'Plateau', 'stripe' ),
		'RI' => __( 'Rivers', 'stripe' ),
		'SO' => __( 'Sokoto', 'stripe' ),
		'TA' => __( 'Taraba', 'stripe' ),
		'YO' => __( 'Yobe', 'stripe' ),
		'ZA' => __( 'Zamfara', 'stripe' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepalese zones.
		'BAG' => __( 'Bagmati', 'stripe' ),
		'BHE' => __( 'Bheri', 'stripe' ),
		'DHA' => __( 'Dhaulagiri', 'stripe' ),
		'GAN' => __( 'Gandaki', 'stripe' ),
		'JAN' => __( 'Janakpur', 'stripe' ),
		'KAR' => __( 'Karnali', 'stripe' ),
		'KOS' => __( 'Koshi', 'stripe' ),
		'LUM' => __( 'Lumbini', 'stripe' ),
		'MAH' => __( 'Mahakali', 'stripe' ),
		'MEC' => __( 'Mechi', 'stripe' ),
		'NAR' => __( 'Narayani', 'stripe' ),
		'RAP' => __( 'Rapti', 'stripe' ),
		'SAG' => __( 'Sagarmatha', 'stripe' ),
		'SET' => __( 'Seti', 'stripe' ),
	),
	'NI' => array( // Nicaraguan states.
		'NI-AN' => __( 'Atlántico Norte', 'stripe' ),
		'NI-AS' => __( 'Atlántico Sur', 'stripe' ),
		'NI-BO' => __( 'Boaco', 'stripe' ),
		'NI-CA' => __( 'Carazo', 'stripe' ),
		'NI-CI' => __( 'Chinandega', 'stripe' ),
		'NI-CO' => __( 'Chontales', 'stripe' ),
		'NI-ES' => __( 'Estelí', 'stripe' ),
		'NI-GR' => __( 'Granada', 'stripe' ),
		'NI-JI' => __( 'Jinotega', 'stripe' ),
		'NI-LE' => __( 'León', 'stripe' ),
		'NI-MD' => __( 'Madriz', 'stripe' ),
		'NI-MN' => __( 'Managua', 'stripe' ),
		'NI-MS' => __( 'Masaya', 'stripe' ),
		'NI-MT' => __( 'Matagalpa', 'stripe' ),
		'NI-NS' => __( 'Nueva Segovia', 'stripe' ),
		'NI-RI' => __( 'Rivas', 'stripe' ),
		'NI-SJ' => __( 'Río San Juan', 'stripe' ),
	),
	'NZ' => array( // New Zealand states.
		'NL' => __( 'Northland', 'stripe' ),
		'AK' => __( 'Auckland', 'stripe' ),
		'WA' => __( 'Waikato', 'stripe' ),
		'BP' => __( 'Bay of Plenty', 'stripe' ),
		'TK' => __( 'Taranaki', 'stripe' ),
		'GI' => __( 'Gisborne', 'stripe' ),
		'HB' => __( 'Hawke’s Bay', 'stripe' ),
		'MW' => __( 'Manawatu-Wanganui', 'stripe' ),
		'WE' => __( 'Wellington', 'stripe' ),
		'NS' => __( 'Nelson', 'stripe' ),
		'MB' => __( 'Marlborough', 'stripe' ),
		'TM' => __( 'Tasman', 'stripe' ),
		'WC' => __( 'West Coast', 'stripe' ),
		'CT' => __( 'Canterbury', 'stripe' ),
		'OT' => __( 'Otago', 'stripe' ),
		'SL' => __( 'Southland', 'stripe' ),
	),
	'PA' => array( // Panamanian states.
		'PA-1'  => __( 'Bocas del Toro', 'stripe' ),
		'PA-2'  => __( 'Coclé', 'stripe' ),
		'PA-3'  => __( 'Colón', 'stripe' ),
		'PA-4'  => __( 'Chiriquí', 'stripe' ),
		'PA-5'  => __( 'Darién', 'stripe' ),
		'PA-6'  => __( 'Herrera', 'stripe' ),
		'PA-7'  => __( 'Los Santos', 'stripe' ),
		'PA-8'  => __( 'Panamá', 'stripe' ),
		'PA-9'  => __( 'Veraguas', 'stripe' ),
		'PA-10' => __( 'West Panamá', 'stripe' ),
		'PA-EM' => __( 'Emberá', 'stripe' ),
		'PA-KY' => __( 'Guna Yala', 'stripe' ),
		'PA-NB' => __( 'Ngöbe-Buglé', 'stripe' ),
	),
	'PE' => array( // Peruvian states.
		'CAL' => __( 'El Callao', 'stripe' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'stripe' ),
		'AMA' => __( 'Amazonas', 'stripe' ),
		'ANC' => __( 'Ancash', 'stripe' ),
		'APU' => __( 'Apurímac', 'stripe' ),
		'ARE' => __( 'Arequipa', 'stripe' ),
		'AYA' => __( 'Ayacucho', 'stripe' ),
		'CAJ' => __( 'Cajamarca', 'stripe' ),
		'CUS' => __( 'Cusco', 'stripe' ),
		'HUV' => __( 'Huancavelica', 'stripe' ),
		'HUC' => __( 'Huánuco', 'stripe' ),
		'ICA' => __( 'Ica', 'stripe' ),
		'JUN' => __( 'Junín', 'stripe' ),
		'LAL' => __( 'La Libertad', 'stripe' ),
		'LAM' => __( 'Lambayeque', 'stripe' ),
		'LIM' => __( 'Lima', 'stripe' ),
		'LOR' => __( 'Loreto', 'stripe' ),
		'MDD' => __( 'Madre de Dios', 'stripe' ),
		'MOQ' => __( 'Moquegua', 'stripe' ),
		'PAS' => __( 'Pasco', 'stripe' ),
		'PIU' => __( 'Piura', 'stripe' ),
		'PUN' => __( 'Puno', 'stripe' ),
		'SAM' => __( 'San Martín', 'stripe' ),
		'TAC' => __( 'Tacna', 'stripe' ),
		'TUM' => __( 'Tumbes', 'stripe' ),
		'UCA' => __( 'Ucayali', 'stripe' ),
	),
	'PH' => array( // Philippine provinces.
		'ABR' => __( 'Abra', 'stripe' ),
		'AGN' => __( 'Agusan del Norte', 'stripe' ),
		'AGS' => __( 'Agusan del Sur', 'stripe' ),
		'AKL' => __( 'Aklan', 'stripe' ),
		'ALB' => __( 'Albay', 'stripe' ),
		'ANT' => __( 'Antique', 'stripe' ),
		'APA' => __( 'Apayao', 'stripe' ),
		'AUR' => __( 'Aurora', 'stripe' ),
		'BAS' => __( 'Basilan', 'stripe' ),
		'BAN' => __( 'Bataan', 'stripe' ),
		'BTN' => __( 'Batanes', 'stripe' ),
		'BTG' => __( 'Batangas', 'stripe' ),
		'BEN' => __( 'Benguet', 'stripe' ),
		'BIL' => __( 'Biliran', 'stripe' ),
		'BOH' => __( 'Bohol', 'stripe' ),
		'BUK' => __( 'Bukidnon', 'stripe' ),
		'BUL' => __( 'Bulacan', 'stripe' ),
		'CAG' => __( 'Cagayan', 'stripe' ),
		'CAN' => __( 'Camarines Norte', 'stripe' ),
		'CAS' => __( 'Camarines Sur', 'stripe' ),
		'CAM' => __( 'Camiguin', 'stripe' ),
		'CAP' => __( 'Capiz', 'stripe' ),
		'CAT' => __( 'Catanduanes', 'stripe' ),
		'CAV' => __( 'Cavite', 'stripe' ),
		'CEB' => __( 'Cebu', 'stripe' ),
		'COM' => __( 'Compostela Valley', 'stripe' ),
		'NCO' => __( 'Cotabato', 'stripe' ),
		'DAV' => __( 'Davao del Norte', 'stripe' ),
		'DAS' => __( 'Davao del Sur', 'stripe' ),
		'DAC' => __( 'Davao Occidental', 'stripe' ),
		'DAO' => __( 'Davao Oriental', 'stripe' ),
		'DIN' => __( 'Dinagat Islands', 'stripe' ),
		'EAS' => __( 'Eastern Samar', 'stripe' ),
		'GUI' => __( 'Guimaras', 'stripe' ),
		'IFU' => __( 'Ifugao', 'stripe' ),
		'ILN' => __( 'Ilocos Norte', 'stripe' ),
		'ILS' => __( 'Ilocos Sur', 'stripe' ),
		'ILI' => __( 'Iloilo', 'stripe' ),
		'ISA' => __( 'Isabela', 'stripe' ),
		'KAL' => __( 'Kalinga', 'stripe' ),
		'LUN' => __( 'La Union', 'stripe' ),
		'LAG' => __( 'Laguna', 'stripe' ),
		'LAN' => __( 'Lanao del Norte', 'stripe' ),
		'LAS' => __( 'Lanao del Sur', 'stripe' ),
		'LEY' => __( 'Leyte', 'stripe' ),
		'MAG' => __( 'Maguindanao', 'stripe' ),
		'MAD' => __( 'Marinduque', 'stripe' ),
		'MAS' => __( 'Masbate', 'stripe' ),
		'MSC' => __( 'Misamis Occidental', 'stripe' ),
		'MSR' => __( 'Misamis Oriental', 'stripe' ),
		'MOU' => __( 'Mountain Province', 'stripe' ),
		'NEC' => __( 'Negros Occidental', 'stripe' ),
		'NER' => __( 'Negros Oriental', 'stripe' ),
		'NSA' => __( 'Northern Samar', 'stripe' ),
		'NUE' => __( 'Nueva Ecija', 'stripe' ),
		'NUV' => __( 'Nueva Vizcaya', 'stripe' ),
		'MDC' => __( 'Occidental Mindoro', 'stripe' ),
		'MDR' => __( 'Oriental Mindoro', 'stripe' ),
		'PLW' => __( 'Palawan', 'stripe' ),
		'PAM' => __( 'Pampanga', 'stripe' ),
		'PAN' => __( 'Pangasinan', 'stripe' ),
		'QUE' => __( 'Quezon', 'stripe' ),
		'QUI' => __( 'Quirino', 'stripe' ),
		'RIZ' => __( 'Rizal', 'stripe' ),
		'ROM' => __( 'Romblon', 'stripe' ),
		'WSA' => __( 'Samar', 'stripe' ),
		'SAR' => __( 'Sarangani', 'stripe' ),
		'SIQ' => __( 'Siquijor', 'stripe' ),
		'SOR' => __( 'Sorsogon', 'stripe' ),
		'SCO' => __( 'South Cotabato', 'stripe' ),
		'SLE' => __( 'Southern Leyte', 'stripe' ),
		'SUK' => __( 'Sultan Kudarat', 'stripe' ),
		'SLU' => __( 'Sulu', 'stripe' ),
		'SUN' => __( 'Surigao del Norte', 'stripe' ),
		'SUR' => __( 'Surigao del Sur', 'stripe' ),
		'TAR' => __( 'Tarlac', 'stripe' ),
		'TAW' => __( 'Tawi-Tawi', 'stripe' ),
		'ZMB' => __( 'Zambales', 'stripe' ),
		'ZAN' => __( 'Zamboanga del Norte', 'stripe' ),
		'ZAS' => __( 'Zamboanga del Sur', 'stripe' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'stripe' ),
		'00'  => __( 'Metro Manila', 'stripe' ),
	),
	'PK' => array( // Pakistani states.
		'JK' => __( 'Azad Kashmir', 'stripe' ),
		'BA' => __( 'Balochistan', 'stripe' ),
		'TA' => __( 'FATA', 'stripe' ),
		'GB' => __( 'Gilgit Baltistan', 'stripe' ),
		'IS' => __( 'Islamabad Capital Territory', 'stripe' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'stripe' ),
		'PB' => __( 'Punjab', 'stripe' ),
		'SD' => __( 'Sindh', 'stripe' ),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguayan states.
		'PY-ASU' => __( 'Asunción', 'stripe' ),
		'PY-1'   => __( 'Concepción', 'stripe' ),
		'PY-2'   => __( 'San Pedro', 'stripe' ),
		'PY-3'   => __( 'Cordillera', 'stripe' ),
		'PY-4'   => __( 'Guairá', 'stripe' ),
		'PY-5'   => __( 'Caaguazú', 'stripe' ),
		'PY-6'   => __( 'Caazapá', 'stripe' ),
		'PY-7'   => __( 'Itapúa', 'stripe' ),
		'PY-8'   => __( 'Misiones', 'stripe' ),
		'PY-9'   => __( 'Paraguarí', 'stripe' ),
		'PY-10'  => __( 'Alto Paraná', 'stripe' ),
		'PY-11'  => __( 'Central', 'stripe' ),
		'PY-12'  => __( 'Ñeembucú', 'stripe' ),
		'PY-13'  => __( 'Amambay', 'stripe' ),
		'PY-14'  => __( 'Canindeyú', 'stripe' ),
		'PY-15'  => __( 'Presidente Hayes', 'stripe' ),
		'PY-16'  => __( 'Alto Paraguay', 'stripe' ),
		'PY-17'  => __( 'Boquerón', 'stripe' ),
	),
	'RE' => array(),
	'RO' => array( // Romanian states.
		'AB' => __( 'Alba', 'stripe' ),
		'AR' => __( 'Arad', 'stripe' ),
		'AG' => __( 'Argeș', 'stripe' ),
		'BC' => __( 'Bacău', 'stripe' ),
		'BH' => __( 'Bihor', 'stripe' ),
		'BN' => __( 'Bistrița-Năsăud', 'stripe' ),
		'BT' => __( 'Botoșani', 'stripe' ),
		'BR' => __( 'Brăila', 'stripe' ),
		'BV' => __( 'Brașov', 'stripe' ),
		'B'  => __( 'București', 'stripe' ),
		'BZ' => __( 'Buzău', 'stripe' ),
		'CL' => __( 'Călărași', 'stripe' ),
		'CS' => __( 'Caraș-Severin', 'stripe' ),
		'CJ' => __( 'Cluj', 'stripe' ),
		'CT' => __( 'Constanța', 'stripe' ),
		'CV' => __( 'Covasna', 'stripe' ),
		'DB' => __( 'Dâmbovița', 'stripe' ),
		'DJ' => __( 'Dolj', 'stripe' ),
		'GL' => __( 'Galați', 'stripe' ),
		'GR' => __( 'Giurgiu', 'stripe' ),
		'GJ' => __( 'Gorj', 'stripe' ),
		'HR' => __( 'Harghita', 'stripe' ),
		'HD' => __( 'Hunedoara', 'stripe' ),
		'IL' => __( 'Ialomița', 'stripe' ),
		'IS' => __( 'Iași', 'stripe' ),
		'IF' => __( 'Ilfov', 'stripe' ),
		'MM' => __( 'Maramureș', 'stripe' ),
		'MH' => __( 'Mehedinți', 'stripe' ),
		'MS' => __( 'Mureș', 'stripe' ),
		'NT' => __( 'Neamț', 'stripe' ),
		'OT' => __( 'Olt', 'stripe' ),
		'PH' => __( 'Prahova', 'stripe' ),
		'SJ' => __( 'Sălaj', 'stripe' ),
		'SM' => __( 'Satu Mare', 'stripe' ),
		'SB' => __( 'Sibiu', 'stripe' ),
		'SV' => __( 'Suceava', 'stripe' ),
		'TR' => __( 'Teleorman', 'stripe' ),
		'TM' => __( 'Timiș', 'stripe' ),
		'TL' => __( 'Tulcea', 'stripe' ),
		'VL' => __( 'Vâlcea', 'stripe' ),
		'VS' => __( 'Vaslui', 'stripe' ),
		'VN' => __( 'Vrancea', 'stripe' ),
	),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'SV' => array( // Salvadoran states.
		'SV-AH' => __( 'Ahuachapán', 'stripe' ),
		'SV-CA' => __( 'Cabañas', 'stripe' ),
		'SV-CH' => __( 'Chalatenango', 'stripe' ),
		'SV-CU' => __( 'Cuscatlán', 'stripe' ),
		'SV-LI' => __( 'La Libertad', 'stripe' ),
		'SV-MO' => __( 'Morazán', 'stripe' ),
		'SV-PA' => __( 'La Paz', 'stripe' ),
		'SV-SA' => __( 'Santa Ana', 'stripe' ),
		'SV-SM' => __( 'San Miguel', 'stripe' ),
		'SV-SO' => __( 'Sonsonate', 'stripe' ),
		'SV-SS' => __( 'San Salvador', 'stripe' ),
		'SV-SV' => __( 'San Vicente', 'stripe' ),
		'SV-UN' => __( 'La Unión', 'stripe' ),
		'SV-US' => __( 'Usulután', 'stripe' ),
	),
	'TH' => array( // Thai states.
		'TH-37' => __( 'Amnat Charoen', 'stripe' ),
		'TH-15' => __( 'Ang Thong', 'stripe' ),
		'TH-14' => __( 'Ayutthaya', 'stripe' ),
		'TH-10' => __( 'Bangkok', 'stripe' ),
		'TH-38' => __( 'Bueng Kan', 'stripe' ),
		'TH-31' => __( 'Buri Ram', 'stripe' ),
		'TH-24' => __( 'Chachoengsao', 'stripe' ),
		'TH-18' => __( 'Chai Nat', 'stripe' ),
		'TH-36' => __( 'Chaiyaphum', 'stripe' ),
		'TH-22' => __( 'Chanthaburi', 'stripe' ),
		'TH-50' => __( 'Chiang Mai', 'stripe' ),
		'TH-57' => __( 'Chiang Rai', 'stripe' ),
		'TH-20' => __( 'Chonburi', 'stripe' ),
		'TH-86' => __( 'Chumphon', 'stripe' ),
		'TH-46' => __( 'Kalasin', 'stripe' ),
		'TH-62' => __( 'Kamphaeng Phet', 'stripe' ),
		'TH-71' => __( 'Kanchanaburi', 'stripe' ),
		'TH-40' => __( 'Khon Kaen', 'stripe' ),
		'TH-81' => __( 'Krabi', 'stripe' ),
		'TH-52' => __( 'Lampang', 'stripe' ),
		'TH-51' => __( 'Lamphun', 'stripe' ),
		'TH-42' => __( 'Loei', 'stripe' ),
		'TH-16' => __( 'Lopburi', 'stripe' ),
		'TH-58' => __( 'Mae Hong Son', 'stripe' ),
		'TH-44' => __( 'Maha Sarakham', 'stripe' ),
		'TH-49' => __( 'Mukdahan', 'stripe' ),
		'TH-26' => __( 'Nakhon Nayok', 'stripe' ),
		'TH-73' => __( 'Nakhon Pathom', 'stripe' ),
		'TH-48' => __( 'Nakhon Phanom', 'stripe' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'stripe' ),
		'TH-60' => __( 'Nakhon Sawan', 'stripe' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'stripe' ),
		'TH-55' => __( 'Nan', 'stripe' ),
		'TH-96' => __( 'Narathiwat', 'stripe' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'stripe' ),
		'TH-43' => __( 'Nong Khai', 'stripe' ),
		'TH-12' => __( 'Nonthaburi', 'stripe' ),
		'TH-13' => __( 'Pathum Thani', 'stripe' ),
		'TH-94' => __( 'Pattani', 'stripe' ),
		'TH-82' => __( 'Phang Nga', 'stripe' ),
		'TH-93' => __( 'Phatthalung', 'stripe' ),
		'TH-56' => __( 'Phayao', 'stripe' ),
		'TH-67' => __( 'Phetchabun', 'stripe' ),
		'TH-76' => __( 'Phetchaburi', 'stripe' ),
		'TH-66' => __( 'Phichit', 'stripe' ),
		'TH-65' => __( 'Phitsanulok', 'stripe' ),
		'TH-54' => __( 'Phrae', 'stripe' ),
		'TH-83' => __( 'Phuket', 'stripe' ),
		'TH-25' => __( 'Prachin Buri', 'stripe' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'stripe' ),
		'TH-85' => __( 'Ranong', 'stripe' ),
		'TH-70' => __( 'Ratchaburi', 'stripe' ),
		'TH-21' => __( 'Rayong', 'stripe' ),
		'TH-45' => __( 'Roi Et', 'stripe' ),
		'TH-27' => __( 'Sa Kaeo', 'stripe' ),
		'TH-47' => __( 'Sakon Nakhon', 'stripe' ),
		'TH-11' => __( 'Samut Prakan', 'stripe' ),
		'TH-74' => __( 'Samut Sakhon', 'stripe' ),
		'TH-75' => __( 'Samut Songkhram', 'stripe' ),
		'TH-19' => __( 'Saraburi', 'stripe' ),
		'TH-91' => __( 'Satun', 'stripe' ),
		'TH-17' => __( 'Sing Buri', 'stripe' ),
		'TH-33' => __( 'Sisaket', 'stripe' ),
		'TH-90' => __( 'Songkhla', 'stripe' ),
		'TH-64' => __( 'Sukhothai', 'stripe' ),
		'TH-72' => __( 'Suphan Buri', 'stripe' ),
		'TH-84' => __( 'Surat Thani', 'stripe' ),
		'TH-32' => __( 'Surin', 'stripe' ),
		'TH-63' => __( 'Tak', 'stripe' ),
		'TH-92' => __( 'Trang', 'stripe' ),
		'TH-23' => __( 'Trat', 'stripe' ),
		'TH-34' => __( 'Ubon Ratchathani', 'stripe' ),
		'TH-41' => __( 'Udon Thani', 'stripe' ),
		'TH-61' => __( 'Uthai Thani', 'stripe' ),
		'TH-53' => __( 'Uttaradit', 'stripe' ),
		'TH-95' => __( 'Yala', 'stripe' ),
		'TH-35' => __( 'Yasothon', 'stripe' ),
	),
	'TR' => array( // Turkish states.
		'TR01' => __( 'Adana', 'stripe' ),
		'TR02' => __( 'Adıyaman', 'stripe' ),
		'TR03' => __( 'Afyon', 'stripe' ),
		'TR04' => __( 'Ağrı', 'stripe' ),
		'TR05' => __( 'Amasya', 'stripe' ),
		'TR06' => __( 'Ankara', 'stripe' ),
		'TR07' => __( 'Antalya', 'stripe' ),
		'TR08' => __( 'Artvin', 'stripe' ),
		'TR09' => __( 'Aydın', 'stripe' ),
		'TR10' => __( 'Balıkesir', 'stripe' ),
		'TR11' => __( 'Bilecik', 'stripe' ),
		'TR12' => __( 'Bingöl', 'stripe' ),
		'TR13' => __( 'Bitlis', 'stripe' ),
		'TR14' => __( 'Bolu', 'stripe' ),
		'TR15' => __( 'Burdur', 'stripe' ),
		'TR16' => __( 'Bursa', 'stripe' ),
		'TR17' => __( 'Çanakkale', 'stripe' ),
		'TR18' => __( 'Çankırı', 'stripe' ),
		'TR19' => __( 'Çorum', 'stripe' ),
		'TR20' => __( 'Denizli', 'stripe' ),
		'TR21' => __( 'Diyarbakır', 'stripe' ),
		'TR22' => __( 'Edirne', 'stripe' ),
		'TR23' => __( 'Elazığ', 'stripe' ),
		'TR24' => __( 'Erzincan', 'stripe' ),
		'TR25' => __( 'Erzurum', 'stripe' ),
		'TR26' => __( 'Eskişehir', 'stripe' ),
		'TR27' => __( 'Gaziantep', 'stripe' ),
		'TR28' => __( 'Giresun', 'stripe' ),
		'TR29' => __( 'Gümüşhane', 'stripe' ),
		'TR30' => __( 'Hakkari', 'stripe' ),
		'TR31' => __( 'Hatay', 'stripe' ),
		'TR32' => __( 'Isparta', 'stripe' ),
		'TR33' => __( 'İçel', 'stripe' ),
		'TR34' => __( 'İstanbul', 'stripe' ),
		'TR35' => __( 'İzmir', 'stripe' ),
		'TR36' => __( 'Kars', 'stripe' ),
		'TR37' => __( 'Kastamonu', 'stripe' ),
		'TR38' => __( 'Kayseri', 'stripe' ),
		'TR39' => __( 'Kırklareli', 'stripe' ),
		'TR40' => __( 'Kırşehir', 'stripe' ),
		'TR41' => __( 'Kocaeli', 'stripe' ),
		'TR42' => __( 'Konya', 'stripe' ),
		'TR43' => __( 'Kütahya', 'stripe' ),
		'TR44' => __( 'Malatya', 'stripe' ),
		'TR45' => __( 'Manisa', 'stripe' ),
		'TR46' => __( 'Kahramanmaraş', 'stripe' ),
		'TR47' => __( 'Mardin', 'stripe' ),
		'TR48' => __( 'Muğla', 'stripe' ),
		'TR49' => __( 'Muş', 'stripe' ),
		'TR50' => __( 'Nevşehir', 'stripe' ),
		'TR51' => __( 'Niğde', 'stripe' ),
		'TR52' => __( 'Ordu', 'stripe' ),
		'TR53' => __( 'Rize', 'stripe' ),
		'TR54' => __( 'Sakarya', 'stripe' ),
		'TR55' => __( 'Samsun', 'stripe' ),
		'TR56' => __( 'Siirt', 'stripe' ),
		'TR57' => __( 'Sinop', 'stripe' ),
		'TR58' => __( 'Sivas', 'stripe' ),
		'TR59' => __( 'Tekirdağ', 'stripe' ),
		'TR60' => __( 'Tokat', 'stripe' ),
		'TR61' => __( 'Trabzon', 'stripe' ),
		'TR62' => __( 'Tunceli', 'stripe' ),
		'TR63' => __( 'Şanlıurfa', 'stripe' ),
		'TR64' => __( 'Uşak', 'stripe' ),
		'TR65' => __( 'Van', 'stripe' ),
		'TR66' => __( 'Yozgat', 'stripe' ),
		'TR67' => __( 'Zonguldak', 'stripe' ),
		'TR68' => __( 'Aksaray', 'stripe' ),
		'TR69' => __( 'Bayburt', 'stripe' ),
		'TR70' => __( 'Karaman', 'stripe' ),
		'TR71' => __( 'Kırıkkale', 'stripe' ),
		'TR72' => __( 'Batman', 'stripe' ),
		'TR73' => __( 'Şırnak', 'stripe' ),
		'TR74' => __( 'Bartın', 'stripe' ),
		'TR75' => __( 'Ardahan', 'stripe' ),
		'TR76' => __( 'Iğdır', 'stripe' ),
		'TR77' => __( 'Yalova', 'stripe' ),
		'TR78' => __( 'Karabük', 'stripe' ),
		'TR79' => __( 'Kilis', 'stripe' ),
		'TR80' => __( 'Osmaniye', 'stripe' ),
		'TR81' => __( 'Düzce', 'stripe' ),
	),
	'TZ' => array( // Tanzanian states.
		'TZ01' => __( 'Arusha', 'stripe' ),
		'TZ02' => __( 'Dar es Salaam', 'stripe' ),
		'TZ03' => __( 'Dodoma', 'stripe' ),
		'TZ04' => __( 'Iringa', 'stripe' ),
		'TZ05' => __( 'Kagera', 'stripe' ),
		'TZ06' => __( 'Pemba North', 'stripe' ),
		'TZ07' => __( 'Zanzibar North', 'stripe' ),
		'TZ08' => __( 'Kigoma', 'stripe' ),
		'TZ09' => __( 'Kilimanjaro', 'stripe' ),
		'TZ10' => __( 'Pemba South', 'stripe' ),
		'TZ11' => __( 'Zanzibar South', 'stripe' ),
		'TZ12' => __( 'Lindi', 'stripe' ),
		'TZ13' => __( 'Mara', 'stripe' ),
		'TZ14' => __( 'Mbeya', 'stripe' ),
		'TZ15' => __( 'Zanzibar West', 'stripe' ),
		'TZ16' => __( 'Morogoro', 'stripe' ),
		'TZ17' => __( 'Mtwara', 'stripe' ),
		'TZ18' => __( 'Mwanza', 'stripe' ),
		'TZ19' => __( 'Coast', 'stripe' ),
		'TZ20' => __( 'Rukwa', 'stripe' ),
		'TZ21' => __( 'Ruvuma', 'stripe' ),
		'TZ22' => __( 'Shinyanga', 'stripe' ),
		'TZ23' => __( 'Singida', 'stripe' ),
		'TZ24' => __( 'Tabora', 'stripe' ),
		'TZ25' => __( 'Tanga', 'stripe' ),
		'TZ26' => __( 'Manyara', 'stripe' ),
		'TZ27' => __( 'Geita', 'stripe' ),
		'TZ28' => __( 'Katavi', 'stripe' ),
		'TZ29' => __( 'Njombe', 'stripe' ),
		'TZ30' => __( 'Simiyu', 'stripe' ),
	),
	'LK' => array(),
	'RS' => array( // Serbian districts.
		'RS00' => _x( 'Belgrade', 'district', 'stripe' ),
		'RS14' => _x( 'Bor', 'district', 'stripe' ),
		'RS11' => _x( 'Braničevo', 'district', 'stripe' ),
		'RS02' => _x( 'Central Banat', 'district', 'stripe' ),
		'RS10' => _x( 'Danube', 'district', 'stripe' ),
		'RS23' => _x( 'Jablanica', 'district', 'stripe' ),
		'RS09' => _x( 'Kolubara', 'district', 'stripe' ),
		'RS08' => _x( 'Mačva', 'district', 'stripe' ),
		'RS17' => _x( 'Morava', 'district', 'stripe' ),
		'RS20' => _x( 'Nišava', 'district', 'stripe' ),
		'RS01' => _x( 'North Bačka', 'district', 'stripe' ),
		'RS03' => _x( 'North Banat', 'district', 'stripe' ),
		'RS24' => _x( 'Pčinja', 'district', 'stripe' ),
		'RS22' => _x( 'Pirot', 'district', 'stripe' ),
		'RS13' => _x( 'Pomoravlje', 'district', 'stripe' ),
		'RS19' => _x( 'Rasina', 'district', 'stripe' ),
		'RS18' => _x( 'Raška', 'district', 'stripe' ),
		'RS06' => _x( 'South Bačka', 'district', 'stripe' ),
		'RS04' => _x( 'South Banat', 'district', 'stripe' ),
		'RS07' => _x( 'Srem', 'district', 'stripe' ),
		'RS12' => _x( 'Šumadija', 'district', 'stripe' ),
		'RS21' => _x( 'Toplica', 'district', 'stripe' ),
		'RS05' => _x( 'West Bačka', 'district', 'stripe' ),
		'RS15' => _x( 'Zaječar', 'district', 'stripe' ),
		'RS16' => _x( 'Zlatibor', 'district', 'stripe' ),
		'RS25' => _x( 'Kosovo', 'district', 'stripe' ),
		'RS26' => _x( 'Peć', 'district', 'stripe' ),
		'RS27' => _x( 'Prizren', 'district', 'stripe' ),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'stripe' ),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'stripe' ),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'stripe' ),
		'RSVO' => _x( 'Vojvodina', 'district', 'stripe' ),
	),
	'SE' => array(),
	'UA' => array( // Ukrainian oblasts.
		'VN' => __( 'Vinnytsia Oblast', 'stripe' ),
		'VL' => __( 'Volyn Oblast', 'stripe' ),
		'DP' => __( 'Dnipropetrovsk Oblast', 'stripe' ),
		'DT' => __( 'Donetsk Oblast', 'stripe' ),
		'ZT' => __( 'Zhytomyr Oblast', 'stripe' ),
		'ZK' => __( 'Zakarpattia Oblast', 'stripe' ),
		'ZP' => __( 'Zaporizhzhia Oblast', 'stripe' ),
		'IF' => __( 'Ivano-Frankivsk Oblast', 'stripe' ),
		'KV' => __( 'Kyiv Oblast', 'stripe' ),
		'KH' => __( 'Kirovohrad Oblast', 'stripe' ),
		'LH' => __( 'Luhansk Oblast', 'stripe' ),
		'LV' => __( 'Lviv Oblast', 'stripe' ),
		'MY' => __( 'Mykolaiv Oblast', 'stripe' ),
		'OD' => __( 'Odessa Oblast', 'stripe' ),
		'PL' => __( 'Poltava Oblast', 'stripe' ),
		'RV' => __( 'Rivne Oblast', 'stripe' ),
		'SM' => __( 'Sumy Oblast', 'stripe' ),
		'TP' => __( 'Ternopil Oblast', 'stripe' ),
		'KK' => __( 'Kharkiv Oblast', 'stripe' ),
		'KS' => __( 'Kherson Oblast', 'stripe' ),
		'KM' => __( 'Khmelnytskyi Oblast', 'stripe' ),
		'CK' => __( 'Cherkasy Oblast', 'stripe' ),
		'CH' => __( 'Chernihiv Oblast', 'stripe' ),
		'CV' => __( 'Chernivtsi Oblast', 'stripe' ),
	),
	'UG' => array( // Ugandan districts.
		'UG314' => __( 'Abim', 'stripe' ),
		'UG301' => __( 'Adjumani', 'stripe' ),
		'UG322' => __( 'Agago', 'stripe' ),
		'UG323' => __( 'Alebtong', 'stripe' ),
		'UG315' => __( 'Amolatar', 'stripe' ),
		'UG324' => __( 'Amudat', 'stripe' ),
		'UG216' => __( 'Amuria', 'stripe' ),
		'UG316' => __( 'Amuru', 'stripe' ),
		'UG302' => __( 'Apac', 'stripe' ),
		'UG303' => __( 'Arua', 'stripe' ),
		'UG217' => __( 'Budaka', 'stripe' ),
		'UG218' => __( 'Bududa', 'stripe' ),
		'UG201' => __( 'Bugiri', 'stripe' ),
		'UG235' => __( 'Bugweri', 'stripe' ),
		'UG420' => __( 'Buhweju', 'stripe' ),
		'UG117' => __( 'Buikwe', 'stripe' ),
		'UG219' => __( 'Bukedea', 'stripe' ),
		'UG118' => __( 'Bukomansimbi', 'stripe' ),
		'UG220' => __( 'Bukwa', 'stripe' ),
		'UG225' => __( 'Bulambuli', 'stripe' ),
		'UG416' => __( 'Buliisa', 'stripe' ),
		'UG401' => __( 'Bundibugyo', 'stripe' ),
		'UG430' => __( 'Bunyangabu', 'stripe' ),
		'UG402' => __( 'Bushenyi', 'stripe' ),
		'UG202' => __( 'Busia', 'stripe' ),
		'UG221' => __( 'Butaleja', 'stripe' ),
		'UG119' => __( 'Butambala', 'stripe' ),
		'UG233' => __( 'Butebo', 'stripe' ),
		'UG120' => __( 'Buvuma', 'stripe' ),
		'UG226' => __( 'Buyende', 'stripe' ),
		'UG317' => __( 'Dokolo', 'stripe' ),
		'UG121' => __( 'Gomba', 'stripe' ),
		'UG304' => __( 'Gulu', 'stripe' ),
		'UG403' => __( 'Hoima', 'stripe' ),
		'UG417' => __( 'Ibanda', 'stripe' ),
		'UG203' => __( 'Iganga', 'stripe' ),
		'UG418' => __( 'Isingiro', 'stripe' ),
		'UG204' => __( 'Jinja', 'stripe' ),
		'UG318' => __( 'Kaabong', 'stripe' ),
		'UG404' => __( 'Kabale', 'stripe' ),
		'UG405' => __( 'Kabarole', 'stripe' ),
		'UG213' => __( 'Kaberamaido', 'stripe' ),
		'UG427' => __( 'Kagadi', 'stripe' ),
		'UG428' => __( 'Kakumiro', 'stripe' ),
		'UG101' => __( 'Kalangala', 'stripe' ),
		'UG222' => __( 'Kaliro', 'stripe' ),
		'UG122' => __( 'Kalungu', 'stripe' ),
		'UG102' => __( 'Kampala', 'stripe' ),
		'UG205' => __( 'Kamuli', 'stripe' ),
		'UG413' => __( 'Kamwenge', 'stripe' ),
		'UG414' => __( 'Kanungu', 'stripe' ),
		'UG206' => __( 'Kapchorwa', 'stripe' ),
		'UG236' => __( 'Kapelebyong', 'stripe' ),
		'UG126' => __( 'Kasanda', 'stripe' ),
		'UG406' => __( 'Kasese', 'stripe' ),
		'UG207' => __( 'Katakwi', 'stripe' ),
		'UG112' => __( 'Kayunga', 'stripe' ),
		'UG407' => __( 'Kibaale', 'stripe' ),
		'UG103' => __( 'Kiboga', 'stripe' ),
		'UG227' => __( 'Kibuku', 'stripe' ),
		'UG432' => __( 'Kikuube', 'stripe' ),
		'UG419' => __( 'Kiruhura', 'stripe' ),
		'UG421' => __( 'Kiryandongo', 'stripe' ),
		'UG408' => __( 'Kisoro', 'stripe' ),
		'UG305' => __( 'Kitgum', 'stripe' ),
		'UG319' => __( 'Koboko', 'stripe' ),
		'UG325' => __( 'Kole', 'stripe' ),
		'UG306' => __( 'Kotido', 'stripe' ),
		'UG208' => __( 'Kumi', 'stripe' ),
		'UG333' => __( 'Kwania', 'stripe' ),
		'UG228' => __( 'Kween', 'stripe' ),
		'UG123' => __( 'Kyankwanzi', 'stripe' ),
		'UG422' => __( 'Kyegegwa', 'stripe' ),
		'UG415' => __( 'Kyenjojo', 'stripe' ),
		'UG125' => __( 'Kyotera', 'stripe' ),
		'UG326' => __( 'Lamwo', 'stripe' ),
		'UG307' => __( 'Lira', 'stripe' ),
		'UG229' => __( 'Luuka', 'stripe' ),
		'UG104' => __( 'Luwero', 'stripe' ),
		'UG124' => __( 'Lwengo', 'stripe' ),
		'UG114' => __( 'Lyantonde', 'stripe' ),
		'UG223' => __( 'Manafwa', 'stripe' ),
		'UG320' => __( 'Maracha', 'stripe' ),
		'UG105' => __( 'Masaka', 'stripe' ),
		'UG409' => __( 'Masindi', 'stripe' ),
		'UG214' => __( 'Mayuge', 'stripe' ),
		'UG209' => __( 'Mbale', 'stripe' ),
		'UG410' => __( 'Mbarara', 'stripe' ),
		'UG423' => __( 'Mitooma', 'stripe' ),
		'UG115' => __( 'Mityana', 'stripe' ),
		'UG308' => __( 'Moroto', 'stripe' ),
		'UG309' => __( 'Moyo', 'stripe' ),
		'UG106' => __( 'Mpigi', 'stripe' ),
		'UG107' => __( 'Mubende', 'stripe' ),
		'UG108' => __( 'Mukono', 'stripe' ),
		'UG334' => __( 'Nabilatuk', 'stripe' ),
		'UG311' => __( 'Nakapiripirit', 'stripe' ),
		'UG116' => __( 'Nakaseke', 'stripe' ),
		'UG109' => __( 'Nakasongola', 'stripe' ),
		'UG230' => __( 'Namayingo', 'stripe' ),
		'UG234' => __( 'Namisindwa', 'stripe' ),
		'UG224' => __( 'Namutumba', 'stripe' ),
		'UG327' => __( 'Napak', 'stripe' ),
		'UG310' => __( 'Nebbi', 'stripe' ),
		'UG231' => __( 'Ngora', 'stripe' ),
		'UG424' => __( 'Ntoroko', 'stripe' ),
		'UG411' => __( 'Ntungamo', 'stripe' ),
		'UG328' => __( 'Nwoya', 'stripe' ),
		'UG331' => __( 'Omoro', 'stripe' ),
		'UG329' => __( 'Otuke', 'stripe' ),
		'UG321' => __( 'Oyam', 'stripe' ),
		'UG312' => __( 'Pader', 'stripe' ),
		'UG332' => __( 'Pakwach', 'stripe' ),
		'UG210' => __( 'Pallisa', 'stripe' ),
		'UG110' => __( 'Rakai', 'stripe' ),
		'UG429' => __( 'Rubanda', 'stripe' ),
		'UG425' => __( 'Rubirizi', 'stripe' ),
		'UG431' => __( 'Rukiga', 'stripe' ),
		'UG412' => __( 'Rukungiri', 'stripe' ),
		'UG111' => __( 'Sembabule', 'stripe' ),
		'UG232' => __( 'Serere', 'stripe' ),
		'UG426' => __( 'Sheema', 'stripe' ),
		'UG215' => __( 'Sironko', 'stripe' ),
		'UG211' => __( 'Soroti', 'stripe' ),
		'UG212' => __( 'Tororo', 'stripe' ),
		'UG113' => __( 'Wakiso', 'stripe' ),
		'UG313' => __( 'Yumbe', 'stripe' ),
		'UG330' => __( 'Zombo', 'stripe' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'stripe' ),
		'84' => __( 'Howland Island', 'stripe' ),
		'86' => __( 'Jarvis Island', 'stripe' ),
		'67' => __( 'Johnston Atoll', 'stripe' ),
		'89' => __( 'Kingman Reef', 'stripe' ),
		'71' => __( 'Midway Atoll', 'stripe' ),
		'76' => __( 'Navassa Island', 'stripe' ),
		'95' => __( 'Palmyra Atoll', 'stripe' ),
		'79' => __( 'Wake Island', 'stripe' ),
	),
	'US' => array( // U.S. states.
		'AL' => __( 'Alabama', 'stripe' ),
		'AK' => __( 'Alaska', 'stripe' ),
		'AZ' => __( 'Arizona', 'stripe' ),
		'AR' => __( 'Arkansas', 'stripe' ),
		'CA' => __( 'California', 'stripe' ),
		'CO' => __( 'Colorado', 'stripe' ),
		'CT' => __( 'Connecticut', 'stripe' ),
		'DE' => __( 'Delaware', 'stripe' ),
		'DC' => __( 'District Of Columbia', 'stripe' ),
		'FL' => __( 'Florida', 'stripe' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'stripe' ),
		'HI' => __( 'Hawaii', 'stripe' ),
		'ID' => __( 'Idaho', 'stripe' ),
		'IL' => __( 'Illinois', 'stripe' ),
		'IN' => __( 'Indiana', 'stripe' ),
		'IA' => __( 'Iowa', 'stripe' ),
		'KS' => __( 'Kansas', 'stripe' ),
		'KY' => __( 'Kentucky', 'stripe' ),
		'LA' => __( 'Louisiana', 'stripe' ),
		'ME' => __( 'Maine', 'stripe' ),
		'MD' => __( 'Maryland', 'stripe' ),
		'MA' => __( 'Massachusetts', 'stripe' ),
		'MI' => __( 'Michigan', 'stripe' ),
		'MN' => __( 'Minnesota', 'stripe' ),
		'MS' => __( 'Mississippi', 'stripe' ),
		'MO' => __( 'Missouri', 'stripe' ),
		'MT' => __( 'Montana', 'stripe' ),
		'NE' => __( 'Nebraska', 'stripe' ),
		'NV' => __( 'Nevada', 'stripe' ),
		'NH' => __( 'New Hampshire', 'stripe' ),
		'NJ' => __( 'New Jersey', 'stripe' ),
		'NM' => __( 'New Mexico', 'stripe' ),
		'NY' => __( 'New York', 'stripe' ),
		'NC' => __( 'North Carolina', 'stripe' ),
		'ND' => __( 'North Dakota', 'stripe' ),
		'OH' => __( 'Ohio', 'stripe' ),
		'OK' => __( 'Oklahoma', 'stripe' ),
		'OR' => __( 'Oregon', 'stripe' ),
		'PA' => __( 'Pennsylvania', 'stripe' ),
		'RI' => __( 'Rhode Island', 'stripe' ),
		'SC' => __( 'South Carolina', 'stripe' ),
		'SD' => __( 'South Dakota', 'stripe' ),
		'TN' => __( 'Tennessee', 'stripe' ),
		'TX' => __( 'Texas', 'stripe' ),
		'UT' => __( 'Utah', 'stripe' ),
		'VT' => __( 'Vermont', 'stripe' ),
		'VA' => __( 'Virginia', 'stripe' ),
		'WA' => __( 'Washington', 'stripe' ),
		'WV' => __( 'West Virginia', 'stripe' ),
		'WI' => __( 'Wisconsin', 'stripe' ),
		'WY' => __( 'Wyoming', 'stripe' ),
		'AA' => __( 'Armed Forces (AA)', 'stripe' ),
		'AE' => __( 'Armed Forces (AE)', 'stripe' ),
		'AP' => __( 'Armed Forces (AP)', 'stripe' ),
	),
	'UY' => array( // Uruguayan states.
		'UY-AR' => __( 'Artigas', 'stripe' ),
		'UY-CA' => __( 'Canelones', 'stripe' ),
		'UY-CL' => __( 'Cerro Largo', 'stripe' ),
		'UY-CO' => __( 'Colonia', 'stripe' ),
		'UY-DU' => __( 'Durazno', 'stripe' ),
		'UY-FS' => __( 'Flores', 'stripe' ),
		'UY-FD' => __( 'Florida', 'stripe' ),
		'UY-LA' => __( 'Lavalleja', 'stripe' ),
		'UY-MA' => __( 'Maldonado', 'stripe' ),
		'UY-MO' => __( 'Montevideo', 'stripe' ),
		'UY-PA' => __( 'Paysandú', 'stripe' ),
		'UY-RN' => __( 'Río Negro', 'stripe' ),
		'UY-RV' => __( 'Rivera', 'stripe' ),
		'UY-RO' => __( 'Rocha', 'stripe' ),
		'UY-SA' => __( 'Salto', 'stripe' ),
		'UY-SJ' => __( 'San José', 'stripe' ),
		'UY-SO' => __( 'Soriano', 'stripe' ),
		'UY-TA' => __( 'Tacuarembó', 'stripe' ),
		'UY-TT' => __( 'Treinta y Tres', 'stripe' ),
	),
	'VE' => array( // Venezuelan states.
		'VE-A' => __( 'Capital', 'stripe' ),
		'VE-B' => __( 'Anzoátegui', 'stripe' ),
		'VE-C' => __( 'Apure', 'stripe' ),
		'VE-D' => __( 'Aragua', 'stripe' ),
		'VE-E' => __( 'Barinas', 'stripe' ),
		'VE-F' => __( 'Bolívar', 'stripe' ),
		'VE-G' => __( 'Carabobo', 'stripe' ),
		'VE-H' => __( 'Cojedes', 'stripe' ),
		'VE-I' => __( 'Falcón', 'stripe' ),
		'VE-J' => __( 'Guárico', 'stripe' ),
		'VE-K' => __( 'Lara', 'stripe' ),
		'VE-L' => __( 'Mérida', 'stripe' ),
		'VE-M' => __( 'Miranda', 'stripe' ),
		'VE-N' => __( 'Monagas', 'stripe' ),
		'VE-O' => __( 'Nueva Esparta', 'stripe' ),
		'VE-P' => __( 'Portuguesa', 'stripe' ),
		'VE-R' => __( 'Sucre', 'stripe' ),
		'VE-S' => __( 'Táchira', 'stripe' ),
		'VE-T' => __( 'Trujillo', 'stripe' ),
		'VE-U' => __( 'Yaracuy', 'stripe' ),
		'VE-V' => __( 'Zulia', 'stripe' ),
		'VE-W' => __( 'Federal Dependencies', 'stripe' ),
		'VE-X' => __( 'La Guaira (Vargas)', 'stripe' ),
		'VE-Y' => __( 'Delta Amacuro', 'stripe' ),
		'VE-Z' => __( 'Amazonas', 'stripe' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'stripe' ),
		'FS'  => __( 'Free State', 'stripe' ),
		'GP'  => __( 'Gauteng', 'stripe' ),
		'KZN' => __( 'KwaZulu-Natal', 'stripe' ),
		'LP'  => __( 'Limpopo', 'stripe' ),
		'MP'  => __( 'Mpumalanga', 'stripe' ),
		'NC'  => __( 'Northern Cape', 'stripe' ),
		'NW'  => __( 'North West', 'stripe' ),
		'WC'  => __( 'Western Cape', 'stripe' ),
	),
	'ZM' => array( // Zambian provinces.
		'ZM-01' => __( 'Western', 'stripe' ),
		'ZM-02' => __( 'Central', 'stripe' ),
		'ZM-03' => __( 'Eastern', 'stripe' ),
		'ZM-04' => __( 'Luapula', 'stripe' ),
		'ZM-05' => __( 'Northern', 'stripe' ),
		'ZM-06' => __( 'North-Western', 'stripe' ),
		'ZM-07' => __( 'Southern', 'stripe' ),
		'ZM-08' => __( 'Copperbelt', 'stripe' ),
		'ZM-09' => __( 'Lusaka', 'stripe' ),
		'ZM-10' => __( 'Muchinga', 'stripe' ),
	),
);
