<?php

/**

 * @author  RadiusTheme

 * @since   1.0

 * @version 1.0

 */



$nav_menu_args = ClenixTheme_Helper::nav_menu_args();

$clenix_socials = ClenixTheme_Helper::socials();



// Logo

$clenix_dark_logo_url = empty( ClenixTheme::$options['logo']['url'] ) ? CLENIX_IMG_URL . 'logo-dark.png' : ClenixTheme::$options['logo']['url'];

$clenix_light_logo_url = empty( ClenixTheme::$options['logo_light']['url'] ) ? CLENIX_IMG_URL . 'logo-light.png' : ClenixTheme::$options['logo_light']['url'];



$clenix_dark_logo = !isset(ClenixTheme::$options['logo']['id']) || empty( ClenixTheme::$options['logo']['id'] ) 

	? '<img width="190" height="60" src="' . esc_url($clenix_dark_logo_url) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" loading="lazy" />' 

	: wp_get_attachment_image( ClenixTheme::$options['logo']['id'], array(211, 75 ) );



$clenix_light_logo = !isset(ClenixTheme::$options['logo_light']['id']) || empty( ClenixTheme::$options['logo_light']['id'] ) 

	? '<img width="211" height="60" src="' . esc_url($clenix_light_logo_url) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" loading="lazy" />' 

	: wp_get_attachment_image( ClenixTheme::$options['logo_light']['id'], array(211, 75 ) );



?>

<div class="masthead-container" id="sticker">

	<div class="container">

		<div class="header-4-wrap">

			<div class="header-4-left">

				<div class="site-branding">

					<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_dark_logo; ?></a>

					<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_light_logo; ?></a>

				</div>

			</div>

			<div class="header-4-middle">

				<div id="site-navigation" class="main-navigation">

					<?php wp_nav_menu( $nav_menu_args );?>

				</div>

			</div>

			<div class="header-4-right">

				<div class="header-phone">

					<div class="item-icon"><i class="flaticon-phone-call"></i></div>

					<div class="item-number"><a href="tel:<?php echo esc_attr( ClenixTheme::$options['phone'] );?>"><?php echo wp_kses( ClenixTheme::$options['phone'] , 'alltext_allow' );?></a></div>

				</div>

			</div>

		</div>

	</div>

</div>

<div class="rt-sticky-menu-wrapper rt-sticky-menu">

	<div class="container">

		<div class="sticky-menu-align">

			<div class="site-branding">

				<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_dark_logo; ?></a>

				<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_light_logo; ?>?></a>

			</div>

			<div class="main-navigation">

				<?php wp_nav_menu( $nav_menu_args ); ?>

			</div>

		</div>

	</div>

</div>