<?php

/**

 * @author  RadiusTheme

 * @since   1.0

 * @version 1.0

 */



$nav_menu_args = ClenixTheme_Helper::nav_menu_args();

$clenix_socials = ClenixTheme_Helper::socials();



// Logo

$clenix_dark_logo_url = empty( ClenixTheme::$options['logo']['url'] ) ? CLENIX_IMG_URL . 'logo-dark.png' : ClenixTheme::$options['logo']['url'];

$clenix_light_logo_url = empty( ClenixTheme::$options['logo_light']['url'] ) ? CLENIX_IMG_URL . 'logo-light.png' : ClenixTheme::$options['logo_light']['url'];



$clenix_dark_logo = !isset(ClenixTheme::$options['logo']['id']) || empty( ClenixTheme::$options['logo']['id'] ) 

	? '<img width="190" height="60" src="' . esc_url($clenix_dark_logo_url) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" loading="lazy" />' 

	: wp_get_attachment_image( ClenixTheme::$options['logo']['id'], array(211, 75 ) );



$clenix_light_logo = !isset(ClenixTheme::$options['logo_light']['id']) || empty( ClenixTheme::$options['logo_light']['id'] ) 

	? '<img width="211" height="60" src="' . esc_url($clenix_light_logo_url) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" loading="lazy" />' 

	: wp_get_attachment_image( ClenixTheme::$options['logo_light']['id'], array(211, 75 ) );



?>

<div class="masthead-container header-controll" id="sticker">

	<div class="container">

		<div class="menu-full-wrap">

			<div class="site-branding">

				<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_dark_logo; ?></a>

				<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_light_logo; ?></a>

			</div>

			<div class="menu-wrap">

				<div id="site-navigation" class="main-navigation">

					<?php wp_nav_menu( $nav_menu_args ); ?>

				</div>

			</div>

			<div class="info-wrap header-icon-area">			

				<?php get_template_part( 'template-parts/header/icon', 'search' ); ?>

				<?php get_template_part( 'template-parts/header/icon', 'cart' ); ?>

				<?php if ( ClenixTheme::$options['online_button'] == '1' ) { ?>

					<div class="header-button">

						<a class="button-btn" target="_self" href="<?php echo esc_url( ClenixTheme::$options['online_button_link']  );?>"><?php echo esc_html( ClenixTheme::$options['online_button_text'] );?></a>

					</div>

				<?php } ?>

			</div>			

		</div>

	</div>

</div>

<div class="rt-sticky-menu-wrapper rt-sticky-menu">

	<div class="container">

		<div class="menu-full-wrap">

			<div class="site-branding">

				<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_dark_logo; ?></a>

				<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $clenix_light_logo; ?></a>

			</div>

			<div class="main-navigation">

				<?php wp_nav_menu( $nav_menu_args ); ?>

			</div>

			<div class="info-wrap header-icon-area">			

				<?php get_template_part( 'template-parts/header/icon', 'search' ); ?>

				<?php get_template_part( 'template-parts/header/icon', 'cart' ); ?>

				<?php if ( ClenixTheme::$options['online_button'] == '1' ) { ?>

					<div class="header-button">

						<a class="button-btn" target="_self" href="<?php echo esc_url( ClenixTheme::$options['online_button_link']  );?>"><?php echo esc_html( ClenixTheme::$options['online_button_text'] );?></a>

					</div>

				<?php } ?>

			</div>	

		</div>

	</div>

</div>