<?php

/**

 * @author  RadiusTheme

 * @since   1.0

 * @version 1.0

 */



$clenix_socials = ClenixTheme_Helper::socials();

?>

<div id="tophead" class="header-top-bar align-items-center">

	<div class="container">

		<div class="top-bar-wrap">

			<div class="tophead-left">				

				<?php if ( ClenixTheme::$options['address'] ): ?>

					<div class="address">

						<span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo wp_kses( ClenixTheme::$options['address'] , 'alltext_allow' );?>

					</div>

				<?php endif; ?>

				<?php if ( ClenixTheme::$options['email'] ): ?>

					<div class="email">

						<span><i class="fa fa-envelope"></i></span><a href="mailto:<?php echo esc_attr( ClenixTheme::$options['phone'] );?>"><?php echo wp_kses( ClenixTheme::$options['email'] , 'alltext_allow' );?></a>

					</div>

				<?php endif; ?>

			</div>

			<div class="tophead-right">

				<?php if ( ClenixTheme::$options['phone'] ) { ?>					

					<div class="info"><i class="flaticon-phone-call"></i><span><?php $header_hotline_txt = ClenixTheme::$options['header_hotline_txt'];

					if ( !empty( $header_hotline_txt ) ){ echo esc_html( $header_hotline_txt ); } else { esc_html_e( 'Quick Contact', 'clenix' ); } ?>: </span><a href="tel:<?php echo esc_attr( ClenixTheme::$options['phone'] );?>"><?php echo wp_kses( ClenixTheme::$options['phone'] , 'alltext_allow' );?></a></div>

				<?php } ?>	

				<?php if ( $clenix_socials ) { ?>

					<ul class="tophead-social">

						<?php foreach ( $clenix_socials as $clenix_social ): ?>

							<li><a target="_blank" href="<?php echo esc_url( $clenix_social['url'] );?>"><i class="fa <?php echo esc_attr( $clenix_social['icon'] );?>"></i></a></li>

						<?php endforeach; ?>

					</ul>

				<?php } ?>

			</div>

		</div>

	</div>

</div>