<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Enrollment extends Model
{
    use SoftDeletes;
    protected $dates = ['deleted_at'];
    protected $guarded = [];
    public $timestamps = true;

    public function country(){
        return $this->belongsTo(Country::class);
    }

    public function visa(){
        return $this->belongsTo(Visa::class);
    }

    public function payments(){
        return $this->hasMany(PaymentResponse::class);
    }
}
