<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Enrollment;
use PDF;
use App\Country;
use App\Visa;
use App\PaymentResponse;

class EnrollusersController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(){
        $enrollUsersList = Enrollment::with('payments')->get();
        //dd($enrollUsersList);
        return view('enrollusers.index', compact('enrollUsersList'));
        
    }//


    
    

    public function show($enrollment){

        $enrollment = Enrollment::with('country', 'payments')->where('id', $enrollment)->first();
        //dd($enrollment);
        $countries = Country::orderBy('country_name', 'asc')->get();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('enrollusers.viewmore', compact('enrollment','visas', 'countries', 'schoolEducation', 'higherEducation', 'referenceFrom'));

        
    }


    public function update(Request $request)
    {
        $enroll = $request->all();
         //dd(Auth::user()->id);
         if($enroll['disability'] == "N"){
            $enroll['intellectual'] = "0";
            $enroll['hearing'] = "0";
            $enroll['learing'] = "0";
            $enroll['physical'] = "0";
            $enroll['vision'] = "0";
            $enroll['medical'] = "0";
            $enroll['otherDisability'] = "0";
            $enroll['disabilityProblemOther'] = null;
         }
         
         
        $enrollment = Enrollment::find($enroll['id']);
        $enrollment->update($enroll);
        return redirect('enrollusers')->with('success','Updated Successfully');        
    }



    public function generatepdf($enrollment)
    {
        $enrollment = Enrollment::with('country', 'payments')->where('id', $enrollment)->first();
        //dd($enrollment);
        $countries = Country::orderBy('country_name', 'asc')->get();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('enrollusers.generatepdf', compact('enrollment','visas', 'countries', 'schoolEducation', 'higherEducation', 'referenceFrom'));

    }


    public function schoolEducation(){
        return [
            '0'=>'I NEVER ATTEND SCHOOL',
            '1'=>'YEAR 8 OR BELOW',
            '2'=>'YEAR 9 OR EQUIVALENT',
            '3'=>'YEAR 10 OR EQUIVALENT',
            '4'=>'YEAR 11 OR EQUIVALENT',
            '5'=>'YEAR 12 OR EQUIVALENT',
            '6'=>'I AM STILL AT SCHOOL',
        ];
    }

    public function referenceFrom(){
        return [
            '0'=>'Google',
            '1'=>'Facebook',
            '2'=>'Friend',
            '3'=>'Collegue',
            '4'=>'Others',
        ];
    }


    public function higherEducation(){
        return [
            '0'=>'CERTIFICATE I',
            '1'=>'CERTIFICATE II',
            '2'=>'CERTIFICATE III',
            '3'=>'CERTIFICATE IV/ADVANCE CERTIFICATE',
            '4'=>'DIPLOMA OR ASSOCIATE DIPLOMA',
            '5'=>'ADVANCE DIPLOMA OR ASSOCIATE DEGREE',
            '6'=>'OTHER QUALIFICATION',
        ];
    }


}
