<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Country;
use App\Visa;


class WelcomeController extends Controller
{
    public function index()
    {
        $countries = Country::orderBy('country_name', 'asc')->get();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('welcome',compact('countries', 'visas','schoolEducation', 'higherEducation', 'referenceFrom'));
       
    }

    

    public function skipeduser()
    {
        $countries = Country::orderBy('country_name', 'asc')->get();
        $visas = Visa::all();
        $schoolEducation = $this->schoolEducation();
        $higherEducation = $this->higherEducation();
        $referenceFrom = $this->referenceFrom();
        return view('skipeduser',compact('countries', 'visas','schoolEducation', 'higherEducation', 'referenceFrom'));
       
    }



    public function schoolEducation(){
        return [
            '0'=>'I NEVER ATTEND SCHOOL',
            '1'=>'YEAR 8 OR BELOW',
            '2'=>'YEAR 9 OR EQUIVALENT',
            '3'=>'YEAR 10 OR EQUIVALENT',
            '4'=>'YEAR 11 OR EQUIVALENT',
            '5'=>'YEAR 12 OR EQUIVALENT',
            '6'=>'I AM STILL AT SCHOOL',
        ];
    }

    public function referenceFrom(){
        return [
            '0'=>'Google',
            '1'=>'Facebook',
            '2'=>'Friend',
            '3'=>'Collegue',
            '4'=>'Others',
        ];
    }


    public function higherEducation(){
        return [
            '0'=>'CERTIFICATE I',
            '1'=>'CERTIFICATE II',
            '2'=>'CERTIFICATE III',
            '3'=>'CERTIFICATE IV/ADVANCE CERTIFICATE',
            '4'=>'DIPLOMA OR ASSOCIATE DIPLOMA',
            '5'=>'ADVANCE DIPLOMA OR ASSOCIATE DEGREE',
            '6'=>'OTHER QUALIFICATION',
        ];
    }


}
