<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEnrollmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('enrollments', function (Blueprint $table) {
            $table->id();
            $table->string("enrollmentNo");
            $table->enum('agree', ['0','1'])->default('0');
            $table->enum('course', ['0','1', '2'])->default('0');
            $table->enum('visacopy', ['0','1'])->default('1');
            $table->enum('govIssue', ['0','1'])->default('1');
            $table->enum('usiOption', ['0','1','2'])->default('0');
            $table->string('usi')->nullable();

            $table->enum('year18', ['0','1'])->default('1');
            $table->enum('interStudent', ['0','1'])->default('1');
            $table->enum('unpaid', ['0','1'])->default('1');
            $table->enum('lln', ['0','1'])->default('1');
            $table->enum('declaration', ['0','1'])->default('1');
            $table->string('declarationName');
            $table->string('dateOfSubmitted');

            $table->enum('titleName', ['Mr','Mrs','Miss','Other'])->default('Mr');
            $table->string('giveName');
            $table->string('middleName')->nullable();
            $table->string('surName')->nullable();
            $table->string('preferredName')->nullable();
            $table->string('dob');
            $table->string('pob');
            $table->enum('gender', ['Male', 'Female', 'Other']);
            $table->string('mobile');
            $table->string('workPhone')->nullable();
            $table->string('homePhone')->nullable();
            $table->string('whatsApp')->nullable();
            $table->string('email')->unique();

            $table->string('eName');
            $table->string('eRelationship');
            $table->string('eMobile');
            $table->string('eEmail')->nullable();

            $table->string('buildingName')->nullable();
            $table->string('flatNo')->nullable();
            $table->string('streetNo');
            $table->string('streetName');
            $table->string('suburb');
            $table->string('state');
            $table->bigInteger('postCode');
            

            $table->enum('sameAddress', ['0','1'])->default('1');

            $table->string('mailBuildingName')->nullable();
            $table->string('mailFlatNo')->nullable();
            $table->string('mailStreetNo');
            $table->string('mailStreetName');
            $table->string('mailSuburb');
            $table->string('mailState');
            $table->integer('mailPostCode');
            $table->string('mailPoBox')->nullable();

            $table->enum('englishWell', ['0','1','2','3'])->default('0');
            $table->enum('language', ['Y','N'])->default('Y');
            $table->string('otherlanguage')->nullable();
            $table->bigInteger('country_id');
            $table->enum('citizenStatus', ['Y','N'])->default('Y');
            $table->enum('prStatus', ['Y','N'])->default('Y');
            $table->bigInteger('visa_id');
            $table->enum('disability', ['Y','N'])->default('Y');


            $table->enum('hearing', ['0','1'])->default('0');
            $table->enum('learing', ['0','1'])->default('0');
            $table->enum('physical', ['0','1'])->default('0');
            $table->enum('intellectual', ['0','1'])->default('0');
            $table->enum('vision', ['0','1'])->default('0');
            $table->enum('medical', ['0','1'])->default('0');
            $table->enum('otherDisability', ['0','1'])->default('0');
            $table->string('disabilityProblemOther')->nullable();

            $table->string('schoolEducation');
            $table->integer('ysc');
            $table->enum('austrianEduQualification', ['Y','N'])->default('Y');
            $table->string('higherEducation')->nullable();
            $table->string('otherEduQualification')->nullable();


            $table->enum('firstTime', ['Y','N'])->default('Y');
            $table->enum('rpl', ['Y','N'])->default('Y');
            $table->enum('ct', ['Y','N'])->default('Y');
            $table->string('yesTransfer')->nullable();
            $table->string('currentEmpStatus');
            $table->string('studyPurpose');


            $table->enum('modeOfPayment', ['M','D'])->default('D');
            $table->bigInteger('amount');
            $table->enum('paymentTerms', ['M','F','W','C'])->default('M');
            $table->string('paymentTermsCustom')->nullable();
            $table->longText('w3review');
            $table->enum('exRelatedFeild', ['Y','N'])->default('Y');
            $table->longText('detailExp')->nullable();
            $table->longText('goals');
            $table->longText('whyChoose');
            $table->longText('referenceFrom');
            $table->string('refFrientName')->nullable();
            $table->string('refFrientMobile')->nullable();

            $table->enum('skillShut', ['0','1','2'])->default('2');
            $table->enum('skillUsb', ['0','1','2'])->default('2');
            $table->enum('skillWifi', ['0','1','2'])->default('2');
            $table->enum('skillFolder', ['0','1','2'])->default('2');
            $table->enum('skillPdf', ['0','1','2'])->default('2');
            $table->enum('skillFront', ['0','1','2'])->default('2');
            $table->enum('skillFooter', ['0','1','2'])->default('2');
            $table->enum('skillPage', ['0','1','2'])->default('2');
            $table->enum('skillTable', ['0','1','2'])->default('2');
            $table->enum('skillClip', ['0','1','2'])->default('2');
            $table->enum('skillWww', ['0','1','2'])->default('2');
            $table->enum('skillBr', ['0','1','2'])->default('2');
            $table->enum('skillDown', ['0','1','2'])->default('2');
            $table->enum('skillRef', ['0','1','2'])->default('2');
            $table->enum('skillCop', ['0','1','2'])->default('2');

            $table->enum('terms1', ['0','1'])->default('1');
            $table->enum('terms2', ['0','1'])->default('1');
            $table->enum('terms3', ['0','1'])->default('1');
            $table->enum('terms4', ['0','1'])->default('1');
            $table->enum('terms5', ['0','1'])->default('1');
            $table->enum('terms6', ['0','1'])->default('1');
            
            $table->ipAddress('visitor');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('enrollments');
    }
}
