<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSkipedusersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('skipedusers', function (Blueprint $table) {
            $table->id();
            $table->enum('agree', ['0','1'])->default('0');
            $table->enum('course', ['0','1', '2'])->default('0');
            $table->enum('visacopy', ['0','1'])->default('1');
            $table->enum('govIssue', ['0','1'])->default('1');
            $table->enum('usiOption', ['0','1','2'])->default('0');
            $table->string('usi')->nullable();

            $table->enum('year18', ['0','1'])->default('1');
            $table->enum('interStudent', ['0','1'])->default('1');
            $table->enum('unpaid', ['0','1'])->default('1');
            $table->enum('lln', ['0','1'])->default('1');
            $table->enum('declaration', ['0','1'])->default('1');
            $table->string('declarationName');
            $table->string('dateOfSubmitted');

            $table->enum('titleName', ['Mr','Mrs','Miss','Other'])->default('Mr');
            $table->string('giveName');
            $table->string('middleName')->nullable();
            $table->string('surName')->nullable();
            $table->string('preferredName')->nullable();
            $table->string('dob');
            $table->string('pob');
            $table->enum('gender', ['Male', 'Female', 'Other']);
            $table->string('mobile');
            $table->string('workPhone')->nullable();
            $table->string('homePhone')->nullable();
            $table->string('whatsApp')->nullable();
            $table->string('email')->unique();

            $table->string('eName');
            $table->string('eRelationship');
            $table->string('eMobile');
            $table->string('eEmail')->nullable();

            $table->string('buildingName')->nullable();
            $table->string('flatNo')->nullable();
            $table->string('streetNo')->nullable();
            $table->string('streetName')->nullable();
            $table->string('suburb')->nullable();
            $table->string('state')->nullable();
            $table->bigInteger('postCode')->nullable();

            $table->enum('sameAddress', ['0','1'])->default('1');
            
            $table->string('mailBuildingName')->nullable();
            $table->string('mailFlatNo')->nullable();
            $table->string('mailStreetNo')->nullable();
            $table->string('mailStreetName')->nullable();
            $table->string('mailSuburb')->nullable();
            $table->string('mailState')->nullable();
            $table->integer('mailPostCode')->nullable();
            $table->string('mailPoBox')->nullable();


            $table->enum('englishWell', ['0','1','2','3'])->default('0');
            $table->enum('language', ['Y','N'])->default('Y');
            $table->string('otherlanguage')->nullable();
            $table->bigInteger('country_id')->nullable();
            $table->enum('citizenStatus', ['Y','N'])->default('Y');
            $table->enum('prStatus', ['Y','N'])->default('Y');
            $table->bigInteger('visa_id')->nullable();
            $table->enum('disability', ['Y','N'])->default('Y');


            $table->enum('hearing', ['0','1'])->default('0');
            $table->enum('learing', ['0','1'])->default('0');
            $table->enum('physical', ['0','1'])->default('0');
            $table->enum('intellectual', ['0','1'])->default('0');
            $table->enum('vision', ['0','1'])->default('0');
            $table->enum('medical', ['0','1'])->default('0');
            $table->enum('otherDisability', ['0','1'])->default('0');
            $table->string('disabilityProblemOther')->nullable();

            $table->ipAddress('visitor');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('skipedusers');
    }
}
