<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


class CreatePaymentResponseTable extends Migration
{
    /**
     * Run the migrations.
     * "PaymentReference" => "ONE/00001"
     * @return void
     */
    public function up()
    {
        Schema::create('payment_responses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('enrollment_id')->index();//PaymentReference
            $table->string('PaymentReference');
            $table->string('ScheduledAmount');
            $table->string('BillerID');
            $table->string('PaymentAmount');
            $table->string('MobilePhoneNumber');
            $table->string('EmailAddress');
            $table->string('TransactionID');
            $table->string('ResultText');
            $table->string('BankReceiptID');
            $table->string('NameOnCard');
            $table->string('TransactionFeeCustomer');
            $table->string('ResultCode');
            $table->foreign('enrollment_id')->references('id')->on('enrollments');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_responses');
    }
}
