@extends('layouts.admin')
@section('content')
<! -- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Enroll User List</h6>
        </div>
        <div class="card-body">
            <div class="col-md-12">
                <table class="table table-bordered col-md-12" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th >Course</th>
                            <th >Name</th>
                            <th >Email</th>
                            <th >Phone</th>
                            <th >Date of Birth</th>
                            <th >Payment Reference</th>
                            <th >IP Address</th>
                            <th  style="width:280px; text-align: right; vertical-align: middle;">HTR / PMT / View / Print / Delete</th>
                        </tr>

                    </thead>
                   
                    <tbody>
                        @foreach($enrollUsersList as $enrollUser)
                        <tr>
                            <td style="text-align: center; vertical-align: middle;">
                                @if($enrollUser->course == "0") {{"AHC"}}
                                @elseif($enrollUser->course == "1") {{"D"}}
                                @else {{"AHCD"}}
                                @endif
                            </td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->giveName}}</td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->email}}</td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->mobile}}</td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->dob}}</td>
                            <td style="text-align: center; vertical-align: middle;">
                                <?php if(!empty($enrollUser->payments[0]) && $enrollUser->payments[0]->ResultCode == "00") {
                                        echo $enrollUser->payments[0]->PaymentReference."/".$enrollUser->payments[0]->TransactionID; }
                                     ?>
                            </td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->visitor}}</td>
                            <td style="text-align: right; vertical-align: middle;">
                                <a href="/enrollusers/paymentdetails/{{$enrollUser->id}}"
                                    class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                                    <i class="fa fa-dollar-sign"></i>&nbsp;<i class="fa fa-eye"></i></a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="/enrollusers/generatelink/{{$enrollUser->id}}"
                                    class="d-none d-sm-inline-block btn btn-sm btn-warning shadow-sm">
                                    <i class="fa fa-dollar-sign"></i></a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="/enrollusers/moredetails/{{$enrollUser->id}}"
                                    class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm">
                                    <i class="fa fa-edit"></i></a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="/enrollusers/generatepdf/{{$enrollUser->id}}"
                                    class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
                                    <i class="fa fa-print"></i></a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="/enrollusers/delete/{{$enrollUser->id}}" onclick="return confirm(' Are you sure to delete?');"
                                    class="d-none d-sm-inline-block btn btn-sm btn-danger shadow-sm">
                                    <i class="fa fa-trash-alt"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        </div>
        @endsection

        @section('javascript')
    <!-- Page level plugins -->
    <script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <!-- Page level custom scripts -->
    <script src="{{ asset('js/demo/datatables-demo.js') }}"></script>
    <script src="{{asset('js/datepicker.js')}}"></script>
    
@endsection