@extends('layouts.admin')



@section('content')
<! -- DataTales Example -->

    <div class="container">


        <form action="/enrollment/update" method="post" id="regForm">
            @csrf
            <input type="hidden" name="id" value="{{$enrollment->id}}" class="form-control" />
     

    <div class="tab">
        <div class="col-md-12">
            <h2 class="title" style="font-weight:bold; text-align:center;">Enroll Online</h2>

            <h3><b>INSTRUCTIONS</b></h3>
            <table class="table table-striped table-bordered">
                <tr>
                    <td>
                        <p>The Application Form must be filled accurately.
                            Candidates can face delay for any incorrect or incomplete
                            information. After submiting the form the candidate will receieve an
                            acknowledgement which will be followed up within 2 working days. We highly
                            recommended to read the student handbook before applying any course, The
                            student hand book is available on the official website of Hope Training
                            College of Australia,
                            <a href="http://www.hope.edu.au" target="_blank">www.hope.edu.au</a>
                            for the
                            course details.
                        </p>
                    </td>
                </tr>

            </table>
        </div>
        <div class="col-md-12">
            <h3>I AM ENROLLING IN: <span class="required">*</span></h3>
            <table class="table table-striped table-bordered">
                <tr class="courses">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="radio" <?php if($enrollment->course == "0") echo "checked"; ?> class="course"
                            name="course" value="0" id="cageing" />
                    </td>
                    <td>CHC33015 CERTIFICATE III IN INDIVIDUAL SUPPORT ( AGEING + HOME & COMMUNITY )
                    </td>
                </tr>
                <tr class="courses">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="radio" <?php if($enrollment->course == "1") echo "checked"; ?> class="course"
                            name="course" value="1" id="cdisability" />
                    </td>
                    <td>CHC33015 CERTIFICATE III IN INDIVIDUAL SUPPORT ( DISABILITY )</td>
                </tr>
                <tr class="courses">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="radio" <?php if($enrollment->course == "2") echo "checked"; ?> class="course"
                            name="course" value="2" id="cdishome" />
                    </td>
                    <td>CHC33015 CERTIFICATE III IN INDIVIDUAL SUPPORT ( AGEING + HOME & COMMUNITY +
                        DISABILITY )</td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <h4>BEFORE YOU APPLY </h4>
            <p>Make sure you read Pre – Enrolment information in the Student Handbook. To avoid
                delays, please ensure that you have provided all required information with your
                application. Incomplete applications may not be considered. Even if you submit your
                application via email, you are still required to provide a signed application form
                and valid evidence. </p>
        </div>
        <div class="col-md-12">
            <h3>REQUIRED DOCUMENTS CHECKLIST: <span class="required">*</span></h3>
            <table class="table table-striped table-bordered">
                <tr id="visacopytr">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" class="visacopy"
                            <?php if($enrollment->visacopy == "1") echo "checked"; ?> name="visacopy" value="1"
                            id="visacopy" />
                    </td>
                    <td>Proof of Residency/Visa Status (if not born in Australia) e.g. Visa Copy,
                        Medicare Card etc.</td>
                </tr>
                <tr id="govissuetr">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" class="govissue"
                            <?php if($enrollment->govIssue == "1") echo "checked"; ?> name="govIssue" value="1"
                            id="govissue" />
                    </td>
                    <td>A government issued nation photo ID e.g. Passport, DL etc.</td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <h3>UNIQUE STUDENT IDENTIFIER (USI): <span class="required">*</span></h3>
            <p> Completing any vocational education course in Australia, it is a requirement for the
                student to obtain and supply a USI. This is obtainable from www.usi.gov.au if a USI
                is not supplied and verified with usi.gov.au a certificate cannot be issued to the
                student. </p>
            <table class="table table-striped table-bordered">
                <tr class="usis">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="radio" <?php if($enrollment->usiOption == "0") echo "checked"; ?> class="usi"
                            id="haveUsi" name="usiOption" value="0" />
                    </td>
                    <td>I DO HAVE USI.</td>
                </tr>
                <tr class="usis">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="radio" <?php if($enrollment->usiOption == "1") echo "checked"; ?> class="usi"
                            id="applyOwn" name="usiOption" value="1" />
                    </td>
                    <td>I DO NOT HAVE USI and will apply my own and provide to HTCA.</td>
                </tr>
                <tr class="usis">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="radio" <?php if($enrollment->usiOption == "2") echo "checked"; ?> class="usi"
                            id="autoriesedToApply" name="usiOption" value="2" />
                    </td>
                    <td>I DO NOT HAVE USI and I give authority to HTCA to create an USI on behalf of
                        me.</td>
                </tr>
            </table>
            <div id="usiInput" {{ $enrollment->usiOption == "0" ? "" : "class=hidden"}}>
                <h4>Enter Unique Student Identifier(USI):</h4>
                <input class="form-control" type="text" id="usi" name="usi" max="10" value="{{$enrollment->usi}}"
                    placeholder="ABCDE12345 (Max 10 Char)" />
            </div>
        </div>
        <div class="col-md-12">&nbsp;</div>
    </div>
    <div class="tab">

        <div class="col-md-12">
            <h3>PRE-ENROLMENT QUESTION SECTION </h3>
            <p> Eligibility for entry into courses at Hope Training College of Australia
                requires demonstration, by prospective candidates, of their ability to
                understand entry requirements, prerequisites of Training Plan and the potential
                ability to achieve the competencies stipulated in the training package. Hope
                Training College of Australia uses the candidate’s responses to the questions in
                this application form to perform the eligibility assessment. Further information may
                be required
                by telephone interview, written or computer based assessment or face-to-face
                interview.
            </p>
            <p>Hope Training College of Australia is also obliged to assess whether the course
                for which candidates are applying is suitable to satisfy the candidate’s
                training needs and will assist them with their vocational objectives. Candidates
                should also declare any other learning needs they may have that will assist Hope
                Training College of Australia to provide the best possible training outcomes.
            </p>
        </div>

        <div class="col-md-12">
            <h3>PRE-ENROLMENT QUESTIONS <span class="required">*</span></h3>
            <table class="table table-striped table-bordered">
                <tr id="year18tr">
                    <td style="text-align: center; vertical-align: middle;">1</td>
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" id="year18" name="year18" value="1"
                            <?php if($enrollment->year18 == "1") echo "checked"; ?> />
                    </td>
                    <td> I am 18 or over 18 years old and will provide evidence of my age.</td>
                </tr>
                <tr id="interstudenttr">
                    <td style="text-align: center; vertical-align: middle;">2</td>
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" id="interstudent" name="interStudent" value="1"
                            <?php if($enrollment->interStudent == "1") echo "checked"; ?> />
                    </td>
                    <td>I am not main applicant of international student visa (Sub Class 500).</td>
                </tr>
                <tr id="unpaidtr">
                    <td style="text-align: center; vertical-align: middle;">3</td>
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" id="unpaid" name="unpaid" value="1"
                            <?php if($enrollment->unpaid == "1") echo "checked"; ?> />
                    </td>
                    <td>I understand that to complete listed course/s, I require to spend 120 or
                        more hours on Work placement, which is unpaid work to get experience in real
                        environment.</td>
                </tr>
                <tr class="llntr">
                    <td style="text-align: center; vertical-align: middle;">4A</td>
                    <td style="text-align: center; vertical-align: middle;">
                        <input class="llt" type="radio" id="languageliter" name="lln" value="0"
                            <?php if($enrollment->lln == "0") echo "checked"; ?> />
                    </td>
                    <td>I understand that Language Literacy and Numeracy (LLN) test is required for
                        entry in to listed course/s.</td>
                </tr>
                <tr>
                    <td colspan="3" style="text-align: center; vertical-align: middle;">
                        <strong>OR</strong>
                    </td>
                </tr>
                <tr class="llntr">
                    <td style="text-align: center; vertical-align: middle;">4B</td>
                    <td style="text-align: center; vertical-align: middle;">
                        <input class="llt" type="radio" id="higherqualification" name="lln" value="1"
                            <?php if($enrollment->lln == "1") echo "checked"; ?> />
                    </td>
                    <td>Equal or Higher qualification from Any Australian Institute and I will
                        provide evidence of achieved qualification. Please sign the declaration at
                        the end of this document. Information contained in this document must be
                        your personal responses. You must not solicit help or accept assistance from
                        another person.</td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <h3>ENROLLING STUDENT DECLARATION OF UNDERSTANDING <span class="required">*</span></h3>
            <table class="table table-striped table-bordered">
                <tr id="understandtr">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" id="understand" value="1" name="declaration"
                            <?php if($enrollment->declaration == "1") echo "checked"; ?> />
                    </td>
                    <td>I understand that: <span class="required">*</span></td>
                </tr>

                <tr>

                    <td colspan="2">
                        <p>Hope Training College of Australia is required to provide to the
                            Government through the relevant Department, student and training
                            activity data which may include information I provide in the
                            enrolment form. Information is required to be provided in accordance
                            with the Australian Skills Quality Authority (www.asqa.gov.au -
                            Activity Data Collection). The Department may use the information
                            provided to it for planning, administration, policy development,
                            program evaluation, resource allocation, and reporting and / or
                            research activities. For these and other lawful purposes, the
                            Department may also disclose information to its consultants,
                            advisers, other government agencies, professional bodies and / or
                            other organisations. I may be contacted and requested to participate
                            in a National Centre for Vocational Education Research Survey or a
                            Department endorsed project or audit or review. I also, understand and
                            accept that by submiting an online application will collect my location
                            and IP address
                            as digital signature for authentication. For further
                            information in relation to how student information may be used or
                            disclosed, please contact CEO Hope Training College of Australia on
                            phone (1300 464673). </p>
                        </p>
                    </td>
                </tr>
            </table>
            <table class="table table-striped table-bordered">
                <tr>
                    <th colspan="4">ENROLLING STUDENT DECLARATION OF UNDERSTANDING </th>
                </tr>
                <tr>
                    <td>Your Name <span class="required">*</span> </td>
                    <td>
                        <input type="text" id="declarationName" value="{{$enrollment->declarationName}}"
                            placeholder="Your Name" name="declarationName" class="form-control" />
                    </td>
                    <td>Date <span class="required">*</span> </td>
                    <td>

                        <div><input readonly id="dateofSubmit" type="text" name="dateOfSubmitted" 
                                value="{{$enrollment->dateOfSubmitted}}" class="form-control" />
                        </div>
                    </td>
                </tr>
            </table>
        </div>

    </div>
    <div class="tab">


        <div class="col-md-12">
            <div class="message hidden alert alert-danger" role="alert">&nbsp;</div>
            <table class="table table-striped table-bordered">
                <th colspan="4">1. PERSONAL DETAILS: </th>
                <tr>
                    <td colspan="2">Title <span class="required">*</span> </td>
                    <td colspan="2">
                        <input type="radio" id="mr" name="titleName" value="Mr"
                            <?php if($enrollment->titleName == "Mr") echo "checked"; ?> /> Mr
                        &nbsp;&nbsp;
                        <input type="radio" id="mrs" name="titleName" value="Mrs"
                            <?php if($enrollment->titleName == "Mrs") echo "checked"; ?> /> Mrs
                        &nbsp;&nbsp;
                        <input type="radio" id="miss" name="titleName" value="Miss"
                            <?php if($enrollment->titleName == "Miss") echo "checked"; ?> /> Miss
                        &nbsp;&nbsp;
                        <input type="radio" id="other" name="tititleNametle" value="Other"
                            <?php if($enrollment->titleName == "Other") echo "checked"; ?> /> Other
                    </td>
                </tr>
                <tr>
                    <td width="25%">GIVEN NAME: <span class="required">*</span></td>
                    <td width="25%"><input type="text" id="giveName" name="giveName" value="{{$enrollment->giveName}}"
                            class="form-control" /> </td>
                    <td width="25%">MIDDLE NAME </td>
                    <td width="25%"><input type="text" id="middleName" name="middleName"
                            value="{{$enrollment->middleName}}" class="form-control" /> </td>
                </tr>
                <tr>
                    <td colspan="2"> SURNAME/FAMILY NAME/LAST NAME: </td>
                    <td colspan="2"><input type="text" id="surName" name="surName" value="{{$enrollment->surName}}"
                            class="form-control" /> </td>
                </tr>
                <td>PREFERED NAME: </td>
                <td><input type="text" id="preferredName" name="preferredName" class="form-control" /> </td>
                <td>DATE OF BIRTH <span class="required">*</span></td>
                <td>
                    <div id="datepickerdob"><input type="text" id="dob" name="dob" value="{{$enrollment->dob}}"
                            class="form-control" /></div>
                </td>
                </tr>
                <tr>
                    <td colspan="2">PLACE OF BIRTH <b>(as on your passport or birth certificate)</b>
                        <span class="required">*</span>
                    </td>
                    <td colspan="2"><input type="text" id="pob" name="pob" value="{{$enrollment->pob}}"
                            class="form-control" /> </td>
                </tr>
                <tr>
                    <td colspan="2">GENDER <span class="required">*</span></td>
                    <td colspan="2">
                        <input type="radio" id="fe" name="gender" value="Male"
                            <?php if($enrollment->gender == "Male") echo "checked"; ?> /> Male
                        &nbsp;&nbsp;
                        <input type="radio" id="ma" name="gender" value="Female"
                            <?php if($enrollment->gender == "Female") echo "checked"; ?> /> Female
                        &nbsp;&nbsp;
                        <input type="radio" id="oth" name="gender" value="Other"
                            <?php if($enrollment->titleNgenderame == "Other") echo "checked"; ?> />
                        Other
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="4">2. CONTACT DETAILS:</th>
                <tr>
                    <td width="25%">MOBILE NO. <span class="required">*</span></td>
                    <td width="25%"><input type="text" id="mobile" class="form-control" value="{{$enrollment->mobile}}"
                            name="mobile" /> </td>
                    <td width="25%">WORK PHONE NO. </td>
                    <td width="25%"><input type="text" id="workPhone" class="form-control"
                            value="{{$enrollment->workPhone}}" name="workPhone" /> </td>
                </tr>
                <tr>
                    <td>HOME PHONE NO. </td>
                    <td><input type="text" id="hphoneno" class="form-control" value="{{$enrollment->homePhone}}"
                            name="homePhone" /> </td>
                    <td>WhatsApp Number (if any) </td>
                    <td><input type="text" id="whatsapp" class="form-control" value="{{$enrollment->whatsApp}}"
                            name="whatsApp" /> </td>
                </tr>
                <tr>
                    <td>EMAIL ID. <span class="required">*</span></td>
                    <td colspan="3"><input type="text" id="email" class="form-control" value="{{$enrollment->email}}"
                            name="email" /> </td>
                </tr>
            </table>
        </div>

        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="4">3. EMERGENCY CONTACT DETAILS: </th>
                <tr>
                    <td width="25%">NAME: <span class="required">*</span></td>
                    <td width="25%"><input type="text" id="eName" class="form-control" value="{{$enrollment->eName}}"
                            name="eName" /> </td>
                    <td width="25%">RELATIONSHIP WITH YOU <span class="required">*</span></td>
                    <td width="25%"><input type="text" id="eRelationship" class="form-control"
                            value="{{$enrollment->eRelationship}}" name="eRelationship" /> </td>
                </tr>
                <tr>
                    <td>MOBILE NO. <span class="required">*</span></td>
                    <td><input type="text" id="eMobile" class="form-control" value="{{$enrollment->eMobile}}"
                            name="eMobile" /> </td>
                    <td>EMAIL: </td>
                    <td><input type="text" id="eEmail" class="form-control" value="{{$enrollment->eEmail}}"
                            name="eEmail" /> </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="6">4. CURRENT ADDRESS: </th>
                <tr>
                    <td colspan="2">BUILDING OR PROPERTY NAME </td>
                    <td colspan="4"><input type="text" id="buildingName" class="form-control"
                            value="{{$enrollment->buildingName}}" name="buildingName" />
                    </td>
                </tr>
                <tr>
                    <td>UNIT OR FLAT NO: </td>
                    <td><input type="text" id="flatNo" class="form-control" value="{{$enrollment->flatNo}}"
                            name="flatNo" /></td>
                    <td>STREET NO.: <span class="required">*</span></td>
                    <td><input type="text" id="streetNo" class="form-control" value="{{$enrollment->streetNo}}"
                            name="streetNo" /> </td>
                    <td>STREET NAME: <span class="required">*</span></td>
                    <td><input type="text" id="streetName" class="form-control" value="{{$enrollment->streetName}}"
                            name="streetName" /> </td>

                </tr>
                <tr>
                    <td>SUBURB <span class="required">*</span></td>
                    <td><input type="text" id="suburb" class="form-control" value="{{$enrollment->suburb}}"
                            name="suburb" /> </td>
                    <td>STATE: <span class="required">*</span></td>
                    <td><input type="text" id="state" class="form-control" value="{{$enrollment->state}}"
                            name="state" /> </td>
                    <td>POST CODE: <span class="required">*</span></td>
                    <td><input type="text" id="postCode" class="form-control" value="{{$enrollment->postCode}}"
                            name="postCode" /> </td>
                </tr>

            </table>
        </div>

        <div class="col-md-12">
            <table class="table table-striped table-bordered">

                <th colspan="6"> 5. MAILING ADDRESS (COMPLETE IF DIFFERENT FROM CURRENT ADDRESS OR
                    GO TO NEXT QUESTION) </th>
                <tr>
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" id="sameAddress" value="1"
                            <?php if($enrollment->sameAddress == "1") echo "checked"; ?> name="sameAddress"
                            style="text-align: center; vertical-align: middle;" />
                    </td>
                    <td colspan="5">Select If Current and Mailing Address is same.</td>
                </tr>
                <tr>
                    <td colspan="2">MAIL BOX :</td>
                    <td colspan="4"><input type="text" id="mailBuildingName" class="form-control"
                            value="{{$enrollment->mailBuildingName}}" name="mailBuildingName" /></td>
                </tr>
                <tr>
                    <td>UNIT OR FLAT NO: </td>
                    <td><input type="text" id="mailFlatNo" class="form-control" value="{{$enrollment->mailFlatNo}}"
                            name="mailFlatNo" /></td>
                    <td>STREET NO.: <span class="required">*</span></td>
                    <td><input type="text" id="mailStreetNo" class="form-control" value="{{$enrollment->mailStreetNo}}"
                            name="mailStreetNo" /> </td>
                    <td>STREET NAME: <span class="required">*</span></td>
                    <td><input type="text" id="mailStreetName" class="form-control"
                            value="{{$enrollment->mailStreetName}}" name="mailStreetName" /> </td>

                </tr>
                <tr>
                    <td>SUBURB <span class="required">*</span></td>
                    <td><input type="text" id="mailSuburb" class="form-control" value="{{$enrollment->mailSuburb}}"
                            name="mailSuburb" /> </td>
                    <td>STATE: <span class="required">*</span></td>
                    <td><input type="text" id="mailState" class="form-control" value="{{$enrollment->mailState}}"
                            name="mailState" /> </td>
                    <td>POST CODE: <span class="required">*</span></td>
                    <td><input type="text" id="mailPostCode" class="form-control" value="{{$enrollment->mailPostCode}}"
                            name="mailPostCode" /> </td>
                </tr>
                <tr>
                    <td colspan="2">POST OFFICE BOX: </td>
                    <td colspan="4"><input type="text" id="mailPoBox" class="form-control"
                            value="{{$enrollment->mailPoBox}}" name="mailPoBox" /> </td>
                </tr>
            </table>
        </div>


    </div>
    <div class="tab">

        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="2"> 6. CULTURAL DIVERSITY </th>
                <tr>
                    <td> IN WHICH COUNTRY WERE YOU BORN? </td>
                    <td>
                        <select name="country_id" id="country" class="form-control">


                            <option value="">Select Country Category</option>
                            @foreach($countries As $country)
                            <option {{ $enrollment->country_id == $country->id ? 'selected' : ""}}
                                value="{{$country->id}}">{{$country->country_name}}</option>
                            @endforeach
                        </select>
                    </td>
                </tr>
                <tr id="citizenStatus">
                    <td> ARE YOU AN AUSTRALIAN CITIZEN ? </td>
                    <td>
                        <input type="radio" name="citizenStatus"
                            <?php if($enrollment->citizenStatus == "Y") echo "checked"; ?> value="Y"
                            id="yesaustralian" /> YES &nbsp;&nbsp;&nbsp;
                        <input type="radio" name="citizenStatus"
                            <?php if($enrollment->citizenStatus == "N") echo "checked"; ?> value="N"
                            id="noaustralian" /> NO
                    </td>
                </tr>
            </table>



            <div id="citizenStatusOtherTextBox" {{ $enrollment->citizenStatus == "N" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr id="prStatus">
                        <td> ARE YOU PERMANENT RESIDENT OF AUSTRALIA? </td>
                        <td>
                            <input type="radio" name="prStatus" value="Y"
                                <?php if($enrollment->prStatus == "Y") echo "checked"; ?> id="yespr" /> YES
                            &nbsp;&nbsp;&nbsp;
                            <input type="radio" name="prStatus" value="N"
                                <?php if($enrollment->prStatus == "N") echo "checked"; ?> id="nopr" /> NO
                        </td>
                    </tr>

                </table>
            </div>


            <div id="prStatusTextBox" {{ $enrollment->prStatus == "N" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">

                    <tr>
                        <td> WHICH VISA YOU ARE HOLDING? </td>
                        <td>

                            <select name="visa_id" id="visaHolding" class="form-control">
                                <option value="">Select Your Visa</option>
                                @foreach($visas As $visa)
                                <option {{ $enrollment->visa_id == $visa->id ? 'selected' : ""}} value="{{$visa->id}}">
                                    {{$visa->name}}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th> 7. SUPPORT SERVICE </th>
                <tr>
                    <td> DO YOU IDENTIFY YOURSELF AS HAVING DISABILITY? &nbsp;&nbsp;
                        <input type="radio" name="disability"
                            <?php if($enrollment->disability == "Y") echo "checked"; ?> value="Y" id="vwel" /> YES
                        &nbsp;&nbsp;&nbsp;
                        <input type="radio" name="disability"
                            <?php if($enrollment->disability == "N") echo "checked"; ?> value="N" id="wel" /> NO
                        &nbsp;&nbsp;&nbsp;
                    </td>
                </tr>


            </table>


            <div id="disabilityStatusYes" {{ $enrollment->disability == "Y" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr class="disabilityProblemtr">
                        <td>
                            <input type="checkbox" name="hearing" value="1"
                                <?php if($enrollment->hearing == "1") echo "checked"; ?> class="disabilityProblem"
                                id="deaf" />&nbsp;
                            YES-HEARING/DEAF&nbsp;&nbsp;&nbsp;
                        </td>
                        <td>
                            <input type="checkbox" name="learing" value="1"
                                <?php if($enrollment->learing == "1") echo "checked"; ?> class="disabilityProblem"
                                id="learning" />&nbsp;
                            YES-LEARNING&nbsp;&nbsp;&nbsp;
                        </td>
                        <td>
                            <input type="checkbox" name="physical" value="1"
                                <?php if($enrollment->physical == "1") echo "checked"; ?> class="disabilityProblem"
                                id="physical" />&nbsp; YES-PHYSICAL
                        </td>
                    </tr>
                    <tr class="disabilityProblemtr">
                        <td>
                            <input type="checkbox" name="intellectual"
                                <?php if($enrollment->intellectual == "1") echo "checked"; ?> value="1"
                                class="disabilityProblem" id="intell" />&nbsp; YES-INTELLECTUAL
                        </td>
                        <td>
                            <input type="checkbox" name="vision" <?php if($enrollment->vision == "1") echo "checked"; ?>
                                value="1" class="disabilityProblem" id="vision" />&nbsp; YES-VISION
                        </td>
                        <td>
                            <input type="checkbox" name="medical"
                                <?php if($enrollment->medical == "1") echo "checked"; ?> value="1"
                                class="disabilityProblem" id="medical" />&nbsp;
                            YES-MEDICAL
                        </td>
                    </tr>
                    <tr class="disabilityProblemtr">
                        <td colspan="3">
                            <input type="checkbox" name="otherDisability"
                                <?php if($enrollment->otherDisability == "1") echo "checked"; ?> value="1"
                                class="disabilityProblem" id="otherdis" />&nbsp; YES-OTHER
                        </td>
                    </tr>
                </table>
                <table class="table table-striped table-bordered">
                    <tr>
                        <td> PLEASE PROVIDE MORE DETAIL AND HOW THE COLLEGE CAN HELP YOU IN REGARDS OF YOUR
                            SPECIAL NEEDS ? </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="text" class="form-control" id="disabilityProblemOther"
                                value="{{$enrollment->disabilityProblemOther}}" name="disabilityProblemOther" />
                        </td>
                    </tr>
                </table>
            </div>

        </div>

        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="2"> 8. ENGLISH LANGUAGE PROFICIENCY LEVEL </th>

                <tr>
                    <td> DO YOU SPEAK LANGUAGE OTHER THAN ENGLISH AT HOME </td>
                    <td>
                        <input type="radio" name="language" id="languageYes"
                            <?php if($enrollment->language == "Y") echo "checked"; ?> value="Y" /> Yes
                        &nbsp;&nbsp;&nbsp;
                        <input type="radio" name="language" id="languageNo"
                            <?php if($enrollment->language == "N") echo "checked"; ?> value="N" /> No
                </tr>

                <tr>
                    <td colspan="2">
                        <div id="languageOtherTextBox" {{ $enrollment->language == "Y" ? "" : "class=hidden"}}>
                            <table class="table table-striped table-bordered">
                                <tr>
                                    <td>IF SELECTED "YES" THEN WHICH LANGUAGE? <span class="required">*</span> </td>
                                </tr>
                                <tr>
                                    <td>
                                        <input class="form-control" type="text" id="otherlanguage" name="otherlanguage"
                                            value="{{$enrollment->otherlanguage}}" value="NO" max="10" />
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>

                </tr>


                <tr>
                    <td> HOW WELL DO YOU SPEAK ENGLISH? </td>
                    <td>
                        <input type="radio" name="englishWell" id="vwel"
                            <?php if($enrollment->englishWell == "0") echo "checked"; ?> value="0" />
                        VERY WELL &nbsp;&nbsp;&nbsp;
                        <input type="radio" name="englishWell" id="wel"
                            <?php if($enrollment->englishWell == "1") echo "checked"; ?> value="1" />
                        WELL &nbsp;&nbsp;&nbsp;
                        <input type="radio" name="englishWell" id="notwel"
                            <?php if($enrollment->englishWell == "2") echo "checked"; ?> value="2" />
                        NOT WELL &nbsp;&nbsp;&nbsp;
                        <input type="radio" name="englishWell" id="notall"
                            <?php if($enrollment->englishWell == "3") echo "checked"; ?> value="3" />
                        NOT AT ALL
                    </td>
                </tr>



            </table>
        </div>


    </div>
    <div class="tab">



        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th> 9. SCHOOL LEVEL EDUCATIONAL BACKGROUND: </th>
                <tr>
                    <td> WHAT IS YOUR HIGHEST COMPLETED SCHOOL LEVEL? </td>
                </tr>
                <tr>
                    <td>
                        <select name="schoolEducation" id="schoolEducation" class="form-control">
                            <option value="">Select School Education Level</option>
                            @foreach($schoolEducation As $id => $schoolEdu)
                            <option {{ $enrollment->schoolEducation == $id ? 'selected' : ""}} value="{{$id}}">
                                {{$schoolEdu}}</option>
                            @endforeach
                        </select>
                    </td>
                </tr>
                <tr>
                    <td> WHEN DID YOU COMPLETE SCHOOL? (YEAR) </td>
                </tr>
                <tr>
                    <td>
                        <div id="datepickerysc"><input type="text" id="ysc" name="ysc" value="{{$enrollment->ysc}}"
                                class="form-control" /></div>
                    </td>
                    <!--YEAR COLLANDER-->
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th> 10. HIGHER LEVEL EDUCATION BACKGROUND: </th>
                <tr>
                    <td> AUSTRALIAN QUALIFICATION &nbsp;&nbsp;
                        <input type="radio" name="austrianEduQualification"
                            <?php if($enrollment->austrianEduQualification == "Y") echo "checked"; ?> value="Y"
                            id="vwel" /> YES &nbsp;&nbsp;&nbsp;
                        <input type="radio" name="austrianEduQualification"
                            <?php if($enrollment->austrianEduQualification == "N") echo "checked"; ?> value="N"
                            id="wel" /> NO &nbsp;&nbsp;&nbsp;
                    </td>
                    </td>
                </tr>
            </table>


            <div id="austrianEduQualificationTextBox"
                {{ $enrollment->austrianEduQualification == "Y" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr>
                        <td> IF YOU SELECTED “YES” </td>
                    </tr>
                    <tr>
                        <td>
                            <select name="higherEducation" id="higherEducation" class="form-control">
                                <option value="">Select Higher Education Level
                                    {{$enrollment->higherEducation}}</option>
                                @foreach($higherEducation As $id => $higherEdu)
                                <option {{ $enrollment->higherEducation == $id ? 'selected' : ""}} value="{{$id}}">
                                    {{$higherEdu}}</option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="otherEduQualificationTextBox"
                {{ $enrollment->austrianEduQualification == "N" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr>
                        <td> NON-AUSTRALIAN QUALIFICATION </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="text" id="otherEduQualification" value="{{$enrollment->otherEduQualification}}"
                                name="otherEduQualification" class="form-control" />
                        </td>
                    </tr>
                </table>

            </div>
        </div>



        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="2"> 11. RECOGNITION PROCESSES </th>
                <tr id="firstTime">
                    <td> IS THIS FIRST TIME YOU HAVE ENROLLED AT HOPE TRAINING COLLEGE OF AUSTRALIA </td>
                    <td>
                        <input type="radio" name="firstTime" value="Y"
                            <?php if($enrollment->firstTime == "Y") echo "checked"; ?> id="yesfirst" />&nbsp;
                        YES&nbsp;&nbsp;&nbsp;
                        <input type="radio" name="firstTime" value="N"
                            <?php if($enrollment->firstTime == "N") echo "checked"; ?> id="nofirst" />&nbsp;
                        NO
                    </td>
                </tr>
                <tr id="rpl">
                    <td> ARE YOU APPLYING FOR RECOGNITION OF PRIOR LEARNING (RPL) </td>
                    <td>
                        <input type="radio" name="rpl" value="Y" id="yesrpl"
                            <?php if($enrollment->rpl == "Y") echo "checked"; ?> />&nbsp;
                        YES&nbsp;&nbsp;&nbsp;
                        <input type="radio" name="rpl" value="N" id="norpl"
                            <?php if($enrollment->rpl == "N") echo "checked"; ?> />&nbsp; NO
                    </td>
                </tr>
                <tr id="ct">
                    <td> ARE YOU APPLYING FOR CREDIT TRANSFER(CT) FOR ANY UNIT/S </td>
                    <td>
                        <input type="radio" name="ct" value="Y" id="yesunit"
                            <?php if($enrollment->ct == "Y") echo "checked"; ?> />&nbsp;
                        YES&nbsp;&nbsp;&nbsp;
                        <input type="radio" name="ct" value="N" id="nounit"
                            <?php if($enrollment->ct == "N") echo "checked"; ?> />&nbsp; NO
                    </td>
                </tr>
            </table>
            <div id="yesTransferTextBox" {{ $enrollment->ct == "Y" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr>
                        <td> IF YES THEN PROVIDE DETAIL OF UNIT/S YOU ARE APPLYING FOR CREDIT TRANSFER </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="text" id="yesTransfer" name="yesTransfer" class="form-control"
                                value="{{$enrollment->yesTransfer}}" />
                        </td>
                        <!--if ct = yes enable it otherwise disable-->
                    </tr>
                </table>
            </div>
        </div>


    </div>
    <div class="tab">


        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="3"> 12. CURRENT EMPLOYMENT STATUS (SELECT ONE WHICH DISCRIBE YOU) </th>
                <tr class="currentEmpStatus">
                    <td><input type="radio" id="fulltime" value="fulltime"
                            <?php if($enrollment->currentEmpStatus == "fulltime") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; FULL TIME EMPLOYEE </td>
                    <td><input type="radio" id="parttime" value="parttime"
                            <?php if($enrollment->currentEmpStatus == "parttime") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; PART TIME EMPLOYEE</td>
                    <td><input type="radio" id="unemp" value="unemp"
                            <?php if($enrollment->currentEmpStatus == "unemp") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; UNEMPLOYED-SEEKING FULL TIME WORK </td>

                </tr>
                <tr class="currentEmpStatus">
                    <td><input type="radio" id="devbusiness" value="devbusiness"
                            <?php if($enrollment->currentEmpStatus == "devbusiness") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; UNEMPLOYED-SEEKING PART TIME WORK </td>
                    <td><input type="radio" id="notlookingforwork" value="notlookingforwork"
                            <?php if($enrollment->currentEmpStatus == "notlookingforwork") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; UNEMPLOYED-NOT LOOKING FOR WORK </td>
                    <td><input type="radio" id="unpaidfamily" value="unpaidfamily"
                            <?php if($enrollment->currentEmpStatus == "unpaidfamily") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; UNPAID FAMILY WORKER </td>

                </tr>
                <tr class="currentEmpStatus">
                    <td><input type="radio" id="anothercourse" value="anothercourse"
                            <?php if($enrollment->currentEmpStatus == "anothercourse") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; EMPLOYEER</td>
                    <td><input type="radio" id="selfemploye" value="selfemploye"
                            <?php if($enrollment->currentEmpStatus == "selfemploye") echo "checked"; ?>
                            name="currentEmpStatus" />&nbsp; SELF EMPLOYED</td>
                    <td>&nbsp;</td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="3"> 13. PURPOSE OF STUDY </th>
                <tr class="studyPurpose">
                    <td><input type="radio" id="getjob" value="getjob"
                            <?php if($enrollment->studyPurpose == "getjob") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; TO GET A JOB </td>
                    <td><input type="radio" id="diffrentcareer" value="diffrentcareer"
                            <?php if($enrollment->studyPurpose == "diffrentcareer") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; TO TRY DIFFERENT CAREER </td>
                    <td><input type="radio" id="extraskill" value="extraskill"
                            <?php if($enrollment->studyPurpose == "extraskill") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; I WANTED EXTRA SKILLS FOR MY JOB </td>
                </tr>
                <tr class="studyPurpose">
                    <td><input type="radio" id="developbusiness" value="developbusiness"
                            <?php if($enrollment->studyPurpose == "developbusiness") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; TO DEVELOP MY EXISTING BUSINESS</td>
                    <td><input type="radio" id="betterjob" value="betterjob"
                            <?php if($enrollment->studyPurpose == "betterjob") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; TO GET BETTER JOB OR PROMOTION</td>
                    <td><input type="radio" id="anothercourse" value="anothercourse"
                            <?php if($enrollment->studyPurpose == "anothercourse") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; TO GET INTO ANOTHER COURSE OR STUDY</td>
                </tr>
                <tr class="studyPurpose">
                    <td><input type="radio" id="ownbusiness" value="ownbusiness"
                            <?php if($enrollment->studyPurpose == "ownbusiness") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; TO START MY OWN BUSINESS</td>
                    <td><input type="radio" id="jobreq" value="jobreq"
                            <?php if($enrollment->studyPurpose == "jobreq") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; IT WAS REQUIREMENT OF MY JOB</td>
                    <td><input type="radio" id="othql" value="othql"
                            <?php if($enrollment->studyPurpose == "othql") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; FOR PERSONAL INTEREST OR SELF-DEVELOPMENT</td>
                </tr>
                <tr class="studyPurpose">
                    <td><input type="radio" id="otherrsn" value="otherrsn"
                            <?php if($enrollment->studyPurpose == "otherrsn") echo "checked"; ?>
                            name="studyPurpose" />&nbsp; OTHER REASON </td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>
            </table>
        </div>


    </div>
    <div class="tab">



        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th> 14. COURSE FEE & PAYMENT PLANS </th>
                <tr>
                    <td>
                        <p> Pricing for individuals registering for public courses will be at the published
                            rate in the Marketing Flyer /Information Flyer and on the website. </p>
                        <ul>
                            <li>The enrolment fee is non-refundable if offer letter signed and fee paid</li>
                            <li>Other special offers and discounts may be marketed from time to time</li>
                            <li>For fee breakdown please visit our fee section on www.hope.edu.au or
                                collect/download student handbook. </li>
                            <li>Our online learning resource are free </li>
                        </ul>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <tr>
                    <th> COURSE SPECIALISTION/S </th>
                    <th> ENROLMENT FEE </th>
                    <th> TUTION FEE </th>
                    <th> TOTAL FEE </th>
                </tr>
                <tr>
                    <td colspan="4"> CHC33015 CERTIFICATE III IN INDIVIDUAL SUPPORT: </td>
                </tr>
                <tr>
                    <td> AGEING + HOME & COMMUNITY </td>
                    <td> 250 AUD </td>
                    <td> 1200 AUD </td>
                    <td> 1450 AUD </td>
                </tr>
                <tr>
                    <td> DISABILITY </td>
                    <td> 250 AUD </td>
                    <td> 1200 AUD </td>
                    <td> 1450 AUD </td>
                </tr>
                <tr>
                    <td> AGEING + HOME & COMMUNITY + DISABILITY </td>
                    <td> 250 AUD </td>
                    <td> 1600 AUD* </td>
                    <td> 1850 AUD* </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="2"> PAYMENT PLAN OPTIONS: </th>
                <tr>
                    <td>
                        <h4><input type="radio" id="modeOfPayment" name="modeOfPayment"
                                <?php if($enrollment->modeOfPayment == "D") echo "checked"; ?> value="D" />
                            &nbsp;&nbsp;DIRECT DEBIT(EZI DEBIT) </h4>
                        <p> The course fee can be paid through direct debit options to avoid late fee
                            charges. The direct debit arrangement can be made directly by the college or
                            through third-party service providers, e.g. Ezi Debit. We are offering flexible
                            / customize payment plan as per student needs. For more detail please discuss
                            with our enrollment representative </p>
                    </td>
                    <td>
                        <h4><input type="radio" id="modeOfPayment" name="modeOfPayment"
                                <?php if($enrollment->currentEmpStatus == "M") echo "checked"; ?> value="M" />
                            &nbsp;&nbsp;PAYING MANUALLY </h4>
                        <p> We are encouraging to our students to set up a direct debit for their pending
                            fee before starting their course, But in some cases, if the student wants to pay
                            manually through EFTPOS or Cash can be arranged with fix payment dates. The
                            college will add a $15 late fee with every delayed payment </p>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered" id="tac">
                <th colspan="3"> TERMS OF PAYMENT: </th>
                <tr>
                    <td style="text-align: center; vertical-align: middle;"> I WILL PAY AMOUNT $ </td>
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="text" id="amount" class="form-control" name="amount" placeholder="IN AUD"
                            value="{{$enrollment->amount}}" />
                    </td>
                    <td id="uiPaymentTerms">
                        <ul style="list-style-type:none;">
                            <li><input type="radio" name="paymentTerms" id="paymentMonthly" value="M"
                                    <?php if($enrollment->paymentTerms == "M") echo "checked"; ?> />&nbsp;
                                MONTHLY</li>
                            <li><input type="radio" name="paymentTerms" id="paymentFort" value="F"
                                    <?php if($enrollment->paymentTerms == "F") echo "checked"; ?> />&nbsp;
                                FORTNIGHTLY </li>
                            <li><input type="radio" name="paymentTerms" id="paymentWeekly" value="W"
                                    <?php if($enrollment->paymentTerms == "W") echo "checked"; ?> />&nbsp;
                                WEEKLY </li>
                            <li><input type="radio" name="paymentTerms" id="paymentCustomized" value="C"
                                    <?php if($enrollment->paymentTerms == "C") echo "checked"; ?> /> OR
                                CUSTOMIZED DATE & AMOUNT</li>
                        </ul>
                    </td>
                </tr>

            </table>
        </div>
        <div class="col-md-12">
            <div id="paymentTermsCustomTextBox" {{ $enrollment->paymentTerms == "C" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr>
                        <td> PROVIDE DETAIL OF CUSTOMIZED PAYMENT DATE & AMOUNT </td>
                    </tr>
                    <tr>
                        <td>
                            <textarea id="paymentTermsCustom" name="paymentTermsCustom" rows="3" cols="50"
                                class="form-control">{{$enrollment->paymentTermsCustom}}</textarea>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="2"> COURSE / TUTION REFUND OPTIONS: </th>
                <tr>
                    <td> <b>SCENARIO</b> </td>
                    <td><b> REFUND(in % of total fee)</b> </td>
                </tr>
                <tr>
                    <td> Enrolment fee ($250) </td>
                    <td> Non – Refundable if offer of study accepted </td>
                </tr>
                <tr>
                    <td> Withdrawal within a week after enrolment </td>
                    <td> Full Tuition Fee will be refunded (Enrolment Fee will be not refunded) </td>
                </tr>
                <tr>
                    <td> Withdrawal after 1 week and before completion of 2 weeks from enrolment date </td>
                    <td> 90% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 2 weeks and before completion of 3 weeks from enrolment date </td>
                    <td> 80% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 3 weeks and before completion of 4 weeks from enrolment date </td>
                    <td> 70% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 4 weeks and before completion of 5 weeks from enrolment date </td>
                    <td> 60% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 5 weeks and before completion of 6 weeks from enrolment date </td>
                    <td> 50% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 6 weeks and before completion of 7 weeks from enrolment date </td>
                    <td> 40% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 7 weeks and before completion of 8 weeks from enrolment date </td>
                    <td> 30% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 8 weeks and before completion of 9 weeks from enrolment date </td>
                    <td> 20% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 9 weeks and before completion of 10 weeks from enrolment date
                    </td>
                    <td> 10% </td>
                </tr>
                <tr>
                    <td> Withdrawal after 10 weeks and before completion of 11 weeks from enrolment date
                    </td>
                    <td> 0% </td>
                </tr>
                <tr>
                    <td> If College stopped delivering a course because RTO sanction by regulatory
                        authorities </td>
                    <td> Full fee (Included Enrolment fee) will be refunded </td>
                </tr>
                <tr>
                    <td> RPL Application Fee </td>
                    <td> Non – refundable if offer accepted </td>
                </tr>
                <tr>
                    <td colspan="2"> Note: Refund request needs to be submit in written or by email. Request
                        time will be calculated based on time when request will be submitted. If refund
                        request received after hours by email that will be considered in next working day’s
                        request. For more details on refund policy, please refer to Student Handbook </td>
                </tr>
            </table>
        </div>

    </div>
    <div class="tab">

        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <tr>
                    <th> 15. CAREER PLAN </th>
                </tr>
                <tr>
                    <td> This section will help us to assess your writing skill included your career
                        plan,Please provide us detailed information, You can ask separate page if required.
                    </td>
                </tr>
                <tr>
                    <td> Q1. WHY DO YOU WANT TO STUDY THE PROPOSED COURSE/S ? (MINIMUM 50 WORDS MAX 100
                        WORDS) </td>
                </tr>
                <tr>
                    <td><textarea id="word_count" name="w3review" rows="8" class="form-control"
                            style="min-width: 100%">{{$enrollment->w3review}}</textarea>

                    </td>
                    <!--limit of words min 40 max 50-->
                </tr>
            </table>

            <table class="table table-striped table-bordered">
                <tr id="question2">
                    <td> Q2. DO YOU HAVE ANY EXPERIENCE IN THE RELATED FIELD ?
                        <input type="radio" id="exRelatedFeild" name="exRelatedFeild"
                            <?php if($enrollment->exRelatedFeild == "Y") echo "checked"; ?> value="Y" /> Yes
                        <input type="radio" id="exRelatedFeild" name="exRelatedFeild"
                            <?php if($enrollment->exRelatedFeild == "N") echo "checked"; ?> value="N" /> No
                    </td>
                </tr>

            </table>
            <div id="exRelatedFeildTextBox" {{ $enrollment->exRelatedFeild == "Y" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr>
                        <th>DESCRIBE</th>
                    </tr>
                    <tr>
                        <td><textarea id="detailExp" name="detailExp" rows="8" class="form-control"
                                style="min-width: 100%">{{$enrollment->detailExp}}</textarea>
                        </td>
                    </tr>
                </table>
            </div>
            <table class="table table-striped table-bordered">
                <tr>
                    <td> Q3. WHAT IS YOUR FUTURE CAREER GOALS? DESCRIBE HOW THE PROPOSED COURSE WILL HELP
                        YOU IN ACHIEVING YOUR CAREER GOALS ? </td>
                </tr>
                <tr>
                    <td><textarea id="goals" name="goals" rows="8" class="form-control"
                            style="min-width: 100%">{{$enrollment->goals}}</textarea>
                    </td>
                </tr>
                <tr>
                    <td> Q4. WHY DID YOU CHOOSE TO STUDY AT HOPE TRAINING COLLEGE OF AUSTRALIA ? </td>
                </tr>
                <tr>
                    <td><textarea id="whyChoose" name="whyChoose" rows="8" class="form-control"
                            style="min-width: 100%">{{$enrollment->whyChoose}}</textarea>
                    </td>
                </tr>
                <tr>
                    <td> Q5. FROM WHERE DID YOU HEARD ABOUT HOPE TRAINING COLLEGE OF AUSTRALIA ? </td>
                </tr>
                <tr>
                    <td>
                        <select name="referenceFrom" id="referenceFrom" class="form-control">
                        <option value="">Select Reference From</option>
                            @foreach($referenceFrom As $id => $referenceFr)
                            <option {{ $enrollment->referenceFrom == $id ? 'selected' : ""}} value="{{$id}}">
                                {{$referenceFr}}</option>
                            @endforeach
                        </select>
                        </textarea>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12">
            <div id="referenceFromCustomTextBox" {{ $enrollment->referenceFrom == "2" ? "" : "class=hidden"}}>
                <table class="table table-striped table-bordered">
                    <tr>
                        <td colspan="2"> PROVIDE DETAIL OF YOUR FRIEND WHO REFERRED US ? </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="text" id="refFrientName" class="form-control" name="refFrientName"
                                placeholder="Name of Friend" value="{{$enrollment->refFrientName}}" />
                        </td>
                        <td>
                            <input type="text" id="refFrientMobile" class="form-control" name="refFrientMobile"
                                placeholder="Mobile of Friend" value="{{$enrollment->refFrientMobile}}" />
                        </td>
                    </tr>
                </table>
            </div>
        </div>

    </div>
    <div class="tab">


        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <th colspan="4"> 16. COMPUTER/IT SKILL ASSESMENT </th>
                <tr>
                    <td colspan="4">Hope Training College of Australia delivers major part of study online.
                        Therefore, it is very important to provide your current level of knowledge regarding
                        use of computer. </td>
                </tr>
                <tr>
                    <td> MY SKILL LEVEL </td>
                    <td> NO EXPERIENCE </td>
                    <td> NEED SUPPORT </td>
                    <td> COMPETENT </td>
                </tr>

                <tr id="skillShut">
                    <td> I can start and shut down computer and related equipment e.g. printer etc </td>
                    <td><input type="radio" name="skillShut" value="0"
                            <?php if($enrollment->skillShut == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillShut" value="1"
                            <?php if($enrollment->skillShut == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillShut" value="2"
                            <?php if($enrollment->skillShut == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillUsb">
                    <td> I know how to use USB memory stick, CD memory disk. </td>
                    <td><input type="radio" name="skillUsb" value="0"
                            <?php if($enrollment->skillUsb == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillUsb" value="1"
                            <?php if($enrollment->skillUsb == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillUsb" value="2"
                            <?php if($enrollment->skillUsb == "2") echo "checked"; ?> class="competentEx" />
                    </td>
                </tr>
                <tr id="skillWifi">
                    <td> I know how to connect with WIFI </td>
                    <td><input type="radio" name="skillWifi" value="0"
                            <?php if($enrollment->skillWifi == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillWifi" value="1"
                            <?php if($enrollment->skillWifi == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillWifi" value="2"
                            <?php if($enrollment->skillWifi == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillFolder">
                    <td> I can create, delete, copy, move and rename files/folders </td>
                    <td><input type="radio" name="skillFolder" value="0"
                            <?php if($enrollment->skillFolder == "0") echo "checked"; ?> class="noEx" />
                    </td>
                    <td><input type="radio" name="skillFolder" value="1"
                            <?php if($enrollment->skillFolder == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillFolder" value="2"
                            <?php if($enrollment->skillFolder == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillPdf">
                    <td> I can create, save, delete , move or rename a word and pdf document/s </td>
                    <td><input type="radio" name="skillPdf" value="0"
                            <?php if($enrollment->skillPdf == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillPdf" value="1"
                            <?php if($enrollment->skillPdf == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillPdf" value="2"
                            <?php if($enrollment->skillPdf == "2") echo "checked"; ?> class="competentEx" />
                    </td>
                </tr>
                <tr id="skillFront">
                    <td> I understand how to change font style, size, and colour, change margins, line
                        paragraph spacing, use tabs when dealing with word or pdf files. </td>
                    <td><input type="radio" name="skillFront" value="0"
                            <?php if($enrollment->skillFront == "0") echo "checked"; ?> class="noEx" />
                    </td>
                    <td><input type="radio" name="skillFront" value="1"
                            <?php if($enrollment->skillFront == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillFront" value="2"
                            <?php if($enrollment->skillFront == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillFooter">
                    <td> I can add, delete and edit header and footer of any word file. </td>
                    <td><input type="radio" name="skillFooter" value="0"
                            <?php if($enrollment->skillFooter == "0") echo "checked"; ?> class="noEx" />
                    </td>
                    <td><input type="radio" name="skillFooter" value="1"
                            <?php if($enrollment->skillFooter == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillFooter" value="2"
                            <?php if($enrollment->skillFooter == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillPage">
                    <td> Insert page numbers, file name, date time, pictures, bullet & numbered lists </td>
                    <td><input type="radio" name="skillPage" value="0"
                            <?php if($enrollment->skillPage == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillPage" value="1"
                            <?php if($enrollment->skillPage == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillPage" value="2"
                            <?php if($enrollment->skillPage == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillTable">
                    <td> Insert and edit tables </td>
                    <td><input type="radio" name="skillTable" value="0"
                            <?php if($enrollment->skillTable == "0") echo "checked"; ?> class="noEx" />
                    </td>
                    <td><input type="radio" name="skillTable" value="1"
                            <?php if($enrollment->skillTable == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillTable" value="2"
                            <?php if($enrollment->skillTable == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillClip">
                    <td> Use clip art, shapes, text boxes </td>
                    <td><input type="radio" name="skillClip" value="0"
                            <?php if($enrollment->skillClip == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillClip" value="1"
                            <?php if($enrollment->skillClip == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillClip" value="2"
                            <?php if($enrollment->skillClip == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillWww">
                    <td> Enter and understand web addresses (www) </td>
                    <td><input type="radio" name="skillWww" value="0"
                            <?php if($enrollment->skillWww == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillWww" value="1"
                            <?php if($enrollment->skillWww == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillWww" value="2"
                            <?php if($enrollment->skillWww == "2") echo "checked"; ?> class="competentEx" />
                    </td>
                </tr>
                <tr id="skillBr">
                    <td> Search for and access resources and information through a search browser </td>
                    <td><input type="radio" name="skillBr" value="0"
                            <?php if($enrollment->skillBr == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillBr" value="1"
                            <?php if($enrollment->skillBr == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillBr" value="2"
                            <?php if($enrollment->skillBr == "2") echo "checked"; ?> class="competentEx" />
                    </td>
                </tr>
                <tr id="skillDown">
                    <td> Download, store and print information from the Internet </td>
                    <td><input type="radio" name="skillDown" value="0"
                            <?php if($enrollment->skillDown == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillDown" value="1"
                            <?php if($enrollment->skillDown == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillDown" value="2"
                            <?php if($enrollment->skillDown == "2") echo "checked"; ?> class="competentEx" /> </td>
                </tr>
                <tr id="skillRef">
                    <td> Reference material sourced from the Internet </td>
                    <td><input type="radio" name="skillRef" value="0"
                            <?php if($enrollment->skillRef == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillRef" value="1"
                            <?php if($enrollment->skillRef == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillRef" value="2"
                            <?php if($enrollment->skillRef == "2") echo "checked"; ?> class="competentEx" />
                    </td>
                </tr>
                <tr id="skillCop">
                    <td> Understand the use of copyright material form electronic sources </td>
                    <td><input type="radio" name="skillCop" value="0"
                            <?php if($enrollment->skillCop == "0") echo "checked"; ?> class="noEx" /> </td>
                    <td><input type="radio" name="skillCop" value="1"
                            <?php if($enrollment->skillCop == "1") echo "checked"; ?> class="needSupportEx" /> </td>
                    <td><input type="radio" name="skillCop" value="2"
                            <?php if($enrollment->skillCop == "2") echo "checked"; ?> class="competentEx" />
                    </td>
                </tr>
            </table>
        </div>

    </div>
    <div class="tab">

        <div class="col-md-12">
            <table class="table table-bordered table-striped">
                <tr>
                    <th colspan="2"> 17. TERMS AND CONDITIONS FOR YOUR ENROLLMENT </th>
                </tr>
                <tr id="terms1">

                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" name="terms1" class="terms1" value="1"
                            <?php if($enrollment->terms1 == "1") echo "checked"; ?> />
                    </td>
                    <td>I agree to be bound by the College’s Student Code of Conduct, policies, and
                        procedures whilst I remain an enrolled student.
                    </td>
                </tr>
                <tr id="terms2">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" name="terms2" class="terms2" value="1"
                            <?php if($enrollment->terms2 == "1") echo "checked"; ?> />
                    </td>
                    <td>I agree if my employer or other contracted third party tends to offer me a course
                        from Hope training College of Australia then, a purchase order or authority to
                        invoice letter will be presented at time of fees payment.
                    </td>
                </tr>
                <tr id="terms3">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" name="terms3" class="terms3" value="1"
                            <?php if($enrollment->terms3 == "1") echo "checked"; ?> />
                    </td>
                    <td>I acknowledge and agree to the terms and conditions. By signing this form, I certify
                        that the information provided is true and correct. If any relevant information on my
                        application results to be false/failing then at discretion of Hope Training College
                        of Australia my enrolment offer may result in withdrawal or cancellation at any time
                        during the course period.
                    </td>
                </tr>
                <tr id="terms4">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" name="terms4" class="terms4" value="1"
                            <?php if($enrollment->terms4 == "1") echo "checked"; ?> />
                    </td>
                    <td>I acknowledge that I have read the student handbook available at the official
                        website of Hope Training College of Australia, www.hope.edu.au .</td>
                </tr>
                <tr id="terms5">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" name="terms5" class="terms5" value="1"
                            <?php if($enrollment->terms5 == "1") echo "checked"; ?> />
                    </td>
                    <td>I understand that my personal information is protected by law under the Privacy Act
                        1988 and Privacy Amendment Act 2014, and is collected by Hope Training College of
                        Australia to assess my eligibility of enrolment. The information is required to
                        process my application. My information may be used by Hope Training College of
                        Australia. Personal information will only be provided to other persons or agencies
                        with my permission or where required by law
                    </td>
                </tr>
                <tr id="terms6">
                    <td style="text-align: center; vertical-align: middle;">
                        <input type="checkbox" name="terms6" class="terms6" value="1"
                            <?php if($enrollment->terms6 == "1") echo "checked"; ?> />
                    </td>
                    <td>
                        I understand as per the Online Law act under the Privacy Act of 1988, When visiting
                        this site,
                        a record of my visit is logged. The following information is supplied by my browser
                        (for example Internet Explorer)
                        and collected by Hope Training College of Australia:
                        <ul>

                            <li>Client Address (i.e. IP address which is stored anonymously)</li>
                            <li>The date and time you accessed the site</li>


                        </ul>
                    </td>
                </tr>

                <tr>

                    <td colspan="2" style="text-align: center; vertical-align: middle;">
                        <h3>Before Submit your enrollment form, We suggest you to review it by pressing
                            Previous Button or Next Button.
                            Note : Once you submit it will not roll back.</h3>
                    </td>

                </tr>

            </table>
        </div>
    </div>

    <div class="col-sm-12">
        <div style="float:left;">
            <a href="/enrollusers/generatepdf/{{$enrollment->id}}" class="btn btn-sm btn-primary shadow-sm">
                Print Form <i class="fa fa-print"></i> </a>
        </div>
        <div style="float:right;">
            <button type="button" id="prevBtn" class="btn btn-sm btn-primary shadow-sm"
                onclick="nextPrev(-1)">Previous</button>
            &nbsp;
            <button type="button" id="nextBtn" class="btn btn-sm btn-primary shadow-sm"
                onclick="nextPrev(1)">Next</button>
        </div>
    </div>

    <div class="col-sm-12">
        <div class="hidden message  alert alert-danger" role="alert">&nbsp;</div>
        <!-- Circles which indicates the steps of the form: -->
        <div style="text-align:center;margin-top:40px;">
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
            <span class="step"></span>
        </div>


    </div>



    </form>
    </div>

    <div class="col-sm-12">&nbsp;</div>
    @endsection

    @section('javascript')
    <!-- Page level plugins -->
    <script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <!-- Page level custom scripts -->
    <script src="{{asset('js/datepicker.js')}}"></script>
    <script src="{{asset('js/edit-validation.js')}}"></script>
@endsection