@extends('layouts.admin')
@section('content')
<! -- DataTales Example -->
    <d iv class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Failed Enroll Users List</h6>
        </div>
        <div class="card-body">
            <div class="col-md-12">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">Course</th>
                            <th width="20%">Name</th>
                            <th width="20%">Email</th>
                            <th width="15%">Phone</th>
                            <th width="10%">Date of Birth</th>
                            <th width="10%">IP Address</th>
                            <th width="10%">View & Edit</th>
                            <th width="10%">Print Form</th>
                        </tr>

                    </thead>
                    <tfoot>
                        <tr>
                            <th width="5%">Course</th>
                            <th width="20%">Name</th>
                            <th width="20%">Email</th>
                            <th width="15%">Phone</th>
                            <th width="10%">Date of Birth</th>
                            <th width="10%">IP Address</th>
                            <th width="10%">View & Edit</th>
                            <th width="10%">Print Form</th>
                        </tr>
                    </tfoot>
                    <tbody>
                        @foreach($failedEnrollUsersList as $enrollUser)
                        <tr>
                            <td style="text-align: center; vertical-align: middle;">
                                @if($enrollUser->course == "0") {{"AHC"}}
                                @elseif($enrollUser->course == "1") {{"D"}}
                                @else {{"AHCD"}}
                                @endif
                            </td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->giveName}}</td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->email}}</td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->mobile}}</td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->dob}}</td>
                            <td style="text-align: center; vertical-align: middle;">{{$enrollUser->visitor}}</td>
                            <td>
                                <a href="/failedenrollusers/moredetails/{{$enrollUser->id}}"
                                    class="btn btn-info btn-icon-split btn-sm shadow-sm">
                                    <span class="icon text-white-50">
                                        <i class="fas fa-info-circle"></i>
                                    </span>
                                    <span class="text">View & Edit </span>
                                </a>
                            </td>
                            <td><a href="/failedenrollusers/generatepdf/{{$enrollUser->id}}"
                                    class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                                        class="fa fa-print"></i> Print Form</a></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        </div>
        @endsection
        @section('javascript')
    <!-- Page level plugins -->
    <script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <!-- Page level custom scripts -->
    <script src="{{ asset('js/demo/datatables-demo.js') }}"></script>
    <script src="{{asset('js/datepicker.js')}}"></script>
    
@endsection