<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Auth::routes();

Route::get('/fullcourseform', 'WelcomeController@index');
Route::get('/', 'WelcomeController@fullcourseform');
Route::get('/uocform', 'WelcomeController@uocform');


Route::get('/register', 'WelcomeController@index');
Route::get('/skipeduser', 'WelcomeController@skipeduser');
Route::get('/home', 'HomeController@index')->name('home');
Route::get('/logs', 'HomeController@logs');

Route::post('/enrollment/create', 'EnrollmentController@create');
Route::post('/enrollment/update', 'EnrollusersController@update');
Route::get('/enrollusers', 'EnrollusersController@index');
Route::get('/enrollusers/moredetails/{enrollment}', 'EnrollusersController@show');
Route::get('/enrollusers/generatepdf/{enrollment}', 'EnrollusersController@generatepdf');
Route::get('/enrollusers/generatepdf/{enrollment}', 'EnrollusersController@generatepdf');
Route::get('/enrollusers/generatelink/{enrollment}', 'EnrollusersController@generatelink');
Route::get('/enrollusers/paymentdetails/{enrollment}', 'EnrollusersController@paymentdetails');
//payment response
Route::get('/payment/confirmation', 'PaymentResponseController@create');


Route::post('/enrollusers/failed', 'FailedEnrollmentController@create');


Route::get('/failedenrollusers', 'FailedEnrollmentController@index');
Route::get('/failedenrollusers/moredetails/{enrollment}', 'FailedEnrollmentController@show');
Route::get('/failedenrollusers/generatepdf/{enrollment}', 'FailedEnrollmentController@generatepdf');
//Route::resource('enrollment', 'EnrollmentController');

